# 画面設計書 25-スマートリネームステータスコントロール

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるスマートリネーム機能のステータス表示コントロール（SmartRenameStatusControl）の設計を定義する。

### 本画面の処理概要

スマートリネームステータスコントロールは、Copilot連携によるスマートリネーム機能の状態（読み込み中、エラー等）を表示するためのユーザーコントロールである。リネームフライアウト内に配置され、ユーザーにAI処理の進行状況やエラー情報を通知する。

**業務上の目的・背景**：AI/Copilot連携機能は非同期処理であり、ネットワーク遅延やサービス障害が発生する可能性がある。ユーザーに処理状態を明確に伝えることで、操作の透明性を確保し、エラー発生時には適切な対応を促すことができる。

**画面へのアクセス方法**：
- リネームフライアウトが表示される際に、Copilot連携が有効な場合に自動的に追加される
- RenameFlyoutのMainPanelの子要素として、識別子入力グリッドの直後に配置される

**主要な操作・処理内容**：
1. ステータスメッセージの表示
2. エラー情報の表示

**画面遷移**：
- このコントロール単体での画面遷移はなし
- 親コントロール（RenameFlyout）の一部として動作

**権限による表示制御**：
- SmartRenameViewModelがnullでない場合（Copilot有効時）のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | 名前変更 (Rename) | 補助機能 | スマートリネームの状態（読み込み中・エラー等）表示 |
| 124 | Copilot連携 | 補助機能 | Copilot処理状態の表示 |

## 画面種別

表示コントロール（RenameFlyoutの子コントロール）

## URL/ルーティング

該当なし（Visual Studioエディタ内のコントロールとして表示）

## 入出力項目

該当なし（表示のみ）

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| ステータスメッセージ | StatusMessage | テキスト | 処理状態やエラーメッセージ |

## イベント仕様

このコントロールはイベントを発生させない。SmartRenameViewModelからのPropertyChangedイベントを監視し、StatusMessageプロパティの変更に応じて表示を更新する。

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | StatusMessageVisibilityがtrue | StatusMessageの内容を表示 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| Copilotエラー | ISmartRenameSessionからのStatusMessageをそのまま表示 |

## 備考

- 最大幅400pxでテキストは折り返し表示
- Visual Studioのテーマカラー（ComboBoxPopupBackgroundGradientBrushKey）を背景に使用
- StatusMessageVisibilityがfalseの場合は非表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ステータス情報のソースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SmartRenameViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` | StatusMessageとStatusMessageVisibilityプロパティ |

**読解のコツ**: SmartRenameViewModelはISmartRenameSessionからのStatusMessageをそのまま公開している。

#### Step 2: コントロール実装を理解する

コントロールの初期化と基本動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SmartRenameStatusControl.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameStatusControl.xaml.cs` | コンストラクタとDataContext設定 |

**主要処理フロー**:
1. **行14-18**: コンストラクタでViewModelをDataContextに設定

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SmartRenameStatusControl.xaml | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameStatusControl.xaml` | TextBlockとStackPanel構成 |

**主要処理フロー**:
- **行15-16**: StackPanelでVSテーマ背景を設定
- **行17-24**: TextBlockでStatusMessageを表示（MaxWidth=400、TextWrapping=Wrap）

### プログラム呼び出し階層図

```
RenameFlyout (コンストラクタ)
    │
    └─ SmartRenameStatusControl (Copilot有効時に生成)
           │
           ├─ InitializeComponent()
           │
           └─ DataContext = SmartRenameViewModel
                  │
                  ├─ StatusMessage (バインディング)
                  │      └─ ISmartRenameSession.StatusMessage
                  │
                  └─ StatusMessageVisibility (バインディング)
                         └─ ISmartRenameSession.StatusMessageVisibility
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ISmartRenameSession ──▶ SmartRenameViewModel ───▶ SmartRenameStatusControl
      │                        │                         │
      ├─ StatusMessage         │                         ▼
      │                        ▼                  TextBlock表示
      └─ StatusMessageVisibility ───▶ Visibility変換
                                              │
                                              ▼
                                       表示/非表示制御
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SmartRenameStatusControl.xaml | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameStatusControl.xaml` | XAML | UI定義 |
| SmartRenameStatusControl.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameStatusControl.xaml.cs` | ソース | コードビハインド |
| SmartRenameViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` | ソース | ViewModel |
| RenameFlyout.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` | ソース | 親コントロール（行79-81で追加） |
