# 画面設計書 26-オンザフライドキュメントビュー

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるオンザフライドキュメントビュー（OnTheFlyDocsView）の設計を定義する。

### 本画面の処理概要

オンザフライドキュメントビューは、エディタ上でシンボルにホバーした際に表示されるクイック情報（QuickInfo）ツールチップ内で、Copilotを利用したオンデマンドのドキュメント生成機能を提供するユーザーコントロールである。ユーザーが「Describe」リンクをクリックすると、AIがシンボルの説明を生成して表示する。

**業務上の目的・背景**：コードベースには十分なドキュメントが存在しないことが多く、開発者はシンボルの動作を理解するためにコードを読む必要がある。Copilotを活用したオンザフライドキュメント機能により、ドキュメントコメントがない場合でも、AIがコンテキストを分析して説明を生成することで、コード理解を支援する。

**画面へのアクセス方法**：
- エディタ上でシンボルにマウスカーソルをホバー
- クイック情報ツールチップが表示される
- ツールチップ内の「Describe」（スパークルアイコン付き）リンクをクリック

**主要な操作・処理内容**：
1. 「Describe」リンクの表示（オンデマンドリンク状態）
2. リンクのクリックによるドキュメント生成リクエスト
3. 読み込み中の進捗表示
4. 生成されたドキュメントの表示
5. クォータ超過時のアップグレード誘導

**画面遷移**：
- 遷移元: クイック情報ツールチップ（ホバー時）
- このコントロール自体は3つの状態を遷移: OnDemandLink → Loading → Finished

**権限による表示制御**：
- Copilot連携が有効な場合のみ表示される
- 参照ドキュメントが組織によって除外されている場合、リンクが無効化される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | クイック情報 (QuickInfo) | 主機能 | ホバー時のドキュメント情報のオンデマンド表示 |
| 124 | Copilot連携 | 補助機能 | Copilot連携によるドキュメント生成 |

## 画面種別

表示コントロール（クイック情報ツールチップの子要素）

## URL/ルーティング

該当なし（Visual Studioエディタ内のコントロールとして表示）

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 説明 |
|--------|--------|---------|----------|------|------|
| オンザフライドキュメント情報 | OnTheFlyDocsInfo | OnTheFlyDocsInfo | 入力 | 必須 | 対象シンボルの情報 |
| ドキュメント | Document | Document | 入力 | 必須 | 現在のドキュメント |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| オンデマンドリンク | OnDemandLinkContent | ハイパーリンク | 「Describe」リンク（スパークルアイコン付き） |
| 読み込み中コンテンツ | LoadingContent | テキスト+プログレスバー | 「Copilot thinking...」と進捗バー |
| 結果コンテンツ | ResultsContent | テキスト | Copilotラベル+生成されたドキュメント |

## イベント仕様

### 1-ResultsRequested

「Describe」リンクがクリックされた際に発火するイベント。

処理フロー:
1. CurrentStateをLoadingに変更
2. テレメトリログを記録
3. PopulateAIDocumentationElementsを呼び出し
4. ICopilotCodeAnalysisServiceからプロンプトを取得
5. Copilot APIからレスポンスを取得
6. 結果をUIに表示
7. CurrentStateをFinishedに変更

### 2-PlanUpgradeRequested

クォータ超過時にアップグレードリンクがクリックされた際に発火するイベント。

処理フロー:
1. VS UIShellのPostExecCommandでCopilotフリープランアップグレードダイアログを表示
2. クイック情報セッションを閉じる
3. テレメトリを送信

## 状態遷移

| 状態 | 説明 | 表示内容 |
|------|------|---------|
| OnDemandLink | 初期状態 | 「Describe」リンクを表示 |
| Loading | ドキュメント生成中 | 「Copilot thinking...」とプログレスバー |
| Finished | 生成完了 | Copilotラベルと生成されたドキュメント |

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | 読み込み中 | "Copilot thinking..." |
| - | エラー | 生成エラー時 | "An error occurred while generating documentation for this code" |
| - | 警告 | クォータ超過時 | "Chat limit reached. [Upgrade now] or wait for the limit to reset." |
| - | 情報 | コンテンツ除外時 | "Describe is unavailable since the referenced document is excluded by your organization" |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| Copilot接続エラー | エラーメッセージを表示 |
| クォータ超過 | アップグレードリンク付きのメッセージを表示 |
| 操作キャンセル | テレメトリログを記録して終了 |
| コンテンツ除外 | 「利用不可」メッセージを表示 |

## 備考

- Copilotスパークルアイコンを使用してAI機能であることを示す
- 読み込み中はSmoothProgressBarでアニメーション表示
- IAsyncQuickInfoSessionと連携してセッション終了時にキャンセル

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、オンザフライドキュメント情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OnTheFlyDocsView.xaml.cs | `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml.cs` | コンストラクタでの初期化とプロパティ定義 |

**読解のコツ**: INotifyPropertyChangedを実装し、CurrentStateプロパティの変更で表示を切り替えている。

#### Step 2: エントリーポイントを理解する

コントロールの初期化と基本動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OnTheFlyDocsView.xaml.cs | `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml.cs` | コンストラクタ（行73-163）とSetResultTextAsync（行185-273） |

**主要処理フロー**:
1. **行73-163**: コンストラクタでUI要素の構築（OnDemandLink、Loading、Results）
2. **行169-183**: PopulateAIDocumentationElementsでCopilotサービス呼び出し
3. **行185-273**: SetResultTextAsyncでレスポンス処理と表示更新

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OnTheFlyDocsView.xaml | `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml` | Grid内の3つのContentControl |

**主要処理フロー**:
- **行14-19**: OnDemandLink状態のContentControl
- **行20-24**: Loading状態のContentControl
- **行25-29**: Finished状態のContentControl
- **行11**: OnTheFlyDocsViewStateVisibilityConverterで状態に応じた表示切替

### プログラム呼び出し階層図

```
QuickInfoPresenter
    │
    └─ OnTheFlyDocsView (生成)
           │
           ├─ コンストラクタ
           │      ├─ OnDemandLinkContent構築
           │      ├─ LoadingContent構築
           │      └─ ResultsContent構築
           │
           ├─ RequestResults() ("Describe"クリック時)
           │      └─ CurrentState = Loading
           │
           └─ PopulateAIDocumentationElements()
                  │
                  ├─ ICopilotCodeAnalysisService.GetOnTheFlyDocsPromptAsync()
                  │
                  ├─ ICopilotCodeAnalysisService.GetOnTheFlyDocsResponseAsync()
                  │
                  └─ SetResultTextAsync()
                         └─ CurrentState = Finished
```

### データフロー図

```
[入力]                    [処理]                         [出力]

シンボル情報 ───▶ OnTheFlyDocsInfo ───▶ ICopilotCodeAnalysisService
    │                        │                    │
    │                        ▼                    ▼
    │              GetOnTheFlyDocsPromptAsync    Copilot API
    │                        │                    │
    │                        ▼                    ▼
    │              GetOnTheFlyDocsResponseAsync ◀─┘
    │                        │
    │                        ▼
    │              _responseControl.Content ───▶ UI表示
    │
"Describe"クリック ──▶ CurrentState変更 ───▶ 表示状態切替
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OnTheFlyDocsView.xaml | `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml` | XAML | UI定義 |
| OnTheFlyDocsView.xaml.cs | `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml.cs` | ソース | コードビハインド |
| OnTheFlyDocsState.cs | `src/EditorFeatures/Core/QuickInfo/` | ソース | 状態列挙型 |
| ICopilotCodeAnalysisService.cs | `src/Features/Core/Portable/Copilot/` | ソース | Copilotサービスインターフェース |
