# 画面設計書 27-グリッドオプションプレビューコントロール

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるグリッドオプションプレビューコントロール（GridOptionPreviewControl）の設計を定義する。

### 本画面の処理概要

グリッドオプションプレビューコントロールは、Visual Studioのオプション設定画面（ツール > オプション）で、コードスタイルオプションをグリッド形式で表示し、選択したオプションのプレビューをエディタ領域に表示するコントロールである。また、現在の設定を.editorconfigファイルとして出力する機能も提供する。

**業務上の目的・背景**：コードスタイル設定は開発チーム内での一貫性を保つために重要である。このコントロールは、各コードスタイルオプションの説明、プレビュー、重大度をグリッド形式で一覧表示し、直感的な設定操作を可能にする。また、.editorconfigへのエクスポート機能により、チーム全体での設定共有を容易にしている。

**画面へのアクセス方法**：
- メニューバーから「ツール」→「オプション」を選択
- 「テキストエディター」→「C#」（または「Visual Basic」）→「コードスタイル」を選択

**主要な操作・処理内容**：
1. コードスタイルオプションの一覧表示（DataGrid）
2. オプション選択時のプレビュー更新
3. プレファレンス（優先設定）のドロップダウン選択
4. 重大度（Severity）のドロップダウン選択
5. 「Generate .editorconfig file from settings」ボタンによるエクスポート

**画面遷移**：
- 遷移元: Visual Studioオプションダイアログ
- 遷移先: なし（オプションダイアログ内のコントロール）

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | コードスタイルオプションのグリッド形式プレビュー表示 |

## 画面種別

設定画面（オプションページコントロール）

## URL/ルーティング

該当なし（Visual Studioオプションダイアログ内）

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 説明 |
|--------|--------|---------|----------|------|------|
| コードスタイルアイテム | CodeStyleItems | ObservableCollection | 出力 | - | コードスタイルオプションのリスト |
| テキストビューホスト | TextViewHost | IWpfTextViewHost | 出力 | - | プレビュー用エディタ |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| 説明ヘッダー | DescriptionHeader | 列ヘッダー | "Description" |
| プレファレンスヘッダー | PreferenceHeader | 列ヘッダー | "Preference" |
| 重大度ヘッダー | SeverityHeader | 列ヘッダー | "Severity" |
| 説明 | Description | テキスト | オプションの説明テキスト |
| プレファレンス | Preferences | コンボボックス | 優先設定の選択肢 |
| 重大度 | NotificationPreferences | コンボボックス | None/Suggestion/Warning/Error |
| プレビュー | EditorControl | エディタ | 選択オプションのコードプレビュー |

## イベント仕様

### 1-Options_SelectionChanged

DataGridでオプションが選択された際の処理。

処理フロー:
1. 選択されたCodeStyleItemを取得
2. ViewModelのUpdatePreviewを呼び出し
3. プレビューエディタの内容を更新

### 2-Generate_Save_EditorConfig

「Generate .editorconfig file from settings」ボタンがクリックされた際の処理。

処理フロー:
1. テレメトリログを記録
2. EditorConfigFileGeneratorで.editorconfig内容を生成
3. SaveFileDialogを表示
4. 選択されたパスにファイルを保存

## データベース更新仕様

該当なし（Visual Studio設定ストアへの保存）

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | EditorConfig優先通知 | CodeStyleNoticeTextBlockの内容（EditorConfig優先の説明） |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| ファイル保存エラー | IOUtilities.PerformIOで例外をキャッチして処理 |

## 備考

- AbstractOptionPageControlを継承
- CodeStyleNoticeTextBlockでEditorConfig優先の通知を表示
- GridSplitterでプレビュー領域のサイズを調整可能
- グループ化されたオプション表示に対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、OptionPageコントロールの基底クラスとViewModelを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractOptionPageControl.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPageControl.cs` | 基底クラスの構造とライフサイクル |
| 1-2 | AbstractOptionPreviewViewModel.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPreviewViewModel.cs` | ViewModelの基底クラス |

**読解のコツ**: OnLoad/OnSave/Closeのライフサイクルメソッドが重要。

#### Step 2: エントリーポイントを理解する

コントロールの初期化と基本動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GridOptionPreviewControl.xaml.cs | `src/VisualStudio/Core/Impl/Options/GridOptionPreviewControl.xaml.cs` | コンストラクタとイベントハンドラ |

**主要処理フロー**:
1. **行40-55**: コンストラクタでファクトリーと言語情報を保持
2. **行87-95**: OnLoadでViewModelを作成しDataContextに設定
3. **行104-124**: Generate_Save_EditorConfigでファイル出力

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GridOptionPreviewControl.xaml | `src/VisualStudio/Core/Impl/Options/GridOptionPreviewControl.xaml` | DataGridとエディタの配置 |

**主要処理フロー**:
- **行44**: CodeStyleNoticeTextBlockの配置
- **行45-53**: EditorConfig生成ボタン
- **行54-183**: DataGridの定義（列テンプレート含む）
- **行184-187**: GridSplitterとプレビューエディタ

### プログラム呼び出し階層図

```
Visual Studioオプションダイアログ
    │
    └─ GridOptionPreviewControl
           │
           ├─ OnLoad()
           │      └─ _createViewModel() → AbstractOptionPreviewViewModel
           │
           ├─ Options_SelectionChanged()
           │      └─ ViewModel.UpdatePreview()
           │
           ├─ Generate_Save_EditorConfig()
           │      ├─ EditorConfigFileGenerator.Generate()
           │      └─ SaveFileDialog.ShowDialog()
           │
           └─ Close()
                  └─ ViewModel.Dispose()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

OptionStore ───────▶ AbstractOptionPreviewViewModel ───▶ CodeStyleItems
    │                        │                              │
    │                        ▼                              ▼
    │                 SetOptionAndUpdatePreview         DataGrid表示
    │                        │
    │                        ▼
オプション選択 ──────▶ UpdatePreview() ───▶ TextViewHost
                                                  (プレビューエディタ)
    │
    │
EditorConfig生成 ──▶ EditorConfigFileGenerator ───▶ .editorconfigファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GridOptionPreviewControl.xaml | `src/VisualStudio/Core/Impl/Options/GridOptionPreviewControl.xaml` | XAML | UI定義 |
| GridOptionPreviewControl.xaml.cs | `src/VisualStudio/Core/Impl/Options/GridOptionPreviewControl.xaml.cs` | ソース | コードビハインド |
| AbstractOptionPageControl.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPageControl.cs` | ソース | 基底クラス |
| AbstractOptionPreviewViewModel.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPreviewViewModel.cs` | ソース | ViewModel基底 |
| CodeStyleNoticeTextBlock.xaml | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml` | XAML | EditorConfig通知 |
| EditorConfigFileGenerator.cs | `src/VisualStudio/Core/Impl/Options/EditorConfigFileGenerator.cs` | ソース | EditorConfig生成 |
