# 画面設計書 28-オプションプレビューコントロール

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるオプションプレビューコントロール（OptionPreviewControl）の設計を定義する。

### 本画面の処理概要

オプションプレビューコントロールは、Visual Studioのオプション設定画面（ツール > オプション）で、チェックボックスやラジオボタン形式のオプション項目をリスト表示し、選択したオプションのプレビューをエディタ領域に表示するコントロールである。GridOptionPreviewControlと異なり、シンプルなリスト形式でオプションを表示する。

**業務上の目的・背景**：Visual Studioの各種オプション設定（インデント、書式設定等）において、設定項目とその効果を直感的に理解できるUIを提供する。ユーザーがオプションを選択すると、右側のプレビュー領域で実際のコードがどのように表示されるかを確認できるため、設定の効果を理解しやすい。

**画面へのアクセス方法**：
- メニューバーから「ツール」→「オプション」を選択
- 「テキストエディター」配下の各言語設定ページで使用

**主要な操作・処理内容**：
1. オプション項目のリスト表示（チェックボックス/ラジオボタン）
2. オプション選択時のプレビュー更新
3. チェックボックスのオン/オフ切替
4. ラジオボタングループ内での選択切替
5. Spaceキーによるオプションの切替

**画面遷移**：
- 遷移元: Visual Studioオプションダイアログ
- 遷移先: なし（オプションダイアログ内のコントロール）

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | オプション設定のプレビューエディタ表示 |

## 画面種別

設定画面（オプションページコントロール）

## URL/ルーティング

該当なし（Visual Studioオプションダイアログ内）

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 説明 |
|--------|--------|---------|----------|------|------|
| オプションアイテム | Items | ObservableCollection | 出力 | - | オプション項目のリスト |
| テキストビューホスト | TextViewHost | IWpfTextViewHost | 出力 | - | プレビュー用エディタ |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| チェックボックス | AbstractCheckBoxViewModel | チェックボックス+テキスト | チェックボックス形式のオプション |
| ラジオボタン | AbstractRadioButtonViewModel | ラジオボタン+テキスト | ラジオボタン形式のオプション |
| ヘッダー | HeaderItemViewModel | テキスト | セクションヘッダー |
| プレビュー | EditorControl | エディタ | 選択オプションのコードプレビュー |

## イベント仕様

### 1-Options_SelectionChanged

ListViewでオプションが選択された際の処理。

処理フロー:
1. 選択されたアイテムがCheckBoxViewModelの場合、ViewModelのUpdatePreviewを呼び出し
2. 選択されたアイテムがRadioButtonViewModelの場合、ViewModelのUpdatePreviewを呼び出し
3. プレビューエディタの内容を更新

### 2-Options_PreviewKeyDown

Spaceキーが押された際の処理。

処理フロー:
1. 選択されたアイテムがCheckBoxViewModelの場合、IsCheckedを反転
2. 選択されたアイテムがRadioButtonViewModelの場合、IsCheckedをtrueに設定
3. イベントをハンドル済みとしてマーク

## データベース更新仕様

該当なし（Visual Studio設定ストアへの保存）

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | EditorConfig優先通知 | CodeStyleNoticeTextBlockの内容（EditorConfig優先の説明） |

## 例外処理

特になし

## 備考

- AbstractOptionPageControlを継承
- AutomationDelegatingListViewを使用してアクセシビリティに対応
- DataTemplateでチェックボックス、ラジオボタン、ヘッダーの表示を制御
- CodeStyleNoticeTextBlockでEditorConfig優先の通知を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、オプション項目のViewModelを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractCheckBoxViewModel.cs | `src/VisualStudio/Core/Impl/Options/AbstractCheckBoxViewModel.cs` | チェックボックスViewModelの構造 |
| 1-2 | AbstractRadioButtonViewModel.cs | `src/VisualStudio/Core/Impl/Options/AbstractRadioButtonViewModel.cs` | ラジオボタンViewModelの構造 |
| 1-3 | HeaderItemViewModel.cs | `src/VisualStudio/Core/Impl/Options/HeaderItemViewModel.cs` | ヘッダーViewModelの構造 |

**読解のコツ**: DataTemplateとの連携を意識して各ViewModelの役割を理解する。

#### Step 2: エントリーポイントを理解する

コントロールの初期化と基本動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OptionPreviewControl.xaml.cs | `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml.cs` | コンストラクタとイベントハンドラ |

**主要処理フロー**:
1. **行24-46**: コンストラクタでAutomationDelegatingListViewを作成しイベント登録
2. **行48-60**: Options_SelectionChangedでプレビュー更新
3. **行62-79**: Options_PreviewKeyDownでSpaceキー処理

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OptionPreviewControl.xaml | `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml` | DataTemplateとレイアウト |

**主要処理フロー**:
- **行16-27**: AbstractCheckBoxViewModelのDataTemplate
- **行29-31**: HeaderItemViewModelのDataTemplate
- **行33-45**: AbstractRadioButtonViewModelのDataTemplate
- **行54-55**: CodeStyleNoticeTextBlockとlistViewContentControl
- **行56-60**: プレビューエディタ

### プログラム呼び出し階層図

```
Visual Studioオプションダイアログ
    │
    └─ OptionPreviewControl
           │
           ├─ コンストラクタ
           │      └─ AutomationDelegatingListView作成
           │
           ├─ OnLoad()
           │      └─ _createViewModel() → AbstractOptionPreviewViewModel
           │
           ├─ Options_SelectionChanged()
           │      └─ ViewModel.UpdatePreview()
           │
           ├─ Options_PreviewKeyDown()
           │      └─ IsChecked反転/設定
           │
           └─ Close()
                  └─ ViewModel.Dispose()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

OptionStore ───────▶ AbstractOptionPreviewViewModel ───▶ Items
    │                        │                              │
    │                        ▼                              ▼
    │                 SetOptionAndUpdatePreview         ListView表示
    │                        │
    │                        ▼
オプション選択 ──────▶ UpdatePreview() ───▶ TextViewHost
    │                                         (プレビューエディタ)
    │
Spaceキー押下 ──────▶ IsChecked切替 ───▶ オプション状態更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OptionPreviewControl.xaml | `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml` | XAML | UI定義 |
| OptionPreviewControl.xaml.cs | `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml.cs` | ソース | コードビハインド |
| AbstractOptionPageControl.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPageControl.cs` | ソース | 基底クラス |
| AbstractOptionPreviewViewModel.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPreviewViewModel.cs` | ソース | ViewModel基底 |
| AbstractCheckBoxViewModel.cs | `src/VisualStudio/Core/Impl/Options/AbstractCheckBoxViewModel.cs` | ソース | チェックボックスViewModel |
| AbstractRadioButtonViewModel.cs | `src/VisualStudio/Core/Impl/Options/AbstractRadioButtonViewModel.cs` | ソース | ラジオボタンViewModel |
| AutomationDelegatingListView.cs | `src/VisualStudio/Core/Impl/Utilities/AutomationDelegatingListView.cs` | ソース | アクセシビリティ対応ListView |
| CodeStyleNoticeTextBlock.xaml | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml` | XAML | EditorConfig通知 |
