# 画面設計書 29-コードスタイル通知テキストブロック

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるコードスタイル通知テキストブロック（CodeStyleNoticeTextBlock）の設計を定義する。

### 本画面の処理概要

コードスタイル通知テキストブロックは、Visual Studioのオプション設定画面でEditorConfigファイルが設定を上書きする可能性があることをユーザーに通知するためのテキストブロックコントロールである。複数のオプションページで再利用され、EditorConfigの優先度に関する情報と「Learn more」リンクを提供する。

**業務上の目的・背景**：EditorConfigファイルはプロジェクト単位でコードスタイルを定義できるため、Visual Studioのグローバル設定よりも優先される。ユーザーがオプションダイアログで設定を変更しても、EditorConfigにより上書きされる可能性があることを事前に警告することで、設定の混乱を防ぎ、EditorConfigの利用を促進する。

**画面へのアクセス方法**：
- 直接アクセスはなし（他のオプションページコントロール内で使用される）
- GridOptionPreviewControl、OptionPreviewControl、NamingStyleOptionPageControl等で使用

**主要な操作・処理内容**：
1. EditorConfig優先に関する説明テキストの表示
2. 「Learn more」ハイパーリンクのクリックでブラウザを開く

**画面遷移**：
- 「Learn more」リンククリック時に外部ブラウザでMicrosoft Docsを表示

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | EditorConfig優先設定の警告通知表示 |

## 画面種別

表示コントロール（他のオプションページの子要素）

## URL/ルーティング

該当なし

## 入出力項目

該当なし（表示のみ）

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| ヘッダーテキスト | CodeStylePageHeader | テキスト | EditorConfig優先の説明文 |
| Learn Moreリンク | CodeStylePageHeaderLearnMoreText | ハイパーリンク | Microsoft Docsへのリンク |

## イベント仕様

### 1-LearnMoreHyperlink_RequestNavigate

「Learn more」リンクがクリックされた際の処理。

処理フロー:
1. e.Uriがnullでないことを確認
2. VisualStudioNavigateToLinkService.StartBrowserでブラウザを起動
3. e.Handled = trueを設定

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | 常時 | "Code style preferences and analyzers can be configured using EditorConfig. [Learn more]" 等 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| URI無効 | リンクナビゲーションをスキップ |

## 備考

- TextBlockを継承
- 使用されるURI: https://go.microsoft.com/fwlink/?linkid=866541
- ServicesVSResources.Code_style_header_use_editorconfigからテキストを取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、静的プロパティの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CodeStyleNoticeTextBlock.xaml.cs | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml.cs` | 静的プロパティとイベントハンドラ |

**読解のコツ**: リソースファイル（ServicesVSResources）からローカライズされたテキストを取得している。

#### Step 2: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeStyleNoticeTextBlock.xaml | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml` | Runと Hyperlinkの構成 |

**主要処理フロー**:
- **行11**: Run要素でCodeStylePageHeaderテキストを表示
- **行12**: スペース用のRun
- **行13-17**: Hyperlink要素でLearn Moreリンクを表示

### プログラム呼び出し階層図

```
GridOptionPreviewControl / OptionPreviewControl / NamingStyleOptionPageControl
    │
    └─ CodeStyleNoticeTextBlock
           │
           ├─ InitializeComponent()
           │
           └─ LearnMoreHyperlink_RequestNavigate()
                  └─ VisualStudioNavigateToLinkService.StartBrowser()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ServicesVSResources ───▶ 静的プロパティ ───▶ XAML表示
    │                                              │
    ├─ Code_style_header_use_editorconfig          ▼
    │                                         ヘッダーテキスト
    └─ Learn_more
                                                   │
                                                   ▼
「Learn more」クリック ──▶ RequestNavigate ───▶ ブラウザ起動
                                   │
                                   ▼
                           Microsoft Docsページ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeStyleNoticeTextBlock.xaml | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml` | XAML | UI定義 |
| CodeStyleNoticeTextBlock.xaml.cs | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml.cs` | ソース | コードビハインド |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
| VisualStudioNavigateToLinkService.cs | `src/VisualStudio/Core/Impl/Utilities/VisualStudioNavigateToLinkService.cs` | ソース | ブラウザ起動ユーティリティ |
| GridOptionPreviewControl.xaml | `src/VisualStudio/Core/Impl/Options/GridOptionPreviewControl.xaml` | XAML | 使用元 |
| OptionPreviewControl.xaml | `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml` | XAML | 使用元 |
| NamingStyleOptionPageControl.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml` | XAML | 使用元 |
