# 画面設計書 3-型生成ダイアログ

## 概要

本ドキュメントは、Visual Studio IDE上で新しい型（クラス、インターフェース、構造体等）を生成するためのダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

型生成ダイアログは、コード内で未定義の型名を使用した際に、その型を自動生成するためのリファクタリング機能を提供する画面である。

**業務上の目的・背景**：開発者がコード内で新しい型を参照しているが、その型がまだ定義されていない場合、IDEは「Generate Type」クイックアクションを提供する。本ダイアログは、生成する型のアクセス修飾子、種類（クラス、構造体、インターフェース等）、配置先（プロジェクト、ファイル）を指定するインターフェースを提供する。

**画面へのアクセス方法**：エディタ内で未定義の型名にカーソルを置き、クイックアクション（電球アイコン）から「Generate type...」を選択する。

**主要な操作・処理内容**：
1. アクセス修飾子の選択（public, internal等）
2. 型の種類の選択（class, struct, interface, enum, delegate）
3. 型名の確認（読み取り専用）
4. 配置先プロジェクトの選択
5. 配置先ファイルの選択
   - 新規ファイルを作成
   - 既存ファイルに追加
6. OKボタンで生成実行、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：エディタコンテキストメニュー、クイックアクション
- 遷移先：なし
- 戻り先：エディタ（OK/Cancel時）

**権限による表示制御**：
- 選択可能なアクセス修飾子は現在のコンテキストによって制限される場合がある
- 既存ファイル選択は対応するファイルが存在する場合のみ有効

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 39 | 型生成 | 主機能 | 新規クラス・インターフェース等の生成設定 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| AccessList | 入力 | List<string> | Yes | 選択可能なアクセス修飾子リスト |
| KindList | 入力 | List<string> | Yes | 選択可能な型種別リスト |
| TypeName | 入力 | string | Yes | 生成する型名（読み取り専用） |
| ProjectList | 入力 | List<ProjectEntry> | Yes | 選択可能なプロジェクト一覧 |
| DocumentList | 入力 | List<DocumentEntry> | No | 既存ファイル一覧 |
| SelectedAccessibility | 出力 | string | Yes | 選択されたアクセス修飾子 |
| SelectedTypeKind | 出力 | string | Yes | 選択された型種別 |
| SelectedProject | 出力 | Project | Yes | 選択されたプロジェクト |
| IsNewFile | 出力 | bool | Yes | 新規ファイル作成かどうか |
| FileName | 出力 | string | No | 新規ファイル名 |
| SelectedDocument | 出力 | Document | No | 選択された既存ファイル |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| Access | AccessList | ComboBox | アクセス修飾子選択 |
| Kind | KindList | ComboBox | 型種別選択 |
| Name | TypeName | TextBox（読み取り専用） | 型名表示 |
| Project | ProjectList | ComboBox | プロジェクト選択 |
| Create new file | FileName/ProjectFolders | RadioButton + ComboBox | 新規ファイル作成 |
| Add to existing file | DocumentList | RadioButton + ComboBox | 既存ファイル選択 |

## イベント仕様

### 1-アクセス修飾子選択変更

ComboBoxでアクセス修飾子を変更。SelectedAccessibilityStringプロパティが更新される。

### 2-型種別選択変更

ComboBoxで型の種類を変更。SelectedTypeKindStringプロパティが更新され、ファイル名の拡張子も対応するものに変更される。

### 3-プロジェクト選択変更

プロジェクトを変更すると以下が更新される：
- 利用可能なフォルダ一覧（ProjectFolders）
- 既存ファイル一覧（DocumentList）
- ファイル名のデフォルト値

### 4-新規ファイル作成選択

ラジオボタン選択時にファイル名入力ComboBoxが有効化される。ComboBoxは編集可能で、プロジェクト内のフォルダも選択可能。

### 5-既存ファイル選択

ラジオボタン選択時に既存ファイル一覧ComboBoxが有効化される。対応するファイルがない場合はラジオボタン自体が無効化される。

### 6-ファイル名フォーカス喪失

ファイル名入力欄からフォーカスが外れた時、UpdateFileNameExtension()が呼ばれ、適切な拡張子が付与される。

### 7-OK確定

TrySubmit()でバリデーション実行後、DialogResult=trueで閉じる。

### 8-キャンセル

DialogResult=falseでダイアログを閉じる。

### キーボードショートカット

| キー | 機能 |
|-----|------|
| Alt+A | アクセス修飾子ComboBoxにフォーカス |
| Alt+K | 型種別ComboBoxにフォーカス |
| Alt+P | プロジェクトComboBoxにフォーカス |
| Alt+C | 新規ファイル作成ラジオボタンにフォーカス |
| Alt+X | 既存ファイルラジオボタンにフォーカス |

## データベース更新仕様

該当なし（データベースアクセスなし、ソースコード生成操作）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| エラー | ERR_INVALID_INPUT | 入力が無効です | バリデーション失敗時 |

## 例外処理

| 状態 | 対応 |
|------|------|
| プロジェクトが見つからない | ダイアログを表示せずエラー通知 |
| ファイル作成権限なし | エラーメッセージを表示 |

## 備考

- ヘルプトピック: vsl.GenerateFromUsage
- ダイアログサイズ: 460x353（最小370x460）
- VSThemeDictionary.xamlを参照してテーマ対応
- 型名は読み取り専用（Opacity 0.56でグレーアウト表示）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GenerateTypeDialogViewModel.cs | `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialogViewModel.cs` | ダイアログのデータモデル全体 |
| 1-2 | ProjectEntry / DocumentEntry | ViewModel内の内部クラス | プロジェクト・ドキュメントの表示用ラッパー |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GenerateTypeDialog.xaml.cs | `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml.cs` | ダイアログのコードビハインド |

**主要処理フロー**:
1. **行35-43**: コンストラクタでViewModelをバインド、コマンドバインディング設定
2. **行45-81**: SetCommandBindingsでキーボードショートカット登録
3. **行98-100**: UpdateFileNameExtensionでファイル拡張子を更新
4. **行101-108**: OK_Clickでバリデーション実行

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GenerateTypeDialog.xaml | `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml` | UIレイアウトとバインディング |

**主要処理フロー**:
- **行28-78**: Type Details セクション（アクセス、種別、名前）
- **行79-79**: 区切り線
- **行80-100**: Location セクション（プロジェクト選択）
- **行102-143**: File Name セクション（新規/既存ファイル選択）
- **行145-165**: OK/Cancelボタン

### プログラム呼び出し階層図

```
GenerateTypeDialog (UI)
    │
    ├─ GenerateTypeDialogViewModel
    │      ├─ AccessList / KindList (選択肢)
    │      ├─ ProjectList / DocumentList (配置先)
    │      ├─ UpdateFileNameExtension (拡張子補正)
    │      └─ TrySubmit (バリデーション)
    │
    └─ CommandBindings
           ├─ SelectAccessKind (Alt+A)
           ├─ SelectTypeKind (Alt+K)
           ├─ SelectProject (Alt+P)
           ├─ CreateNewFile (Alt+C)
           └─ AddToExistingFile (Alt+X)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

未定義型名 ─────────▶ GenerateTypeDialog ──────────▶ 新規型ファイル
     │                       │
     ├─ アクセス修飾子        │
     ├─ 型種別               │
     ├─ プロジェクト         │
     └─ ファイル名           │
                            ▼
                    GenerateTypeResult
                    (型定義コード生成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GenerateTypeDialog.xaml | `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml` | XAML | ダイアログUI定義 |
| GenerateTypeDialog.xaml.cs | `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml.cs` | ソース | コードビハインド |
| GenerateTypeDialogViewModel.cs | `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialogViewModel.cs` | ソース | ViewModel |
| VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | リソース | テーマ定義 |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
