# 画面設計書 30-命名スタイルオプションページコントロール

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能における命名スタイルオプションページコントロール（NamingStyleOptionPageControl）の設計を定義する。

### 本画面の処理概要

命名スタイルオプションページコントロールは、Visual Studioのオプション設定画面（ツール > オプション）で、コードの命名規則（Naming Conventions）を設定するためのコントロールである。シンボル仕様（どのシンボルに適用するか）、命名スタイル（どのような命名規則を適用するか）、重大度（違反時の警告レベル）を組み合わせたルールをDataGrid形式で管理できる。

**業務上の目的・背景**：一貫した命名規則はコードの可読性と保守性を高める。このコントロールは、チームやプロジェクトで定義した命名規則をVisual Studioに設定し、規則違反時に警告やエラーを表示させることで、コード品質の向上を支援する。ルールは優先順位（上から順）で適用されるため、並び替え機能も提供している。

**画面へのアクセス方法**：
- メニューバーから「ツール」→「オプション」を選択
- 「テキストエディター」→「C#」（または「Visual Basic」）→「コードスタイル」→「命名」を選択

**主要な操作・処理内容**：
1. 命名規則のDataGrid表示
2. 規則の追加（Addボタン）
3. 規則の削除（行ごとの削除ボタン）
4. 規則の並び替え（上下矢印ボタンまたはAlt+↑/↓）
5. シンボル仕様のドロップダウン選択
6. 命名スタイルのドロップダウン選択
7. 重大度のドロップダウン選択
8. シンボル仕様の管理ダイアログを開く
9. 命名スタイルの管理ダイアログを開く

**画面遷移**：
- 遷移元: Visual Studioオプションダイアログ
- 遷移先:
  - ManageNamingStylesInfoDialog（シンボル仕様管理）
  - ManageNamingStylesInfoDialog（命名スタイル管理）

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | 命名規則の追加・編集・管理 |

## 画面種別

設定画面（オプションページコントロール）

## URL/ルーティング

該当なし（Visual Studioオプションダイアログ内）

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 説明 |
|--------|--------|---------|----------|------|------|
| コードスタイルアイテム | CodeStyleItems | ObservableCollection | 入力/出力 | - | 命名規則のリスト |
| シンボル仕様リスト | Specifications | List | 入力/出力 | - | 利用可能なシンボル仕様 |
| 命名スタイルリスト | NamingStyles | List | 入力/出力 | - | 利用可能な命名スタイル |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| 並び替えヘッダー | ReorderHeader | 列ヘッダー | 並び替えボタン列 |
| 仕様ヘッダー | SpecificationHeader | 列ヘッダー | "Specification" |
| 必須スタイルヘッダー | RequiredStyleHeader | 列ヘッダー | "Required Style" |
| 重大度ヘッダー | SeverityHeader | 列ヘッダー | "Severity" |
| 上移動ボタン | UpButton | ボタン | 選択行を上に移動 |
| 下移動ボタン | DownButton | ボタン | 選択行を下に移動 |
| シンボル仕様 | Specifications | コンボボックス | シンボル仕様の選択 |
| 命名スタイル | NamingStyles | コンボボックス | 命名スタイルの選択 |
| 重大度 | NotificationPreferences | コンボボックス | Silent/Suggestion/Warning/Error |
| 削除ボタン | RemoveButton | ボタン | 行の削除 |

## イベント仕様

### 1-AddButton_Click

「Add」ボタンがクリックされた際の処理。

処理フロー:
1. 新しいNamingRuleViewModelを作成
2. ViewModelのAddItemを呼び出しリストに追加

### 2-RemoveButton_Click

削除ボタンがクリックされた際の処理。

処理フロー:
1. ボタンのDataContextからNamingRuleViewModelを取得
2. ViewModelのRemoveItemを呼び出しリストから削除

### 3-MoveUp_Click / MoveDown_Click

上下矢印ボタンがクリックされた際の処理。

処理フロー:
1. 現在の選択インデックスを取得
2. ViewModelのMoveItemを呼び出し位置を変更
3. 選択インデックスを更新
4. SetFocusToSelectedRowでフォーカスを維持

### 4-ManageSpecificationsButton_Click

「Manage Specifications」ボタンがクリックされた際の処理。

処理フロー:
1. ManageSymbolSpecificationsDialogViewModelを作成
2. ManageNamingStylesInfoDialogを表示
3. ダイアログがOKで閉じられた場合、ViewModelのUpdateSpecificationListを呼び出し

### 5-ManageStylesButton_Click

「Manage Styles」ボタンがクリックされた際の処理。

処理フロー:
1. ManageNamingStylesDialogViewModelを作成
2. ManageNamingStylesInfoDialogを表示
3. ダイアログがOKで閉じられた場合、ViewModelのUpdateStyleListを呼び出し

## データベース更新仕様

該当なし（Visual Studio設定ストアへの保存）

### OnSaveメソッドの処理

処理フロー:
1. CodeStyleItemsをイテレート
2. 完全なルールのみNamingRuleに変換
3. SymbolSpecification、NamingStyle、NamingRuleをArrayBuilderに収集
4. NamingStylePreferencesを作成
5. OptionStore.SetOptionで保存

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | 常時 | ExplanatoryText（ルール優先順位の説明） |
| - | 情報 | EditorConfig優先通知 | CodeStyleNoticeTextBlockの内容 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 不完全なルール | OnSave時にスキップ、ContainsErrorsでチェック可能 |

## 備考

- AbstractOptionPageControlを継承
- Alt+↑/↓のキーボードショートカットで並び替え可能
- 通知レベル: Silent（アイコンなし）、Suggestion（情報）、Warning（警告）、Error（エラー）
- 各通知レベルにはKnownMonikersからアイコンが設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、命名規則のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NamingStyleOptionPageViewModel.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageViewModel.cs` | ViewModelの構造とNamingRuleViewModel |
| 1-2 | SymbolSpecification.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/SymbolSpecification.cs` | シンボル仕様の定義 |
| 1-3 | NamingStyle.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NamingStyle.cs` | 命名スタイルの定義 |

**読解のコツ**: NamingRuleViewModelは仕様、スタイル、重大度の組み合わせで一つのルールを表す。

#### Step 2: エントリーポイントを理解する

コントロールの初期化と基本動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NamingStyleOptionPageControl.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml.cs` | コンストラクタとイベントハンドラ |

**主要処理フロー**:
1. **行48-56**: コンストラクタで初期化とOnLoad呼び出し
2. **行68-69**: AddButton_Clickで新規ルール追加
3. **行91-110**: MoveUp_Click/MoveDown_Clickで並び替え
4. **行138-175**: OnSaveでNamingStylePreferencesを保存
5. **行177-189**: OnLoadでNamingStylePreferencesを読み込み

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NamingStyleOptionPageControl.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml` | DataGridの列定義とボタン配置 |

**主要処理フロー**:
- **行51**: ExplanatoryTextの表示
- **行52**: CodeStyleNoticeTextBlockの配置
- **行53-262**: DataGridの定義（5列: 並び替え、仕様、スタイル、重大度、削除）
- **行264-281**: 追加ボタンと管理ボタン群

### プログラム呼び出し階層図

```
Visual Studioオプションダイアログ
    │
    └─ NamingStyleOptionPageControl
           │
           ├─ OnLoad()
           │      └─ NamingStyleOptionPageViewModel作成
           │
           ├─ AddButton_Click()
           │      └─ ViewModel.AddItem()
           │
           ├─ RemoveButton_Click()
           │      └─ ViewModel.RemoveItem()
           │
           ├─ MoveUp_Click() / MoveDown_Click()
           │      └─ ViewModel.MoveItem()
           │
           ├─ ManageSpecificationsButton_Click()
           │      └─ ManageNamingStylesInfoDialog表示
           │
           ├─ ManageStylesButton_Click()
           │      └─ ManageNamingStylesInfoDialog表示
           │
           └─ OnSave()
                  └─ NamingStylePreferences保存
```

### データフロー図

```
[入力]                    [処理]                         [出力]

OptionStore ───────▶ NamingStyleOptionPageViewModel ───▶ CodeStyleItems
    │                        │                              │
    │                        ▼                              ▼
    │                 NamingStylePreferences            DataGrid表示
    │                        │
    │                        ▼
ユーザー操作 ──────▶ AddItem/RemoveItem/MoveItem ───▶ リスト更新
    │
    │
「保存」──────────▶ OnSave() ───▶ OptionStore
                         │
                         ▼
                 NamingStylePreferences作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NamingStyleOptionPageControl.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml` | XAML | UI定義 |
| NamingStyleOptionPageControl.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml.cs` | ソース | コードビハインド |
| NamingStyleOptionPageViewModel.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageViewModel.cs` | ソース | ViewModel |
| AbstractOptionPageControl.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPageControl.cs` | ソース | 基底クラス |
| ManageNamingStylesInfoDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml` | XAML | 管理ダイアログ |
| SymbolSpecificationDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml` | XAML | シンボル仕様編集ダイアログ |
| NamingStyleDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml` | XAML | 命名スタイル編集ダイアログ |
| NotificationOptionViewModel.cs | `src/VisualStudio/Core/Impl/Options/NotificationOptionViewModel.cs` | ソース | 通知オプションViewModel |
| CodeStyleNoticeTextBlock.xaml | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml` | XAML | EditorConfig通知 |
