# 画面設計書 31-命名スタイルダイアログ

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「命名スタイルダイアログ」の画面設計を記述する。命名規則のスタイル（プレフィックス、サフィックス、大文字化規則など）を定義・編集するためのモーダルダイアログである。

### 本画面の処理概要

本画面では、C#およびVisual Basicコードにおける識別子の命名スタイルを定義することができる。命名スタイルとは、変数名やメソッド名などの識別子がどのような形式で命名されるべきかを規定するルールである。

**業務上の目的・背景**：開発チーム内でコーディング規約を統一し、コードの可読性と保守性を向上させるために、識別子の命名規則を明確に定義する必要がある。本ダイアログは、EditorConfigファイルやVisual Studioのオプション設定と連携し、命名規則違反を検出するための基準となるスタイルを作成・編集する機能を提供する。これにより、チーム開発における命名の一貫性を確保し、コードレビュー時の指摘事項を削減できる。

**画面へのアクセス方法**：Visual Studioの「ツール」メニュー > 「オプション」 > 「テキストエディター」 > 「C#」または「Visual Basic」 > 「コードスタイル」 > 「命名」から「命名スタイルオプションページコントロール」を開き、「スタイルの管理」ボタンをクリックして表示される「命名スタイル情報管理ダイアログ」から、「追加」ボタンまたは既存スタイルの「編集」ボタンをクリックすることで本ダイアログが表示される。

**主要な操作・処理内容**：
1. スタイル名の入力 - 命名スタイルを識別するための名前を設定
2. 必須プレフィックスの設定 - 識別子の先頭に付ける必須文字列（例：`_`、`m_`）
3. 必須サフィックスの設定 - 識別子の末尾に付ける必須文字列（例：`Async`）
4. 単語区切り文字の設定 - 複合語の単語間に挿入する文字（例：`_`）
5. 大文字化規則の選択 - PascalCase、camelCase、ALL_UPPER等から選択
6. サンプル識別子のプレビュー - 設定に基づく命名例をリアルタイムで確認

**画面遷移**：命名スタイル情報管理ダイアログ（No.33）から本画面に遷移する。OKボタン押下で設定を確定して命名スタイル情報管理ダイアログに戻り、キャンセルボタン押下で変更を破棄して命名スタイル情報管理ダイアログに戻る。

**権限による表示制御**：特になし。Visual Studioのオプション設定画面にアクセスできるすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | 命名スタイル（プレフィックス・サフィックス・規則）の編集 |

## 画面種別

編集（モーダルダイアログ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。ダイアログはプログラムコードから `NamingStyleDialog` クラスをインスタンス化して表示する。

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力/出力 | 説明 |
|--------|--------|----------|------|-----------|------|
| スタイル名 | ItemName | string | ○ | 入力 | 命名スタイルの識別名（空白不可） |
| 必須プレフィックス | RequiredPrefix | string | - | 入力 | 識別子の先頭に付ける文字列 |
| 必須サフィックス | RequiredSuffix | string | - | 入力 | 識別子の末尾に付ける文字列 |
| 単語区切り文字 | WordSeparator | string | - | 入力 | 単語間の区切り文字 |
| 大文字化規則 | CapitalizationSchemeIndex | int | ○ | 入力 | 大文字化規則のインデックス（0-4） |
| サンプル識別子 | CurrentConfiguration | string | - | 出力 | 設定に基づく命名例（読み取り専用） |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ダイアログタイトル | ウィンドウタイトル | 「Naming Style」（ローカライズ対応） |
| スタイル名ラベル | Label | 「Naming Style Title:」 |
| 必須プレフィックスラベル | Label | 「Required Prefix:」 |
| 必須サフィックスラベル | Label | 「Required Suffix:」 |
| 単語区切り文字ラベル | Label | 「Word Separator:」 |
| 大文字化規則ラベル | Label | 「Capitalization:」 |
| サンプル識別子ラベル | Label | 「Sample Identifier:」 |

## イベント仕様

### 1-テキスト入力変更イベント

スタイル名、プレフィックス、サフィックス、単語区切り文字のテキストボックスで値が変更されると、`UpdateSourceTrigger=PropertyChanged` により即座にViewModelのプロパティが更新される。プロパティ変更時に `CurrentConfiguration`（サンプル識別子）が再計算され、プレビュー表示が更新される。

### 2-大文字化規則選択変更イベント

コンボボックスで大文字化規則が変更されると、`CapitalizationSchemeIndex` プロパティが更新され、`CurrentConfiguration` が再計算されてプレビュー表示が更新される。

### 3-OKボタン押下イベント

`OK_Click` イベントハンドラが呼び出され、以下の処理が実行される：
1. `_viewModel.TrySubmit()` メソッドを呼び出し、入力検証を実行
2. スタイル名が空白の場合、通知サービス経由でエラーメッセージを表示し、処理を中断
3. 検証成功時、`DialogResult = true` を設定してダイアログを閉じる
4. 呼び出し元で `GetNamingStyle()` メソッドにより編集結果を取得

### 4-キャンセルボタン押下イベント

`Cancel_Click` イベントハンドラが呼び出され、`DialogResult = false` を設定してダイアログを閉じる。編集内容は破棄される。

## データベース更新仕様

本ダイアログはデータベースを直接更新しない。編集結果は呼び出し元のダイアログ（命名スタイル情報管理ダイアログ）に返され、最終的にVisual Studioのオプション設定またはEditorConfigファイルに保存される。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OKボタン押下 | なし | - | メモリ上のViewModelに値を反映するのみ |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|---------------|
| MSG001 | エラー | スタイル名が空白 | 「Enter a title for this Naming Style」 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| スタイル名未入力 | 通知サービス（INotificationService）経由でエラーメッセージを表示し、ダイアログを閉じない |

## 備考

- ダイアログサイズ：幅500px、高さ280px（最小サイズも同値、リサイズ可能）
- 大文字化規則の選択肢：PascalCase、camelCase、First word upper、ALL_UPPER、all_lower
- サンプル識別子は「example」「identifier」の2語を使用して生成される
- Visual Studio のテーマに対応したスタイルを適用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

命名スタイルのデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NamingStyleViewModel.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleViewModel.cs` | ビューモデルの構造、バインディングプロパティ、大文字化規則の定義を理解する |
| 1-2 | MutableNamingStyle | Roslyn内部クラス | 命名スタイルの実体データ（Prefix、Suffix、WordSeparator、CapitalizationScheme）を理解する |

**読解のコツ**: WPFのMVVMパターンに従っており、`AbstractNotifyPropertyChanged` を継承してプロパティ変更通知を実装している。`SetProperty` メソッドでプロパティ変更を検知し、関連プロパティ（`CurrentConfiguration`）の変更も通知している点に注目。

#### Step 2: エントリーポイントを理解する

ダイアログの初期化とデータバインディングの設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NamingStyleDialog.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml.cs` | コンストラクタでのViewModel設定、イベントハンドラの実装を理解する |
| 2-2 | NamingStyleDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml` | XAMLでのUI構成、データバインディング設定を理解する |

**主要処理フロー**:
1. **30-36行目**: コンストラクタでViewModelを受け取り、`DataContext` に設定
2. **38-44行目**: OKボタン押下時の入力検証と結果設定
3. **46-47行目**: キャンセルボタン押下時のダイアログ終了

#### Step 3: UI構成を理解する

XAMLファイルでのUI要素の配置とバインディングを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NamingStyleDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml` | Grid構成、TextBox/ComboBoxのバインディング、DialogButtonの配置 |

**主要処理フロー**:
- **49-55行目**: スタイル名テキストボックス（`ItemName` にバインド）
- **57-65行目**: 必須プレフィックステキストボックス（`RequiredPrefix` にバインド）
- **67-75行目**: 必須サフィックステキストボックス（`RequiredSuffix` にバインド）
- **77-85行目**: 単語区切り文字テキストボックス（`WordSeparator` にバインド）
- **87-98行目**: 大文字化規則コンボボックス（`CapitalizationSchemes` と `CapitalizationSchemeIndex` にバインド）
- **100-109行目**: サンプル識別子テキストボックス（読み取り専用、`CurrentConfiguration` にバインド）

### プログラム呼び出し階層図

```
ManageNamingStylesInfoDialog
    │
    ├─ AddButton_Click / EditButton_Click
    │      │
    │      └─ NamingStyleDialog (new)
    │             │
    │             ├─ NamingStyleViewModel
    │             │      ├─ ItemName
    │             │      ├─ RequiredPrefix
    │             │      ├─ RequiredSuffix
    │             │      ├─ WordSeparator
    │             │      ├─ CapitalizationSchemeIndex
    │             │      └─ CurrentConfiguration (計算プロパティ)
    │             │
    │             ├─ OK_Click
    │             │      └─ TrySubmit() → GetNamingStyle()
    │             │
    │             └─ Cancel_Click
    │                    └─ DialogResult = false
    │
    └─ 編集結果の取得 (GetNamingStyle)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

TextBox入力                NamingStyleViewModel              サンプル識別子
  │                              │                              │
  ├─ ItemName ─────────────────▶ 検証 ──────────────────────▶ 表示更新
  ├─ RequiredPrefix ───────────▶ _style.Prefix更新           │
  ├─ RequiredSuffix ───────────▶ _style.Suffix更新 ─────────▶ CurrentConfiguration
  ├─ WordSeparator ────────────▶ _style.WordSeparator更新    │  (CreateName)
  └─ CapitalizationScheme ─────▶ _style.CapitalizationScheme │
                                        │                      │
                                        └──────────────────────┘
                                                 │
OKボタン押下 ──────────────────▶ TrySubmit() ──▶ MutableNamingStyle
                                    │
                                    └─ 空白チェック → エラー通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NamingStyleDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml` | XAML | ダイアログのUI定義 |
| NamingStyleDialog.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml.cs` | ソース | ダイアログのコードビハインド |
| NamingStyleViewModel.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleViewModel.cs` | ソース | ビューモデル（データバインディング用） |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
| MutableNamingStyle.cs | Roslyn内部 | ソース | 命名スタイルのデータモデル |
