# 画面設計書 32-シンボル仕様ダイアログ

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「シンボル仕様ダイアログ」の画面設計を記述する。命名規則の適用対象となるシンボルの種類、アクセス修飾子、修飾子を定義するためのモーダルダイアログである。

### 本画面の処理概要

本画面では、命名規則を適用するシンボルの条件（シンボル仕様）を定義する。シンボル仕様とは、どの種類のシンボル（クラス、メソッド、プロパティ等）に対して、どのようなアクセス修飾子（public、private等）と修飾子（static、readonly等）の組み合わせで命名規則を適用するかを規定するルールである。

**業務上の目的・背景**：プロジェクト内で異なる種類のシンボルに対して異なる命名規則を適用したい場合がある。例えば、privateフィールドには `_` プレフィックス、publicメソッドにはPascalCaseといった使い分けが必要になる。本ダイアログは、そのような細かな条件設定を可能にし、チーム開発における命名規約の柔軟な運用を支援する。

**画面へのアクセス方法**：Visual Studioの「ツール」メニュー > 「オプション」 > 「テキストエディター」 > 「C#」または「Visual Basic」 > 「コードスタイル」 > 「命名」から「命名スタイルオプションページコントロール」を開き、「仕様の管理」ボタンをクリックして表示される管理ダイアログから、「追加」ボタンまたは既存仕様の「編集」ボタンをクリックすることで本ダイアログが表示される。

**主要な操作・処理内容**：
1. 仕様名の入力 - シンボル仕様を識別するための名前を設定
2. シンボル種類の選択 - 対象とするシンボルの種類を複数選択（Class、Method、Property等）
3. アクセス修飾子の選択 - 対象とするアクセス修飾子を複数選択（public、private等）
4. 修飾子の選択 - 必須となる修飾子を複数選択（static、readonly、async等）
5. 全選択/全解除ボタンによる一括操作

**画面遷移**：命名スタイル情報管理ダイアログ（No.33）から本画面に遷移する。OKボタン押下で設定を確定して管理ダイアログに戻り、キャンセルボタン押下で変更を破棄して管理ダイアログに戻る。

**権限による表示制御**：特になし。Visual Studioのオプション設定画面にアクセスできるすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | シンボル種類・アクセス修飾子・修飾子の仕様編集 |

## 画面種別

編集（モーダルダイアログ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。ダイアログはプログラムコードから `SymbolSpecificationDialog` クラスをインスタンス化して表示する。

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力/出力 | 説明 |
|--------|--------|----------|------|-----------|------|
| 仕様名 | ItemName | string | ○ | 入力 | シンボル仕様の識別名 |
| シンボル種類リスト | SymbolKindList | List<SymbolKindViewModel> | - | 入力 | 対象シンボル種類のチェック状態 |
| アクセス修飾子リスト | AccessibilityList | List<AccessibilityViewModel> | - | 入力 | 対象アクセス修飾子のチェック状態 |
| 修飾子リスト | ModifierList | List<ModifierViewModel> | - | 入力 | 必須修飾子のチェック状態 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ダイアログタイトル | ウィンドウタイトル | 「Symbol Specification」（ローカライズ対応） |
| 仕様名ラベル | Label | 「Symbol Specification Title:」 |
| シンボル種類ラベル | Label | 「Symbol Kinds (can match any):」 |
| アクセス修飾子ラベル | Label | 「Accessibilities (can match any):」 |
| 修飾子ラベル | Label | 「Modifiers (must match all):」 |
| 全選択ボタン | DialogButton | 各セクションの全選択ボタン |
| 全解除ボタン | DialogButton | 各セクションの全解除ボタン |

## イベント仕様

### 1-シンボル種類全選択ボタン押下イベント

`SelectAllSymbolKinds` イベントハンドラが呼び出され、`symbolKindsListView` 内の全ての `SymbolKindViewModel` の `IsChecked` プロパティを `true` に設定する。

### 2-シンボル種類全解除ボタン押下イベント

`DeselectAllSymbolKinds` イベントハンドラが呼び出され、`symbolKindsListView` 内の全ての `SymbolKindViewModel` の `IsChecked` プロパティを `false` に設定する。

### 3-アクセス修飾子全選択/全解除ボタン押下イベント

`SelectAllAccessibilities` / `DeselectAllAccessibilities` イベントハンドラで同様の処理を実行。

### 4-修飾子全選択/全解除ボタン押下イベント

`SelectAllModifiers` / `DeselectAllModifiers` イベントハンドラで同様の処理を実行。

### 5-Spaceキー押下によるチェック状態切り替え

リストビュー内で選択されたアイテムに対してSpaceキーを押下すると、選択されている全アイテムのチェック状態が一括でトグルされる。全てがチェック済みの場合は全解除、それ以外の場合は全選択となる。

### 6-OKボタン押下イベント

`OK_Click` イベントハンドラが呼び出され、`_viewModel.TrySubmit()` で入力検証を実行後、`DialogResult = true` を設定してダイアログを閉じる。

### 7-キャンセルボタン押下イベント

`Cancel_Click` イベントハンドラが呼び出され、`DialogResult = false` を設定してダイアログを閉じる。

## データベース更新仕様

本ダイアログはデータベースを直接更新しない。編集結果は呼び出し元に返され、最終的にVisual Studioのオプション設定またはEditorConfigファイルに保存される。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OKボタン押下 | なし | - | メモリ上のViewModelに値を反映するのみ |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|---------------|
| （なし） | - | - | TrySubmitでの検証エラー時は通知サービス経由 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 仕様名未入力 | 通知サービス経由でエラーメッセージを表示し、ダイアログを閉じない |

## 備考

- ダイアログサイズ：幅700px、高さ450px（最小サイズ：600x400、リサイズ可能）
- シンボル種類はチェックボックスリストで複数選択可能（いずれかにマッチ）
- アクセス修飾子はチェックボックスリストで複数選択可能（いずれかにマッチ）
- 修飾子はチェックボックスリストで複数選択可能（すべてにマッチ）
- AutomationDelegatingListViewをコードビハインドで生成（XAML定義不可のため）
- 複数選択状態でSpaceキーを押すと選択項目を一括トグル

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シンボル仕様のデータモデルとビューモデルの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SymbolSpecificationViewModel.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationViewModel.cs` | SymbolKindViewModel、AccessibilityViewModel、ModifierViewModelの構造を理解する |

**読解のコツ**: 3つのビューモデル（SymbolKind、Accessibility、Modifier）はすべて `ISymbolSpecificationViewModelPart` インターフェースを実装しており、共通の `IsChecked` プロパティを持つ。

#### Step 2: エントリーポイントを理解する

ダイアログの初期化とリストビューの動的生成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SymbolSpecificationDialog.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml.cs` | コンストラクタでのAutomationDelegatingListView生成、イベントハンドラ登録を理解する |
| 2-2 | SymbolSpecificationDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml` | ContentControlへのリストビュー挿入ポイントを理解する |

**主要処理フロー**:
1. **37-64行目**: コンストラクタでViewModelを設定し、3つのAutomationDelegatingListViewを動的生成
2. **66-73行目**: CreateAutomationDelegatingListViewメソッドでリストビューを生成しバインディング設定
3. **75-96行目**: Spaceキーハンドラで選択アイテムの一括トグル処理

#### Step 3: UI構成を理解する

XAMLファイルでのレイアウト構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SymbolSpecificationDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml` | 2カラムレイアウト、ContentControl配置、listViewDataTemplateの定義 |

**主要処理フロー**:
- **30-38行目**: listViewDataTemplate定義（CheckBoxとNameバインディング）
- **68-73行目**: symbolKindsContentControl（左カラム）
- **85-95行目**: accessibilitiesContentControl、modifiersContentControl（右カラム）

### プログラム呼び出し階層図

```
ManageNamingStylesInfoDialog
    │
    └─ SymbolSpecificationDialog (new)
           │
           ├─ SymbolSpecificationViewModel
           │      ├─ SymbolKindList
           │      ├─ AccessibilityList
           │      └─ ModifierList
           │
           ├─ CreateAutomationDelegatingListView (x3)
           │      └─ AutomationDelegatingListView
           │             └─ ItemsSource binding
           │
           ├─ PreviewKeyDown handlers
           │      └─ HandlePreviewKeyDown<T>
           │             └─ Spaceキーでトグル
           │
           ├─ SelectAll/DeselectAll handlers
           │
           └─ OK_Click / Cancel_Click
```

### データフロー図

```
[入力]                      [処理]                           [出力]

仕様名入力 ────────────────▶ ItemNameプロパティ
                                   │
シンボル種類チェック ─────────▶ SymbolKindList
                                   │
アクセス修飾子チェック ───────▶ AccessibilityList  ─────────▶ SymbolSpecification
                                   │
修飾子チェック ───────────────▶ ModifierList
                                   │
全選択/全解除ボタン ──────────▶ IsChecked一括更新
                                   │
OKボタン押下 ─────────────────▶ TrySubmit() ──────────────▶ 結果返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SymbolSpecificationDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml` | XAML | ダイアログのUI定義 |
| SymbolSpecificationDialog.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml.cs` | ソース | ダイアログのコードビハインド |
| SymbolSpecificationViewModel.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationViewModel.cs` | ソース | ビューモデル |
| AutomationDelegatingListView.cs | ServicesVisualStudio | ソース | カスタムリストビューコントロール |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
