# 画面設計書 33-命名スタイル情報管理ダイアログ

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「命名スタイル情報管理ダイアログ」の画面設計を記述する。命名スタイルまたはシンボル仕様の一覧を表示し、追加・編集・削除操作を行うためのモーダルダイアログである。

### 本画面の処理概要

本画面では、命名規則で使用するスタイル定義またはシンボル仕様の一覧を管理する。DataGridで既存の定義一覧を表示し、各行に対して編集・削除操作、および新規追加操作が可能である。

**業務上の目的・背景**：プロジェクトで使用する命名スタイルやシンボル仕様を一元管理するための画面である。複数の命名スタイル（PascalCaseスタイル、camelCaseスタイル、_プレフィックス付きスタイル等）を定義し、命名規則と組み合わせて利用する。本画面により、開発チームは命名規約の管理を効率的に行える。

**画面へのアクセス方法**：Visual Studioの「ツール」メニュー > 「オプション」 > 「テキストエディター」 > 「C#」または「Visual Basic」 > 「コードスタイル」 > 「命名」にある「命名スタイルオプションページコントロール」から、「スタイルの管理」または「仕様の管理」ボタンをクリックすることで本ダイアログが表示される。

**主要な操作・処理内容**：
1. 一覧表示 - 既存の命名スタイルまたはシンボル仕様をDataGridで表示
2. 追加操作 - 「+」ボタンで新規アイテムを追加（詳細編集ダイアログを表示）
3. 編集操作 - 各行の編集ボタンで既存アイテムを編集（詳細編集ダイアログを表示）
4. 削除操作 - 各行の削除ボタンでアイテムを削除（使用中のアイテムは削除不可）
5. OK/キャンセル - 変更の確定または破棄

**画面遷移**：命名スタイルオプションページコントロール（No.30）から本画面に遷移する。追加または編集ボタン押下時は、命名スタイルダイアログ（No.31）またはシンボル仕様ダイアログ（No.32）に遷移する。

**権限による表示制御**：特になし。削除ボタンは「CanBeDeleted」プロパティに基づき、使用中のアイテムは削除不可（グレーアウト表示）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | 命名スタイル一覧の管理操作 |

## 画面種別

一覧/管理（モーダルダイアログ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。ダイアログはプログラムコードから `ManageNamingStylesInfoDialog` クラスをインスタンス化して表示する。

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力/出力 | 説明 |
|--------|--------|----------|------|-----------|------|
| アイテム一覧 | Items | IEnumerable<INamingStylesInfoDialogViewModel> | - | 入出力 | 管理対象のアイテム一覧 |
| ダイアログタイトル | DialogTitle | string | - | 入力 | 管理対象に応じたタイトル |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ダイアログタイトル | ウィンドウタイトル | ViewModel経由で設定（スタイル管理/仕様管理） |
| アイテム名 | DataGridColumn | 各アイテムの名前（ItemName） |
| 編集ボタン | DataGridColumn | 編集アイコンボタン |
| 削除ボタン | DataGridColumn | 削除アイコンボタン（条件付き無効化） |
| 追加ボタン | Button | 「+」アイコンボタン |
| OKボタン | DialogButton | 確定ボタン |
| キャンセルボタン | DialogButton | 取消ボタン |

## イベント仕様

### 1-追加ボタン押下イベント

`AddButton_Click` イベントハンドラが呼び出され、`_viewModel.AddItem()` メソッドを実行する。ViewModelの実装に応じて、命名スタイルダイアログまたはシンボル仕様ダイアログが表示される。

### 2-編集ボタン押下イベント

`EditButton_Click` イベントハンドラが呼び出され、クリックされたボタンのDataContextからアイテムを取得し、`_viewModel.EditItem(item)` メソッドを実行する。対応する詳細編集ダイアログが表示される。

### 3-削除ボタン押下イベント

`RemoveButton_Click` イベントハンドラが呼び出され、クリックされたボタンのDataContextからアイテムを取得し、`_viewModel.RemoveItem(item)` メソッドを実行する。アイテムが使用中の場合はボタンが無効化されており、この処理は実行されない。

### 4-OKボタン押下イベント

`OK_Click` イベントハンドラが呼び出され、`DialogResult = true` を設定してダイアログを閉じる。

### 5-キャンセルボタン押下イベント

`Cancel_Click` イベントハンドラが呼び出され、`DialogResult = false` を設定してダイアログを閉じる。

## データベース更新仕様

本ダイアログはデータベースを直接更新しない。ViewModelを通じてメモリ上のデータを操作し、呼び出し元に変更結果を返す。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 追加/編集/削除操作 | なし | - | メモリ上のViewModelを操作 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|---------------|
| MSG001 | ツールチップ | 削除不可アイテムにマウスオーバー | 「This item cannot be deleted because it is used by an existing Naming Rule」 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 使用中アイテムの削除試行 | 削除ボタンが無効化されているため発生しない |

## 備考

- ダイアログサイズ：幅300px、高さ400px（最小サイズも同値、リサイズ可能）
- DataGridは読み取り専用（IsReadOnly="True"）、ヘッダー非表示
- 削除ボタンは使用中アイテムでグレースケール表示
- アイコンはMicrosoft.VisualStudio.Imagingのモニカーを使用（KnownMonikers.Add、KnownMonikers.Edit、KnownMonikers.DeleteListItem）
- IManageNamingStylesInfoDialogViewModelインターフェースで操作を抽象化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビューモデルのインターフェース構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IManageNamingStylesInfoDialogViewModel | インターフェース定義 | AddItem、EditItem、RemoveItemメソッドの定義を理解する |
| 1-2 | INamingStylesInfoDialogViewModel | インターフェース定義 | ItemName、CanBeDeletedプロパティの定義を理解する |

**読解のコツ**: このダイアログは汎用的な管理UIであり、命名スタイルとシンボル仕様の両方で再利用される。具体的なアイテム追加・編集処理はViewModelの実装クラスに委譲されている。

#### Step 2: エントリーポイントを理解する

ダイアログの初期化とイベントハンドラを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ManageNamingStylesInfoDialog.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml.cs` | コンストラクタでのViewModel設定、各イベントハンドラの実装を理解する |
| 2-2 | ManageNamingStylesInfoDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml` | DataGridの構成、ボタン配置、NegateBooleanConverterの使用を理解する |

**主要処理フロー**:
1. **28-34行目**: コンストラクタでViewModelを設定
2. **36-37行目**: AddButton_ClickでAddItem呼び出し
3. **39-44行目**: RemoveButton_ClickでRemoveItem呼び出し
4. **46-51行目**: EditButton_ClickでEditItem呼び出し
5. **53-57行目**: OK/Cancel_Clickでダイアログ終了

#### Step 3: UI構成を理解する

XAMLファイルでのDataGrid構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ManageNamingStylesInfoDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml` | DataGridTemplateColumn構成、ボタンテンプレート、CrispImageの使用 |

**主要処理フロー**:
- **56-173行目**: DataGrid定義（3列：ItemName、Edit、Delete）
- **119-147行目**: 編集ボタン列テンプレート（KnownMonikers.Edit）
- **148-171行目**: 削除ボタン列テンプレート（CanBeDeletedでグレースケール制御）
- **175-187行目**: 追加ボタン（KnownMonikers.Add）

### プログラム呼び出し階層図

```
NamingStyleOptionPageControl
    │
    └─ ManageNamingStylesInfoDialog (new)
           │
           ├─ IManageNamingStylesInfoDialogViewModel
           │      ├─ Items (データソース)
           │      ├─ AddItem() → NamingStyleDialog / SymbolSpecificationDialog
           │      ├─ EditItem(item) → NamingStyleDialog / SymbolSpecificationDialog
           │      └─ RemoveItem(item)
           │
           ├─ AddButton_Click
           │      └─ _viewModel.AddItem()
           │
           ├─ EditButton_Click
           │      └─ _viewModel.EditItem(item)
           │
           ├─ RemoveButton_Click
           │      └─ _viewModel.RemoveItem(item)
           │
           └─ OK_Click / Cancel_Click
```

### データフロー図

```
[入力]                      [処理]                           [出力]

IManageNamingStylesInfo
DialogViewModel ──────────▶ DataGrid.ItemsSource
    │                              │
    │                              ├─ ItemName表示
    │                              ├─ 編集ボタン
    │                              └─ 削除ボタン（CanBeDeleted制御）
    │
追加ボタン押下 ────────────▶ AddItem() ──────────────────▶ 詳細ダイアログ表示
                                   │
編集ボタン押下 ────────────▶ EditItem(item) ────────────▶ 詳細ダイアログ表示
                                   │
削除ボタン押下 ────────────▶ RemoveItem(item) ──────────▶ 一覧から削除
                                   │
OKボタン押下 ──────────────▶ DialogResult = true ────────▶ 変更確定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ManageNamingStylesInfoDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml` | XAML | ダイアログのUI定義 |
| ManageNamingStylesInfoDialog.xaml.cs | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml.cs` | ソース | ダイアログのコードビハインド |
| NamingStyleDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml` | XAML | 命名スタイル詳細編集ダイアログ |
| SymbolSpecificationDialog.xaml | `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml` | XAML | シンボル仕様詳細編集ダイアログ |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
