# 画面設計書 34-C#詳細オプションページコントロール

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「C#詳細オプションページコントロール」の画面設計を記述する。Visual Studioのオプション画面でC#言語の詳細設定を行うためのコントロールである。

### 本画面の処理概要

本画面では、C#言語に関する詳細な設定を行う。コード分析、ソースジェネレーター、Go To Definition、using ディレクティブ、ハイライト、アウトライン、フェーディング、ブロック構造ガイド、コメント、エディタヘルプ、正規表現、JSON、インターフェース実装、インラインヒント、継承マージン、スタックトレースエクスプローラーなど、多岐にわたる設定項目をグループボックスで分類して提供する。

**業務上の目的・背景**：開発者がVisual Studioでのコーディング体験をカスタマイズするための設定画面である。バックグラウンド分析のスコープ、コードナビゲーション機能、エディタの視覚的フィードバック（インラインヒント、継承マージン等）などを開発者の好みやプロジェクト要件に合わせて調整できる。これにより、パフォーマンスと機能性のバランスを最適化できる。

**画面へのアクセス方法**：Visual Studioの「ツール」メニュー > 「オプション」 > 「テキストエディター」 > 「C#」 > 「詳細」を選択することで本画面が表示される。

**主要な操作・処理内容**：
1. 分析設定 - バックグラウンドコード分析のスコープ、コンパイラ診断のスコープ、インライン診断表示
2. ソースジェネレーター設定 - 実行タイミング（自動/バランス）
3. Go To Definition設定 - SourceLink/埋め込みソース/逆コンパイルへのナビゲーション
4. usingディレクティブ設定 - System名前空間の優先、参照アセンブリ/NuGetパッケージからの提案
5. ハイライト設定 - 参照ハイライト、キーワードハイライト
6. アウトライン設定 - 折りたたみ動作、ラインセパレーター
7. フェーディング設定 - 未使用using/メンバー/到達不能コードのフェードアウト
8. インラインヒント設定 - パラメータ名ヒント、型ヒントの詳細設定
9. 継承マージン設定 - 継承マージンの表示設定

**画面遷移**：Visual Studioオプションダイアログ内のページとして表示される。他のオプションページへの遷移はサイドメニューから行う。

**権限による表示制御**：特になし。Visual Studioのオプション設定画面にアクセスできるすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 101 | VS C#拡張 | 主機能 | C#の分析・アウトライン・インラインヒント等の詳細設定 |

## 画面種別

設定（オプションページ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。Visual Studioのオプションダイアログ内の登録されたページとして表示される。

## 入出力項目

主要な設定項目（チェックボックス、コンボボックス、ラジオボタン）：

### 分析グループ

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| バックグラウンドコード分析スコープ | Run_background_code_analysis_for | enum | None/Active File/Open Files/Full Solution |
| コンパイラ診断スコープ | Show_compiler_errors_and_warnings_for | enum | None/Visible Files/Open Files/Full Solution |
| インライン診断表示 | DisplayDiagnosticsInline | bool | 診断をインライン表示するか |
| インライン診断位置 | at_the_end_of_the_line_of_code / on_the_right_edge_of_the_editor_window | radio | 行末/エディタ右端 |
| 未使用参照削除コマンド表示 | Show_Remove_Unused_References_command_in_Solution_Explorer | bool | ソリューションエクスプローラーにコマンド表示 |
| 診断ファイルログ有効化 | Enable_file_logging_for_diagnostics | bool | 診断のファイルログ記録 |
| 暗黙的ビルドでアナライザーをスキップ | Skip_analyzers_for_implicitly_triggered_builds | bool | 暗黙的トリガービルドでスキップ |

### ソースジェネレーターグループ

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 自動実行 | Automatic_Run_generators_after_any_change | radio | 任意の変更後にジェネレーター実行 |
| バランス実行 | Balanced_Run_generators_after_saving_or_building | radio | 保存/ビルド後に実行 |

### インラインヒントグループ

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| Alt+F1でヒント表示 | DisplayAllHintsWhilePressingAltF1 | bool | Alt+F1押下中に全ヒント表示 |
| ヒントに色付け | ColorHints | bool | ヒントをカラー表示 |
| パラメータ名ヒント | DisplayInlineParameterNameHints | bool | パラメータ名のインラインヒント表示 |
| 型ヒント | DisplayInlineTypeHints | bool | 型のインラインヒント表示 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Analysisグループボックス | GroupBox | 分析設定の区画 |
| Source Generatorsグループボックス | GroupBox | ソースジェネレーター設定の区画 |
| Go To Definitionグループボックス | GroupBox | 定義へ移動設定の区画 |
| Using Directivesグループボックス | GroupBox | usingディレクティブ設定の区画 |
| Highlightingグループボックス | GroupBox | ハイライト設定の区画 |
| Outliningグループボックス | GroupBox | アウトライン設定の区画 |
| Fadingグループボックス | GroupBox | フェーディング設定の区画 |
| Block Structure Guidesグループボックス | GroupBox | ブロック構造ガイド設定の区画 |
| Commentsグループボックス | GroupBox | コメント設定の区画 |
| Editor Helpグループボックス | GroupBox | エディタヘルプ設定の区画 |
| Regular Expressionsグループボックス | GroupBox | 正規表現設定の区画 |
| JSON stringsグループボックス | GroupBox | JSON文字列設定の区画 |
| Implement Interface or Abstract Classグループボックス | GroupBox | インターフェース実装設定の区画 |
| Inline Hintsグループボックス | GroupBox | インラインヒント設定の区画 |
| Inheritance Marginグループボックス | GroupBox | 継承マージン設定の区画 |
| Stack Trace Explorerグループボックス | GroupBox | スタックトレースエクスプローラー設定の区画 |

## イベント仕様

### 1-コンボボックス選択変更イベント

バックグラウンド分析スコープ、コンパイラ診断スコープのコンボボックスで値が変更されると、対応するオプションストレージに値が保存される。

### 2-チェックボックス変更イベント

各チェックボックスの変更時、`BindToOption` で関連付けられたオプションストレージに値が保存される。

### 3-ラジオボタン変更イベント

インライン診断位置、ソースジェネレーター実行タイミング、インターフェース実装位置などのラジオボタン変更時、対応するオプション値が更新される。

### 4-アウトラインモード有効/無効イベント

`EnterOutliningMode_Checked` / `EnterOutliningMode_Unchecked` イベントで、アウトライン関連のサブオプション（折りたたみ設定）の有効/無効状態を切り替える。

### 5-インラインパラメータ名ヒント有効/無効イベント

`DisplayInlineParameterNameHints_Checked` / `DisplayInlineParameterNameHints_Unchecked` イベントで、パラメータ名ヒント関連のサブオプションの有効/無効状態を切り替える。

### 6-インライン型ヒント有効/無効イベント

`DisplayInlineTypeHints_Checked` / `DisplayInlineTypeHints_Unchecked` イベントで、型ヒント関連のサブオプションの有効/無効状態を切り替える。

## データベース更新仕様

本画面はデータベースを直接更新しない。設定値はVisual Studioのオプションストレージ（レジストリまたはsettings.json）に保存される。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | なし | - | Visual Studioオプションストレージに保存 |

## メッセージ仕様

特になし。設定変更は即時反映される。

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| オプションストレージ書き込みエラー | Visual Studioの標準エラーハンドリング |

## 備考

- ScrollViewerで縦スクロール可能（設定項目が多いため）
- 設定項目はローカライズ対応（AdvancedOptionPageStringsリソースを参照）
- AbstractOptionPageControlを継承し、BindToOptionメソッドでオプションバインディングを実現
- 一部の設定は再起動が必要（ソースジェネレーター実行タイミング等）
- 依存関係のある設定は親項目の状態に応じて子項目を有効/無効化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

オプション定義とストレージの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractOptionPageControl | 基底クラス | BindToOptionメソッドのオプションバインディング仕組みを理解する |
| 1-2 | OptionStore | オプション管理 | GetOption/SetOptionによる値の読み書きを理解する |
| 1-3 | 各種OptionsStorage | オプション定義 | SolutionCrawlerOptionsStorage、InlineHintsOptionsStorage等の定義を理解する |

**読解のコツ**: 多くのオプションはLanguageNames.CSharpを指定して言語固有の設定として保存される。一部のオプション（DisplayAllHintsWhilePressingAltF1等）は言語共通の設定である。

#### Step 2: エントリーポイントを理解する

コンストラクタでのオプションバインディング設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AdvancedOptionPageControl.xaml.cs | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml.cs` | コンストラクタでの大量のBindToOption呼び出しを理解する |
| 2-2 | AdvancedOptionPageControl.xaml | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml` | GroupBox構成とコントロール配置を理解する |

**主要処理フロー**:
1. **47-165行目**: コンストラクタで各オプションをUIコントロールにバインド
2. **169-174行目**: OnLoadでインラインヒントオプションの状態更新
3. **176-232行目**: 依存オプションの有効/無効状態制御

#### Step 3: UI構成を理解する

XAMLファイルでのグループボックス構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AdvancedOptionPageControl.xaml | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml` | ScrollViewer、StackPanel、GroupBox、チェックボックス/コンボボックス/ラジオボタンの配置 |

**主要処理フロー**:
- **21-64行目**: Analysisグループ（分析設定）
- **66-84行目**: Source Generatorsグループ
- **86-96行目**: Go To Definitionグループ
- **274-337行目**: Inline Hintsグループ（複雑な階層構造）
- **339-351行目**: Inheritance Marginグループ

### プログラム呼び出し階層図

```
Visual Studio Options Dialog
    │
    └─ AdvancedOptionPageControl
           │
           ├─ AbstractOptionPageControl (継承)
           │      └─ BindToOption<T>(control, option, language)
           │             └─ OptionStore.GetOption / SetOption
           │
           ├─ InitializeComponent()
           │      └─ XAML UIツリー構築
           │
           ├─ BindToOption呼び出し (多数)
           │      ├─ SolutionCrawlerOptionsStorage
           │      ├─ InlineDiagnosticsOptionsStorage
           │      ├─ MetadataAsSourceOptionsStorage
           │      ├─ InlineHintsOptionsStorage
           │      ├─ InheritanceMarginOptionsStorage
           │      └─ その他多数のオプション
           │
           └─ イベントハンドラ
                  ├─ EnterOutliningMode_Checked/Unchecked
                  ├─ DisplayInlineParameterNameHints_Checked/Unchecked
                  └─ DisplayInlineTypeHints_Checked/Unchecked
```

### データフロー図

```
[入力]                      [処理]                           [出力]

XAML UIコントロール ───────▶ BindToOption ─────────────────▶ OptionStore
    │                              │
    ├─ CheckBox.IsChecked          ├─ bool値変換
    ├─ ComboBox.SelectedIndex      ├─ enum値変換
    └─ RadioButton.IsChecked       └─ オプション値設定
                                         │
                                         ▼
                              Visual Studio Settings
                                   (Registry / JSON)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AdvancedOptionPageControl.xaml | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml` | XAML | 詳細オプションページのUI定義 |
| AdvancedOptionPageControl.xaml.cs | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml.cs` | ソース | 詳細オプションページのコードビハインド |
| AdvancedOptionPageStrings.cs | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageStrings.cs` | ソース | ローカライズ文字列定義 |
| AbstractOptionPageControl.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPageControl.cs` | ソース | オプションページの基底クラス |
| OptionStore.cs | `src/VisualStudio/Core/Impl/Options/OptionStore.cs` | ソース | オプション値の保存・取得 |
