# 画面設計書 35-C#書式設定オプションページコントロール

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「C#書式設定オプションページコントロール」の画面設計を記述する。Visual Studioのオプション画面でC#コードの自動書式設定に関する設定を行うためのコントロールである。

### 本画面の処理概要

本画面では、C#コードの自動書式設定に関する設定を行う。入力時、セミコロン入力時、閉じ括弧入力時、リターン入力時、ペースト時の自動書式設定の有効/無効を設定できる。

**業務上の目的・背景**：開発者がコーディング中にコードを自動的に整形するタイミングを制御するための設定画面である。チームのコーディング規約に沿ったコードフォーマットを自動適用することで、コードの一貫性を保ち、手動での整形作業を削減できる。EditorConfigと連携することで、プロジェクト固有の書式設定も反映される。

**画面へのアクセス方法**：Visual Studioの「ツール」メニュー > 「オプション」 > 「テキストエディター」 > 「C#」 > 「コード スタイル」 > 「書式設定」 > 「全般」を選択することで本画面が表示される。

**主要な操作・処理内容**：
1. 入力時の自動書式設定 - 入力中に自動でコードを整形するかどうかを設定
2. セミコロン入力時の書式設定 - ステートメント終了時に自動整形するかどうかを設定
3. 閉じ括弧入力時の書式設定 - ブロック終了時に自動整形するかどうかを設定
4. リターン入力時の書式設定 - 改行時に自動整形するかどうかを設定
5. ペースト時の書式設定 - コードペースト時に自動整形するかどうかを設定

**画面遷移**：Visual Studioオプションダイアログ内のページとして表示される。他のオプションページへの遷移はサイドメニューから行う。

**権限による表示制御**：特になし。Visual Studioのオプション設定画面にアクセスできるすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 76 | フォーマット | 主機能 | C#コードのインデント・改行・スペース設定 |

## 画面種別

設定（オプションページ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。Visual Studioのオプションダイアログ内の登録されたページとして表示される。

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力/出力 | 説明 |
|--------|--------|----------|------|-----------|------|
| 入力時に自動書式設定 | FormatWhenTypingCheckBox | bool | - | 入力 | 入力中の自動書式設定 |
| セミコロン入力時に自動書式設定 | FormatOnSemicolonCheckBox | bool | - | 入力 | セミコロン入力時の書式設定 |
| 閉じ括弧入力時に自動書式設定 | FormatOnCloseBraceCheckBox | bool | - | 入力 | 閉じ括弧入力時の書式設定 |
| リターン入力時に自動書式設定 | FormatOnReturnCheckBox | bool | - | 入力 | リターン入力時の書式設定 |
| ペースト時に自動書式設定 | FormatOnPasteCheckBox | bool | - | 入力 | ペースト時の書式設定 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 全般グループボックス | GroupBox | 「General」書式設定の区画 |
| コードスタイル通知テキストブロック | CodeStyleNoticeTextBlock | EditorConfig優先警告の表示 |
| 入力時書式設定チェックボックス | CheckBox | 「Automatically format when typing」 |
| セミコロン時書式設定チェックボックス | CheckBox | 「Automatically format statement on ;」（インデント表示） |
| 閉じ括弧時書式設定チェックボックス | CheckBox | 「Automatically format block on }」（インデント表示） |
| リターン時書式設定チェックボックス | CheckBox | 「Automatically format on return」 |
| ペースト時書式設定チェックボックス | CheckBox | 「Automatically format on paste」 |

## イベント仕様

### 1-入力時書式設定チェックボックス変更イベント

`FormatWhenTypingCheckBox` の変更時、子チェックボックス（セミコロン時、閉じ括弧時）の有効/無効状態を切り替える。親チェックがオフの場合、子チェックボックスはグレーアウトされる。

### 2-各チェックボックス変更イベント

チェックボックスの変更時、`BindToOption` で関連付けられたオプションストレージに値が保存される。

## データベース更新仕様

本画面はデータベースを直接更新しない。設定値はVisual Studioのオプションストレージに保存される。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | なし | - | Visual Studioオプションストレージに保存 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|---------------|
| MSG001 | 警告 | 常時表示 | CodeStyleNoticeTextBlock - EditorConfigファイルの設定が優先される旨の通知 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| オプションストレージ書き込みエラー | Visual Studioの標準エラーハンドリング |

## 備考

- コンパクトなUI構成（設定項目数が少ない）
- CodeStyleNoticeTextBlockで EditorConfig優先の警告を表示
- 入力時書式設定がオフの場合、セミコロン/閉じ括弧時設定は無効化
- TypeForwardedToでCodeStyleNoticeTextBlockを現アセンブリから参照可能に
- CSharpVSResourcesからローカライズ文字列を取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

書式設定オプションの定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AutoFormattingOptionsStorage | オプション定義 | FormatOnTyping、FormatOnCloseBrace、FormatOnSemicolon、FormatOnReturnの定義 |
| 1-2 | FormattingOptionsStorage | オプション定義 | FormatOnPasteの定義 |

**読解のコツ**: 書式設定オプションは2つのオプションストレージに分かれている。AutoFormattingOptionsStorageは入力時の自動書式設定、FormattingOptionsStorageはその他の書式設定を管理する。

#### Step 2: エントリーポイントを理解する

コンストラクタでのオプションバインディングとUI初期化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FormattingOptionPageControl.xaml.cs | `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPageControl.xaml.cs` | コンストラクタでのラベル設定とBindToOption呼び出しを理解する |

**主要処理フロー**:
1. **27行目**: InitializeComponent() でXAML UIを構築
2. **29-33行目**: 各チェックボックスのContentプロパティにローカライズ文字列を設定
3. **35-39行目**: BindToOptionで各オプションをバインド

#### Step 3: UI構成を理解する

XAMLファイルでのUI構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FormattingOptionPageControl.xaml | `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPageControl.xaml` | ScrollViewer、StackPanel、GroupBox、チェックボックスの配置、階層構造 |

**主要処理フロー**:
- **15行目**: CodeStyleNoticeTextBlock配置（EditorConfig警告）
- **16行目**: Generalグループボックス
- **18行目**: 入力時書式設定チェックボックス
- **19-22行目**: 子チェックボックス（インデント付き、親に依存）

### プログラム呼び出し階層図

```
Visual Studio Options Dialog
    │
    └─ FormattingOptionPageControl
           │
           ├─ AbstractOptionPageControl (継承)
           │
           ├─ InitializeComponent()
           │
           ├─ Content設定 (ローカライズ)
           │      └─ CSharpVSResources
           │
           └─ BindToOption呼び出し
                  ├─ AutoFormattingOptionsStorage.FormatOnTyping
                  ├─ AutoFormattingOptionsStorage.FormatOnCloseBrace
                  ├─ AutoFormattingOptionsStorage.FormatOnSemicolon
                  ├─ AutoFormattingOptionsStorage.FormatOnReturn
                  └─ FormattingOptionsStorage.FormatOnPaste
```

### データフロー図

```
[入力]                      [処理]                           [出力]

CheckBox.IsChecked ─────────▶ BindToOption ────────────────▶ OptionStore
                                   │
FormatWhenTyping ─────────────┬─▶ FormatOnTyping設定
                              │
                              └─▶ 子チェックボックス有効/無効制御
                                   │
FormatOnSemicolon ────────────────▶ FormatOnSemicolon設定
                                   │
FormatOnCloseBrace ───────────────▶ FormatOnCloseBrace設定
                                   │
FormatOnReturn ───────────────────▶ FormatOnReturn設定
                                   │
FormatOnPaste ────────────────────▶ FormatOnPaste設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| FormattingOptionPageControl.xaml | `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPageControl.xaml` | XAML | 書式設定オプションページのUI定義 |
| FormattingOptionPageControl.xaml.cs | `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPageControl.xaml.cs` | ソース | 書式設定オプションページのコードビハインド |
| CSharpVSResources.resx | `src/VisualStudio/CSharp/Impl/CSharpVSResources.resx` | リソース | ローカライズ文字列 |
| CodeStyleNoticeTextBlock.cs | `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.cs` | ソース | EditorConfig警告表示コントロール |
| AbstractOptionPageControl.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPageControl.cs` | ソース | オプションページの基底クラス |
