# 画面設計書 36-VB詳細オプションページコントロール

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「VB詳細オプションページコントロール」の画面設計を記述する。Visual Studioのオプション画面でVisual Basic言語の詳細設定を行うためのコントロールである。

### 本画面の処理概要

本画面では、Visual Basic言語に関する詳細な設定を行う。C#詳細オプションページと類似した構成で、コード分析、ソースジェネレーター、Importディレクティブ、ハイライト、アウトライン、フェーディング、ブロック構造ガイド、コメント、エディタヘルプ、Go To Definition、正規表現、JSON、インターフェース実装、インラインヒント、継承マージンなどの設定項目を提供する。

**業務上の目的・背景**：開発者がVisual StudioでのVBコーディング体験をカスタマイズするための設定画面である。VB固有の機能（End Construct、Line Commit、オブジェクトブラウザへのナビゲート等）も含まれ、VB開発者のニーズに対応する。

**画面へのアクセス方法**：Visual Studioの「ツール」メニュー > 「オプション」 > 「テキストエディター」 > 「Basic」 > 「詳細」を選択することで本画面が表示される。

**主要な操作・処理内容**：
1. 分析設定 - バックグラウンドコード分析のスコープ、コンパイラ診断のスコープ
2. ソースジェネレーター設定 - 実行タイミング（自動/バランス）
3. Importディレクティブ設定 - System名前空間の優先、Imports提案
4. ハイライト設定 - 参照ハイライト、キーワードハイライト
5. アウトライン設定 - 折りたたみ動作
6. エディタヘルプ設定 - Line Commit、End Construct、インターフェースメンバー自動挿入
7. インラインヒント設定 - パラメータ名ヒントの詳細設定

**画面遷移**：Visual Studioオプションダイアログ内のページとして表示される。他のオプションページへの遷移はサイドメニューから行う。

**権限による表示制御**：特になし。Visual Studioのオプション設定画面にアクセスできるすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 102 | VS VB拡張 | 主機能 | Visual Basicの詳細設定（C#詳細設定と類似構成） |

## 画面種別

設定（オプションページ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。Visual Studioのオプションダイアログ内の登録されたページとして表示される。

## 入出力項目

C#詳細オプションページと類似した構成だが、VB固有の設定項目が含まれる。

### VB固有の設定項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| End Construct | EnableEndConstruct | bool | End Constructの自動挿入 |
| Line Commit | EnableLineCommit | bool | Pretty Listing（行のコミット時に整形） |
| インターフェース/MustOverrideメンバー自動挿入 | AutomaticInsertionOfInterfaceAndMustOverrideMembers | bool | インターフェース実装時のメンバー自動挿入 |
| オブジェクトブラウザへナビゲート | NavigateToObjectBrowser | bool | Go To Definition時にオブジェクトブラウザを使用 |

### C#と共通の設定項目

- 分析設定（バックグラウンドコード分析スコープ等）
- ソースジェネレーター設定
- Importディレクティブ設定（System名前空間優先等）
- ハイライト設定
- アウトライン設定
- フェーディング設定
- ブロック構造ガイド設定
- コメント設定
- 正規表現設定
- JSON文字列設定
- インターフェース実装設定
- インラインヒント設定
- 継承マージン設定

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Analysisグループボックス | GroupBox | 分析設定の区画 |
| Source Generatorsグループボックス | GroupBox | ソースジェネレーター設定の区画 |
| Import Directivesグループボックス | GroupBox | Importディレクティブ設定の区画（VB名称） |
| Highlightingグループボックス | GroupBox | ハイライト設定の区画 |
| Outliningグループボックス | GroupBox | アウトライン設定の区画 |
| Fadingグループボックス | GroupBox | フェーディング設定の区画 |
| Block Structure Guidesグループボックス | GroupBox | ブロック構造ガイド設定の区画 |
| Commentsグループボックス | GroupBox | コメント設定の区画（アポストロフィコメント） |
| Editor Helpグループボックス | GroupBox | エディタヘルプ設定の区画（VB固有機能含む） |
| Go To Definitionグループボックス | GroupBox | Go To Definition設定の区画 |
| Regular Expressionsグループボックス | GroupBox | 正規表現設定の区画 |
| JSON stringsグループボックス | GroupBox | JSON文字列設定の区画 |
| Implement Interface or Abstract Classグループボックス | GroupBox | インターフェース実装設定の区画 |
| Inline Hintsグループボックス | GroupBox | インラインヒント設定の区画 |
| Inheritance Marginグループボックス | GroupBox | 継承マージン設定の区画 |

## イベント仕様

### 1-アウトライン有効/無効イベント

`EnableOutlining_Checked` / `EnableOutlining_Unchecked` イベントで、アウトライン関連のサブオプション（折りたたみ設定）の有効/無効状態を切り替える。

### 2-インラインパラメータ名ヒント有効/無効イベント

`DisplayInlineParameterNameHints_Checked` / `DisplayInlineParameterNameHints_Unchecked` イベントで、パラメータ名ヒント関連のサブオプションの有効/無効状態を切り替える。

### 3-各チェックボックス/コンボボックス変更イベント

`BindToOption` で関連付けられたオプションストレージに値が保存される。

## データベース更新仕様

本画面はデータベースを直接更新しない。設定値はVisual Studioのオプションストレージに保存される。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | なし | - | Visual Studioオプションストレージに保存 |

## メッセージ仕様

特になし。設定変更は即時反映される。

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| オプションストレージ書き込みエラー | Visual Studioの標準エラーハンドリング |

## 備考

- VBコードビハインド（.xaml.vb）で実装されている
- C#詳細オプションページと類似構成だが、VB固有機能が追加されている
- インライン型ヒントはVBでは提供されていない（C#のみ）
- Go To Definition設定はオブジェクトブラウザへのナビゲート設定のみ
- コメント設定はアポストロフィ（'''）ベースの設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VB固有のオプション定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | EndConstructGenerationOptionsStorage | オプション定義 | EndConstruct設定 |
| 1-2 | LineCommitOptionsStorage | オプション定義 | PrettyListing設定 |
| 1-3 | AutomaticInsertionOfAbstractOrInterfaceMembersOptionsStorage | オプション定義 | 自動メンバー挿入設定 |
| 1-4 | VisualStudioNavigationOptionsStorage | オプション定義 | オブジェクトブラウザナビゲート設定 |

**読解のコツ**: VB固有の設定はC#にはない機能を提供する。特にLine Commit（Pretty Listing）はVBの特徴的な機能で、行を離れる際に自動的にコードを整形する。

#### Step 2: エントリーポイントを理解する

コンストラクタでのオプションバインディング設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AdvancedOptionPageControl.xaml.vb | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml.vb` | コンストラクタでのBindToOption呼び出し、VB固有設定を理解する |
| 2-2 | AdvancedOptionPageControl.xaml | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml` | GroupBox構成とコントロール配置を理解する |

**主要処理フロー**:
1. **42-153行目**: コンストラクタで各オプションをUIコントロールにバインド
2. **107-109行目**: VB固有のEnd Construct、Line Commit設定
3. **117行目**: オブジェクトブラウザナビゲート設定
4. **157-196行目**: アウトライン、インラインヒントの有効/無効状態制御

#### Step 3: C#との差異を理解する

VB固有の機能とC#との違いを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AdvancedOptionPageControl.xaml（VB） | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml` | VB固有のEditor Help設定、Go To Definition設定 |
| 3-2 | AdvancedOptionPageControl.xaml（C#） | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml` | 比較用 |

**主要な差異**:
- VB: End Construct、Line Commit、インターフェースメンバー自動挿入
- VB: オブジェクトブラウザへのナビゲート（Go To Definition）
- VB: インライン型ヒントなし
- VB: 文字列分割機能なし

### プログラム呼び出し階層図

```
Visual Studio Options Dialog
    │
    └─ AdvancedOptionPageControl (VB)
           │
           ├─ AbstractOptionPageControl (継承)
           │      └─ BindToOption<T>(control, option, language)
           │
           ├─ InitializeComponent()
           │
           ├─ BindToOption呼び出し (多数)
           │      ├─ SolutionCrawlerOptionsStorage (共通)
           │      ├─ InlineHintsOptionsStorage (共通)
           │      ├─ EndConstructGenerationOptionsStorage (VB固有)
           │      ├─ LineCommitOptionsStorage (VB固有)
           │      ├─ AutomaticInsertionOfAbstractOrInterfaceMembersOptionsStorage (VB固有)
           │      └─ VisualStudioNavigationOptionsStorage (VB固有)
           │
           └─ イベントハンドラ
                  ├─ EnableOutlining_Checked/Unchecked
                  └─ DisplayInlineParameterNameHints_Checked/Unchecked
```

### データフロー図

```
[入力]                      [処理]                           [出力]

XAML UIコントロール ───────▶ BindToOption ─────────────────▶ OptionStore
    │                              │                          (VB用)
    ├─ CheckBox.IsChecked          ├─ bool値変換
    ├─ ComboBox.SelectedIndex      ├─ enum値変換
    └─ RadioButton.IsChecked       └─ LanguageNames.VisualBasic指定
                                         │
                                         ▼
                              Visual Studio Settings
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AdvancedOptionPageControl.xaml | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml` | XAML | VB詳細オプションページのUI定義 |
| AdvancedOptionPageControl.xaml.vb | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml.vb` | ソース | VB詳細オプションページのコードビハインド |
| AdvancedOptionPageStrings.vb | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageStrings.vb` | ソース | ローカライズ文字列定義 |
| AbstractOptionPageControl.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPageControl.cs` | ソース | オプションページの基底クラス |
