# 画面設計書 37-設定エディタコントロール

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「設定エディタコントロール」の画面設計を記述する。EditorConfigファイルをGUIで編集するための統合エディタコントロールである。

### 本画面の処理概要

本画面では、.editorconfigファイルの設定を視覚的に編集できる。4つのタブ（Whitespace、Code Style、Naming Style、Analyzers）を切り替えて、各種設定を一覧形式で表示・編集する。変更はEditorConfigファイルに即時反映される。

**業務上の目的・背景**：EditorConfigファイルは手動でテキスト編集が必要であり、設定項目の名前やオプション値を覚えておく必要がある。本画面により、GUIベースで直感的にEditorConfig設定を編集でき、設定ミスを防ぎ、開発効率を向上させる。また、どの設定がどのスコープ（EditorConfigファイル、Visual Studioオプション）から来ているかを可視化する。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック、または右クリック > 「開く」でEditorConfigエディタが表示される。

**主要な操作・処理内容**：
1. Whitespaceタブ - インデント、タブサイズ等の空白設定を編集
2. Code Styleタブ - コードスタイル設定（varの使用、括弧の配置等）を編集
3. Naming Styleタブ - 命名規則設定を編集
4. Analyzersタブ - アナライザールールの重大度を編集
5. 検索 - 設定項目を検索してフィルタリング
6. 自動保存 - 変更はEditorConfigファイルに自動反映

**画面遷移**：ソリューションエクスプローラーから開く。各タブ間は自由に切り替え可能。

**権限による表示制御**：特になし。EditorConfigファイルへの書き込み権限がない場合は読み取り専用となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | EditorConfigファイルの設定編集（4タブ切替） |

## 画面種別

設定エディタ（ドキュメントエディタ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。EditorConfigファイルを開くとこのカスタムエディタが表示される。

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力/出力 | 説明 |
|--------|--------|----------|------|-----------|------|
| ファイルパス | _filepath | string | ○ | 入力 | 編集対象のEditorConfigファイルパス |
| Whitespace設定ビュー | WhitespaceControl | UserControl | - | 入出力 | 空白設定の編集ビュー |
| Code Style設定ビュー | CodeStyleControl | UserControl | - | 入出力 | コードスタイル設定の編集ビュー |
| Naming Style設定ビュー | NamingStyleControl | UserControl | - | 入出力 | 命名スタイル設定の編集ビュー |
| Analyzers設定ビュー | AnalyzersControl | UserControl | - | 入出力 | アナライザー設定の編集ビュー |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Whitespaceタブ | TabItem | 空白設定タブ |
| Code Styleタブ | TabItem | コードスタイル設定タブ |
| Naming Styleタブ | TabItem | 命名スタイル設定タブ |
| Analyzersタブ | TabItem | アナライザー設定タブ |
| 検索コントロール | Border | 検索ボックスの配置エリア |
| 設定表示エリア | Grid | 各タブのContentPresenterを配置 |

## イベント仕様

### 1-タブ選択変更イベント

`TabsSettingsEditor_SelectionChanged` イベントハンドラで、タブ切り替え時に対応するContentPresenterの表示/非表示を制御する。前のタブのFrameをHidden、新しいタブのFrameをVisibleに設定。

### 2-フォーカス離脱時の同期イベント

`SynchronizeSettings` メソッドで、コントロールからフォーカスが離れる際にEditorConfigファイルへの変更を同期する。各ビューの `UpdateEditorConfigAsync` メソッドを呼び出し、テキスト変更を取得してファイルに反映。

### 3-クローズイベント

`OnClose` メソッドで、各ビューの `ShutDown` メソッドを呼び出してリソースを解放する。

## データベース更新仕様

本画面はデータベースを直接更新しない。変更はEditorConfigファイル（テキストファイル）に書き込まれる。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | なし | - | EditorConfigファイルに書き込み |

## メッセージ仕様

特になし。設定変更はサイレントにEditorConfigファイルに反映される。

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| EditorConfigファイル書き込みエラー | Visual Studioの標準エラーハンドリング |
| ファイルが存在しない | エディタが開けない |

## 備考

- 4つのタブは最初からすべて生成されており、表示/非表示で切り替え
- 検索ボックスはSearchControl Borderに外部から挿入される
- EditorTextUpdaterでIVsTextLines経由のファイル更新
- VS Themeに対応したスタイルを適用
- TabControlStylesでカスタムタブスタイルを定義

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビューとビューモデルのインターフェースを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ISettingsEditorView | インターフェース定義 | SettingControl、TableControl、UpdateEditorConfigAsync、OnCloseの定義 |
| 1-2 | IWpfSettingsEditorViewModel | インターフェース定義 | GetTableControl、UpdateEditorConfigAsync、ShutDownの定義 |

**読解のコツ**: 各タブ（Whitespace、CodeStyle、NamingStyle、Analyzers）は同じインターフェースを実装しており、統一的に扱われる。

#### Step 2: エントリーポイントを理解する

コンストラクタでの初期化とビューの組み立てを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SettingsEditorControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml.cs` | コンストラクタでの4つのビュー受け取り、配列への格納を理解する |
| 2-2 | SettingsEditorControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml` | TabControl構成、ContentPresenter配置を理解する |

**主要処理フロー**:
1. **40-72行目**: コンストラクタで4つのビューとWorkspace、ファイルパスを受け取り
2. **56-67行目**: 各ビューをプロパティに設定し、配列に格納
3. **76-110行目**: SynchronizeSettingsでEditorConfig同期
4. **122-163行目**: タブ切り替えイベントハンドラ

#### Step 3: EditorConfig同期を理解する

ファイルへの書き込み処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SettingsEditorControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml.cs` | SynchronizeSettingsメソッドの実装を理解する |
| 3-2 | EditorTextUpdater | 内部クラス | IVsTextLinesへのテキスト更新を理解する |

**主要処理フロー**:
- **76-81行目**: フォーカス確認
- **83-92行目**: AnalyzerConfigDocumentの取得
- **94-109行目**: 各ビューのUpdateEditorConfigAsync呼び出しと差分更新

### プログラム呼び出し階層図

```
SettingsEditorFactory
    │
    └─ SettingsEditorControl (new)
           │
           ├─ ISettingsEditorView (4つ)
           │      ├─ WhitespaceSettingsView
           │      ├─ CodeStyleSettingsView
           │      ├─ NamingStyleSettingsView
           │      └─ AnalyzerSettingsView
           │
           ├─ TabControl
           │      ├─ WhitespaceTab
           │      ├─ CodeStyleTab
           │      ├─ NamingStyleTab
           │      └─ AnalyzersTab
           │
           ├─ ContentPresenter (4つ)
           │      └─ Visibility制御
           │
           ├─ SynchronizeSettings()
           │      ├─ UpdateEditorConfigAsync (各ビュー)
           │      └─ EditorTextUpdater.UpdateText
           │
           └─ OnClose()
                  └─ view.OnClose() (各ビュー)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

.editorconfig ────────────▶ Workspace.CurrentSolution ───▶ AnalyzerConfigDocument
    │                              │
    │                              ├─ WhitespaceSettingsView
    │                              ├─ CodeStyleSettingsView
    │                              ├─ NamingStyleSettingsView
    │                              └─ AnalyzerSettingsView
    │                                      │
UIでの設定変更 ───────────────────────────▶ UpdateEditorConfigAsync
                                              │
                                              ▼
                                   SourceText (更新後)
                                              │
                                              ▼
                                   EditorTextUpdater.UpdateText
                                              │
                                              ▼
                                   IVsTextLines → .editorconfig更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SettingsEditorControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml` | XAML | 設定エディタのメインUI定義 |
| SettingsEditorControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml.cs` | ソース | 設定エディタのコードビハインド |
| TabControlStyles.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml` | XAML | タブコントロールのスタイル定義 |
| WhitespaceSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceSettingsView.xaml` | XAML | 空白設定ビュー |
| CodeStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml` | XAML | コードスタイル設定ビュー |
| NamingStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml` | XAML | 命名スタイル設定ビュー |
| AnalyzerSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/AnalyzerSettingsView.xaml` | XAML | アナライザー設定ビュー |
