# 画面設計書 39-空白ブール設定ビュー

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「空白ブール設定ビュー」の画面設計を記述する。空白設定テーブル内のブール値（true/false）を編集するためのセルビューコントロールである。

### 本画面の処理概要

本画面は、空白設定ビュー（No.38）のテーブル内で使用されるカスタムセルコントロールである。ブール値の設定項目をチェックボックス形式で表示・編集する。VS Themeに対応したカスタムスタイルを持つCheckBoxを提供する。

**業務上の目的・背景**：EditorConfig設定にはブール値を取るオプション（例：insert_final_newline、trim_trailing_whitespace等）がある。これらの設定を直感的に編集できるよう、チェックボックス形式のUIを提供する。

**画面へのアクセス方法**：空白設定ビューのテーブル内で、ブール値の設定項目のセルとして自動的に使用される。

**主要な操作・処理内容**：
1. チェックボックス表示 - ブール設定値をチェック状態で表示
2. チェック状態変更 - クリックでtrue/falseを切り替え
3. ツールチップ表示 - 設定の説明をツールチップで表示

**画面遷移**：テーブルセル内のコントロールのため、画面遷移はない。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | 空白のブール設定（チェックボックス形式） |

## 画面種別

セルエディタ（テーブルセルコントロール）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力/出力 | 説明 |
|--------|--------|----------|------|-----------|------|
| チェック状態 | IsChecked | bool? | ○ | 入出力 | チェックボックスの状態（true/false/null） |
| ツールチップ | ToolTip | string | - | 入力 | 設定の説明 |
| オートメーション名 | AutomationName | string | - | 入力 | アクセシビリティ用の名前 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| チェックボックス | CheckBox | ブール値の表示・編集 |
| チェックマーク | Path | チェック状態の視覚表示 |
| 不確定マーク | Rectangle | null状態の視覚表示 |

## イベント仕様

### 1-チェック状態変更イベント

CheckBoxのIsCheckedプロパティが変更されると、バインディング経由でビューモデルのIsCheckedプロパティが更新される。

### 2-フォーカス状態変更イベント

IsFocused、IsMouseOver、IsPressedの状態変更時に、VS Themeに対応した視覚状態（背景色、ボーダー色、グリフ色）が変更される。

## データベース更新仕様

本画面はデータベースを直接更新しない。値の変更はビューモデル経由で処理される。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| チェック状態変更 | なし | - | ビューモデル経由でEditorConfigに反映 |

## メッセージ仕様

特になし。

## 例外処理

特になし。

## 備考

- VS Themeに完全対応したカスタムCheckBoxスタイルを定義
- HighContrastモード対応（Tag="{DynamicResource {x:Static SystemParameters.HighContrastKey}}"）
- CommonControlsColorsのブラシを使用して各状態の色を制御
- チェックマークはPath要素でSVG風に描画
- 不確定状態（null）はRectangleで表示
- FocusVisualStyleでキーボードフォーカス時の視覚表示を定義

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビューモデルの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WhitespaceSettingBoolViewModel | 内部クラス | IsChecked、ToolTip、AutomationNameプロパティの定義 |

**読解のコツ**: ビューモデルはチェック状態と表示情報を提供し、変更通知を実装している。

#### Step 2: エントリーポイントを理解する

コンストラクタでの初期化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WhitespaceBoolSettingView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceBoolSettingView.xaml.cs` | コンストラクタでのビューモデル設定を理解する |

**主要処理フロー**:
1. **15-19行目**: コンストラクタでビューモデルをDataContextに設定

#### Step 3: UI構成を理解する

XAMLファイルでのカスタムCheckBoxスタイルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WhitespaceBoolSettingView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceBoolSettingView.xaml` | カスタムCheckBoxスタイル、Triggerによる状態管理を理解する |

**主要処理フロー**:
- **11-23行目**: FocusVisualStyleの定義
- **26-30行目**: CheckBoxの基本設定（バインディング、ツールチップ、オートメーション）
- **35-72行目**: ControlTemplate定義（チェックマーク、不確定マーク）
- **73-143行目**: Trigger定義（各種状態での視覚変更）

### プログラム呼び出し階層図

```
WhitespaceSettingsView (テーブル)
    │
    └─ WhitespaceBoolSettingView (セル)
           │
           ├─ WhitespaceSettingBoolViewModel
           │      ├─ IsChecked
           │      ├─ ToolTip
           │      └─ AutomationName
           │
           └─ CheckBox (カスタムスタイル)
                  ├─ CheckMarkBorder
                  ├─ CheckMark (Path)
                  └─ IndeterminateMark (Rectangle)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

WhitespaceSetting
BoolViewModel ─────────────▶ DataContext ────────────────▶ CheckBox
    │
    ├─ IsChecked ───────────▶ CheckBox.IsChecked
    ├─ ToolTip ─────────────▶ CheckBox.ToolTip
    └─ AutomationName ──────▶ AutomationProperties.Name

ユーザークリック ──────────▶ IsChecked変更 ────────────────▶ ViewModel更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WhitespaceBoolSettingView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceBoolSettingView.xaml` | XAML | ブール設定ビューのUI定義 |
| WhitespaceBoolSettingView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceBoolSettingView.xaml.cs` | ソース | ブール設定ビューのコードビハインド |
| WhitespaceSettingBoolViewModel.cs | 内部クラス | ソース | ブール設定のビューモデル |
| CommonControlsColors | VS Shell | リソース | VS Theme対応の色定義 |
