# 画面設計書 4-クラス抽出ダイアログ

## 概要

本ドキュメントは、既存のクラスから新しいクラスを抽出するためのダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

クラス抽出ダイアログは、既存クラスのメンバーを選択して新しいクラスを作成し、元のクラスからはそのクラスへの継承または委譲を行うリファクタリング機能を提供する画面である。

**業務上の目的・背景**：クラスが肥大化した場合や、関心事の分離が必要な場合に、クラスの一部を新しいクラスとして抽出する必要がある。本ダイアログは、抽出するメンバーの選択と、新しいクラスの配置先を設定するインターフェースを提供し、安全にクラス分割を実行する。

**画面へのアクセス方法**：エディタ内でクラス定義にカーソルを置き、コンテキストメニューまたはクイックアクションから「Extract base class...」を選択する。

**主要な操作・処理内容**：
1. 抽出先クラス名の入力
2. 生成されるファイル名の確認
3. 配置先ファイルの選択（現在のファイル/新規ファイル）
4. 抽出するメンバーの選択（チェックボックス）
5. 抽象メンバーとして抽出するかの選択
6. 全選択/全解除ボタン
7. OKボタンで抽出実行、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：エディタコンテキストメニュー、クイックアクション
- 遷移先：なし
- 戻り先：エディタ（OK/Cancel時）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | クラス抽出 | 主機能 | 抽出するメンバーの選択と新規クラスの設定 |
| 137 | メンバー選択 | 補助機能 | 抽出対象メンバーの選択操作（MemberSelectionコントロール使用） |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| TypeName | 入出力 | string | Yes | 新しいクラス名 |
| GeneratedName | 出力 | string | No | 生成されるファイル名（読み取り専用） |
| Destination | 入出力 | NewTypeDestination | Yes | 配置先（CurrentFile/NewFile） |
| FileName | 入出力 | string | No | 新規ファイル名（NewFile選択時） |
| Members | 入出力 | List<MemberSymbolViewModel> | Yes | 選択可能なメンバー一覧 |
| SelectedMembers | 出力 | List<ISymbol> | Yes | 選択されたメンバー |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| 新しい型名 | TypeName | TextBox | 抽出先クラス名入力 |
| 生成名 | GeneratedName | TextBox（読み取り専用） | 生成されるファイル/クラス名 |
| 配置先選択 | Destination | RadioButton群 | 現在のファイル/新規ファイル |
| ファイル名 | FileName | TextBox | 新規ファイル名（NewFile時のみ有効） |
| メンバー一覧 | Members | DataGrid + CheckBox | 抽出候補メンバー |
| 抽象化選択 | MakeAbstract | CheckBox（各行） | 抽象メンバーとして抽出 |

## イベント仕様

### 1-クラス名入力変更

クラス名を入力すると、GeneratedNameプロパティが連動して更新される。

### 2-配置先選択変更

- 「Same file」選択時：ファイル名入力欄が無効化
- 「New file」選択時：ファイル名入力欄が有効化、デフォルト値設定

### 3-メンバー選択変更

DataGrid内のチェックボックスでメンバーを選択/解除。選択状態はMemberSymbolViewModelのIsCheckedプロパティにバインド。

### 4-抽象化選択変更

メンバーごとに「Make abstract」チェックボックスを切り替え。MakeAbstractプロパティにバインド。

### 5-全選択ボタン（Select All）

すべてのチェック可能なメンバーを選択状態にする。

### 6-全解除ボタン（Deselect All）

すべてのメンバーの選択を解除する。

### 7-OK確定

TrySubmit()でバリデーション実行後、DialogResult=trueで閉じる。

### 8-キャンセル

DialogResult=falseでダイアログを閉じる。

## データベース更新仕様

該当なし（データベースアクセスなし、ソースコードリファクタリング操作）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| エラー | ERR_NO_TYPE_NAME | クラス名を入力してください | クラス名未入力時 |
| エラー | ERR_NO_MEMBERS | 少なくとも1つのメンバーを選択してください | メンバー未選択時 |

## 例外処理

| 状態 | 対応 |
|------|------|
| クラス名が無効な識別子 | バリデーションエラー |
| ファイル作成権限なし | エラーメッセージを表示 |

## 備考

- ダイアログサイズ: 500x498（最小510x498）
- リサイズ可能（CanResizeWithGrip）
- NewTypeDestinationSelectionコントロールを使用（共通コンポーネント）
- MemberSelectionコントロールを使用（共通コンポーネント）
- VSThemeDictionary.xamlを参照してテーマ対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExtractClassViewModel.cs | `src/VisualStudio/Core/Def/ExtractClass/ExtractClassViewModel.cs` | ダイアログ全体のViewModel |
| 1-2 | MemberSymbolViewModel.cs | `src/VisualStudio/Core/Def/Utilities/MemberSymbolViewModel.cs` | メンバー行のViewModel |
| 1-3 | NewTypeDestinationSelectionViewModel.cs | `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelectionViewModel.cs` | 配置先選択のViewModel |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExtractClassDialog.xaml.cs | `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml.cs` | ダイアログのコードビハインド |

**主要処理フロー**:
1. **行25-34**: コンストラクタでViewModelをバインド、MemberSelectionコントロール初期化
2. **行36-42**: OK_ClickでTrySubmit実行
3. **行44-45**: Cancel_ClickでDialogResult=false

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExtractClassDialog.xaml | `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml` | メインダイアログUI |
| 3-2 | NewTypeDestinationSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelection.xaml` | 配置先選択コントロール |
| 3-3 | MemberSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` | メンバー選択コントロール |

**主要処理フロー**:
- **行37**: NewTypeDestinationSelectionコントロールを配置
- **行39-46**: MemberSelectionGroupBoxでメンバー選択エリア
- **行48-70**: OK/Cancelボタン

### プログラム呼び出し階層図

```
ExtractClassDialog (UI)
    │
    ├─ ExtractClassViewModel
    │      ├─ Title (ダイアログタイトル)
    │      ├─ DestinationViewModel (配置先設定)
    │      ├─ MemberSelectionViewModel (メンバー選択)
    │      └─ TrySubmit (バリデーション)
    │
    ├─ NewTypeDestinationSelection (共通コントロール)
    │      └─ NewTypeDestinationSelectionViewModel
    │             ├─ TypeName
    │             ├─ GeneratedName
    │             ├─ Destination
    │             └─ FileName
    │
    └─ MemberSelection (共通コントロール)
           └─ MemberSelectionViewModel
                  ├─ Members
                  ├─ SelectAll
                  └─ DeselectAll
```

### データフロー図

```
[入力]                    [処理]                         [出力]

元クラス情報 ──────▶ ExtractClassDialog ──────────▶ 新クラスファイル
     │                       │                           │
     ├─ メンバー一覧         │                           ├─ 抽出されたメンバー
     ├─ クラス名            │                           └─ 継承関係
     └─ 配置先設定          │
                            ▼
                    ExtractClassOptions
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExtractClassDialog.xaml | `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml` | XAML | ダイアログUI定義 |
| ExtractClassDialog.xaml.cs | `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml.cs` | ソース | コードビハインド |
| ExtractClassViewModel.cs | `src/VisualStudio/Core/Def/ExtractClass/ExtractClassViewModel.cs` | ソース | ViewModel |
| NewTypeDestinationSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelection.xaml` | XAML | 配置先選択コントロール |
| MemberSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` | XAML | メンバー選択コントロール |
| MemberSymbolViewModel.cs | `src/VisualStudio/Core/Def/Utilities/MemberSymbolViewModel.cs` | ソース | メンバー行ViewModel |
| VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | リソース | テーマ定義 |
