# 画面設計書 40-コードスタイル設定ビュー

## 概要

本ドキュメントは、Visual Studio Roslyn拡張機能における「コードスタイル設定ビュー」の画面設計を記述する。EditorConfigエディタのCode Styleタブで表示される、コードスタイル設定を編集するためのビューである。

### 本画面の処理概要

本画面では、.editorconfigファイルのコードスタイルに関する設定（varの使用、括弧の配置、式本体メンバーの使用等）を表形式で表示・編集できる。IWpfTableControlを使用したテーブル表示で、各設定項目の値と重大度を直接編集できる。

**業務上の目的・背景**：C#およびVisual Basicのコードスタイルは多岐にわたり、チームで統一した規約を定める必要がある。本ビューにより、EditorConfigのコードスタイル設定を視覚的に編集でき、各設定の推奨値と違反時の重大度（None、Suggestion、Warning、Error）を設定できる。

**画面へのアクセス方法**：設定エディタコントロール（No.37）のCode Styleタブを選択することで本ビューが表示される。

**主要な操作・処理内容**：
1. 設定一覧表示 - コードスタイル設定をテーブル形式で表示
2. 設定値編集 - 各設定のドロップダウンで推奨値を選択
3. 重大度編集 - 各設定の重大度をドロップダウンで選択
4. 設定の反映 - 変更をEditorConfigファイルに反映

**画面遷移**：設定エディタコントロールのタブとして表示される。他のタブへの遷移はタブ切り替えで行う。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | コードスタイル設定の一覧表示 |

## 画面種別

設定ビュー（タブコンテンツ）

## URL/ルーティング

デスクトップアプリケーション（Visual Studio拡張）のため、URLルーティングは適用外。

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力/出力 | 説明 |
|--------|--------|----------|------|-----------|------|
| テーブルコントロール | TableControl | IWpfTableControl | ○ | 入出力 | 設定一覧テーブル |
| ビューモデル | _viewModel | IWpfSettingsEditorViewModel | ○ | 入力 | 設定データとテーブル制御 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| コードスタイル設定テーブル | IWpfTableControl | 設定項目の一覧表示 |
| ContentPresenter | ContentPresenter | テーブルコントロールを配置 |

## イベント仕様

### 1-設定値変更イベント

テーブル内の設定値が変更されると、ビューモデル経由でEditorConfig更新処理がトリガーされる。

### 2-UpdateEditorConfigAsyncイベント

親コントロール（設定エディタコントロール）からの同期要求に応じて、`_viewModel.UpdateEditorConfigAsync` を呼び出し、変更をSourceTextとして返す。

### 3-OnCloseイベント

ビューが閉じられる際に `_viewModel.ShutDown()` を呼び出してリソースを解放する。

## データベース更新仕様

本画面はデータベースを直接更新しない。変更はEditorConfigファイルに書き込まれる。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | なし | - | EditorConfigファイルに書き込み |

## メッセージ仕様

特になし。

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ビューモデル初期化エラー | Visual Studioの標準エラーハンドリング |

## 備考

- ISettingsEditorViewインターフェースを実装
- ContentPresenterでIWpfTableControlをホスト
- マージン設定（12, 0）で左右に余白
- VS Themeに対応したスタイルを適用
- 空白設定ビュー（No.38）と同じ構造だが、表示する設定項目が異なる
- 関連するセルコントロール：CodeStyleValueControl（No.41）、CodeStyleSeverityControl（No.42）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビューモデルのインターフェースを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IWpfSettingsEditorViewModel | インターフェース定義 | GetTableControl、UpdateEditorConfigAsync、ShutDownの定義 |
| 1-2 | ISettingsEditorView | インターフェース定義 | SettingControl、TableControl、UpdateEditorConfigAsync、OnCloseの定義 |

**読解のコツ**: このビューはISettingsEditorViewを実装しており、空白設定ビュー（No.38）と同じパターンである。

#### Step 2: エントリーポイントを理解する

コンストラクタでの初期化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeStyleSettingsView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml.cs` | コンストラクタでのビューモデル設定、テーブルコントロール取得を理解する |
| 2-2 | CodeStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml` | ContentPresenterでのテーブル配置を理解する |

**主要処理フロー**:
1. **19-26行目**: コンストラクタでビューモデルを設定
2. **23行目**: GetTableControl()でテーブルコントロールを取得
3. **24行目**: CodeStyleTable.Content にテーブルを設定
4. **25行目**: DataContextにビューモデルを設定
5. **30行目**: UpdateEditorConfigAsyncの委譲
6. **31行目**: OnCloseでShutDownの委譲

#### Step 3: UI構成を理解する

XAMLファイルでのシンプルな構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml` | ContentPresenter配置のみのシンプルな構成（空白設定ビューと同様） |

**主要処理フロー**:
- **10-14行目**: ContentPresenter定義（マージン、アライメント設定）

### プログラム呼び出し階層図

```
SettingsEditorControl
    │
    └─ CodeStyleSettingsView
           │
           ├─ ISettingsEditorView (実装)
           │
           ├─ IWpfSettingsEditorViewModel
           │      ├─ GetTableControl()
           │      ├─ UpdateEditorConfigAsync()
           │      └─ ShutDown()
           │
           ├─ IWpfTableControl
           │      └─ Control (WPFコントロール)
           │
           └─ ContentPresenter
                  └─ Content = TableControl.Control

テーブルセル内:
    ├─ CodeStyleValueControl (値選択)
    └─ CodeStyleSeverityControl (重大度選択)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

IWpfSettingsEditor
ViewModel ─────────────────▶ GetTableControl() ───────────▶ IWpfTableControl
    │                              │
    │                              └─ CodeStyleTable.Content
    │
    └─ DataContext設定

設定値変更 ────────────────▶ セルビューモデル更新

UpdateEditorConfigAsync ───▶ _viewModel.UpdateEditorConfigAsync ──▶ SourceText
    │
OnClose ───────────────────▶ _viewModel.ShutDown()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml` | XAML | コードスタイル設定ビューのUI定義 |
| CodeStyleSettingsView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml.cs` | ソース | コードスタイル設定ビューのコードビハインド |
| CodeStyleValueControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueControl.xaml` | XAML | 値選択用のセルコントロール |
| CodeStyleSeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSeverityControl.xaml` | XAML | 重大度選択用のセルコントロール |
