# 画面設計書 41-コードスタイル値コントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能におけるコードスタイル値コントロール（CodeStyleValueControl）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタのコードスタイルタブにおいて、各コードスタイルオプションの値を選択するためのドロップダウンコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：開発チームにおいてコードスタイルの一貫性を保つことは、可読性向上とメンテナンスコスト削減に直結します。本コントロールは、EditorConfigファイルを介してコードスタイル設定を管理する際に、個々のスタイルオプション（例：var の使用方法、式本体メンバーの使用など）の値をGUIから選択できるようにするものです。これにより、開発者はテキストエディタでEditorConfigを直接編集することなく、視覚的に設定を変更できます。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Code Style」タブを選択 → コードスタイル設定ビュー内の各行の「Value」列に本コントロールが表示されます。

**主要な操作・処理内容**：
1. コンボボックスに利用可能な値の一覧が表示される
2. ユーザーがドロップダウンから値を選択する
3. 選択変更時に`SelectionChanged`イベントが発火し、ViewModelに通知される
4. ViewModelを通じてCodeStyleSettingが更新される
5. EditorConfigファイルに変更が反映される

**画面遷移**：本コントロールはコードスタイル設定ビュー（No.40）のテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：特に権限による制御はありません。EditorConfigファイルが読み取り専用の場合、設定変更は反映されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | コードスタイル値のドロップダウン選択 |

## 画面種別

編集コントロール（テーブルセル内ドロップダウン）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Values | 入力 | string[] | 必須 | 選択可能な値の配列（バインディング経由） |
| SelectedValue | 入出力 | string | 必須 | 現在選択されている値（双方向バインディング） |
| ToolTip | 入力 | string | 任意 | ツールチップに表示するテキスト |
| AutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ValueComboBox | ComboBox | コードスタイル値を選択するドロップダウン |

## イベント仕様

### 1-SelectionChanged（値選択変更）

ユーザーがコンボボックスで異なる値を選択した際に発火します。

**処理フロー**：
1. ComboBoxのSelectionChangedイベントが発火
2. ValueComboBox_SelectionChangedイベントハンドラが呼び出される
3. _viewModel.SelectionChanged(ValueComboBox.SelectedIndex)が実行される
4. ViewModelがCodeStyleSettingのChangeValueメソッドを呼び出す
5. CodeStyleSettingがEditorConfigファイルへの書き込みを行う

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 値選択変更 | .editorconfig | UPDATE | 選択したコードスタイル値をEditorConfigファイルに書き込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Value" | マウスホバー時（ServicesVSResources.Value） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| 不正なインデックス選択 | ViewModelで範囲チェックが行われる |

## 備考

- 本コントロールはVisual StudioのThemedDialogスタイルを使用し、Visual Studioテーマに自動的に適応します
- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- CodeStyleValueViewModelを通じてCodeStyleSettingにアクセスします

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コードスタイル設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CodeStyleSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/CodeStyleSetting.cs` | コードスタイル設定を保持するデータクラス。GetValueDescriptions()とChangeValue()メソッドに注目 |

**読解のコツ**: CodeStyleSettingクラスはコードスタイルの設定値を抽象化しており、値の取得・変更のインターフェースを提供しています。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeStyleValueControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueControl.xaml` | XAMLによるUI定義。ComboBoxのバインディング設定を確認 |
| 2-2 | CodeStyleValueControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueControl.xaml.cs` | コードビハインド。SelectionChangedイベントハンドラの実装 |

**主要処理フロー**:
1. **行11-16**: ComboBoxの定義とバインディング設定（Values, SelectedValue, ToolTip, AutomationProperties.Name）
2. **行16**: SelectionChangedイベントのハンドラ指定
3. **行23-24（.cs）**: イベントハンドラでViewModelのSelectionChangedメソッドを呼び出し

#### Step 3: ViewModelを理解する

ViewModelがビューとデータモデルを橋渡しする役割を担います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeStyleValueViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueViewModel.cs` | ViewModelクラス。Valuesプロパティ、SelectionChangedメソッドの実装 |

**主要処理フロー**:
- **行13**: Values プロパティ - _setting.GetValueDescriptions()から選択肢を取得
- **行15-24**: SelectedValue プロパティ - 現在選択中の値を管理
- **行33-34**: SelectionChanged メソッド - 選択変更時に_setting.ChangeValue(selectedIndex)を呼び出し

### プログラム呼び出し階層図

```
CodeStyleValueControl (View)
    │
    ├─ ValueComboBox_SelectionChanged (イベントハンドラ)
    │      │
    │      └─ CodeStyleValueViewModel.SelectionChanged(int)
    │             │
    │             └─ CodeStyleSetting.ChangeValue(int)
    │                    │
    │                    └─ EditorConfigファイルへの書き込み
    │
    └─ DataBinding
           ├─ Values (CodeStyleValueViewModel.Values)
           │      └─ CodeStyleSetting.GetValueDescriptions()
           │
           └─ SelectedValue (CodeStyleValueViewModel.SelectedValue)
                  └─ CodeStyleSetting.GetCurrentValueDescription()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ユーザー選択 ───────▶ CodeStyleValueControl ─────▶ 選択値表示更新
                            │
                            ▼
                     CodeStyleValueViewModel
                            │
                            ▼
                      CodeStyleSetting
                            │
                            ▼
                    .editorconfigファイル ──────▶ ファイル保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeStyleValueControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueControl.xaml` | ビュー | ComboBoxを含むUI定義 |
| CodeStyleValueControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueControl.xaml.cs` | コードビハインド | イベントハンドラ実装 |
| CodeStyleValueViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueViewModel.cs` | ViewModel | ビューとモデルの仲介 |
| CodeStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml` | 親ビュー | 本コントロールを含むテーブルビュー |
| ColumnDefinitions.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/ColumnDefinitions.cs` | 定数定義 | テーブル列定義 |
