# 画面設計書 42-コードスタイル重大度コントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能におけるコードスタイル重大度コントロール（CodeStyleSeverityControl）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタのコードスタイルタブにおいて、各コードスタイルルール違反時の重大度（Severity）を選択するためのドロップダウンコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：コードスタイルルールは単に「適用する・しない」だけでなく、違反時のアクションの強度を設定できます。例えば、あるスタイル違反を単なる提案（Suggestion）として扱うか、警告（Warning）として扱うか、エラー（Error）としてビルドを失敗させるかを開発チームで決定できます。本コントロールは、この重大度設定をGUIから直感的に変更できるようにするものです。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Code Style」タブを選択 → コードスタイル設定ビュー内の各行の「Severity」列に本コントロールが表示されます。

**主要な操作・処理内容**：
1. コンボボックスに重大度オプション（Refactoring Only, Suggestion, Warning, Error）が表示される
2. ユーザーがドロップダウンから重大度を選択する
3. 選択変更時に`SelectionChanged`イベントが発火し、ViewModelに通知される
4. ViewModelがReportDiagnostic列挙型に変換してCodeStyleSettingを更新する
5. EditorConfigファイルに変更が反映される

**画面遷移**：本コントロールはコードスタイル設定ビュー（No.40）のテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：特に権限による制御はありません。EditorConfigファイルが読み取り専用の場合、設定変更は反映されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | コードスタイル違反の重大度設定（None/Suggestion/Warning/Error） |

## 画面種別

編集コントロール（テーブルセル内ドロップダウン）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Severities | 入力 | string[] | 必須 | 選択可能な重大度の配列（バインディング経由） |
| SelectedSeverityValue | 入出力 | string | 必須 | 現在選択されている重大度（双方向バインディング） |
| ToolTip | 入力 | string | 任意 | ツールチップに表示するテキスト |
| AutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SeverityComboBox | ComboBox | 重大度を選択するドロップダウン |

### 重大度選択肢

| 表示名 | 内部値（ReportDiagnostic） | 説明 |
|--------|---------------------------|------|
| Refactoring Only | Hidden | リファクタリング時のみ表示（エディタに表示なし） |
| Suggestion | Info | 提案として表示（緑の波線） |
| Warning | Warn | 警告として表示（黄色の波線） |
| Error | Error | エラーとして表示（赤の波線、ビルドエラー） |

**注意**：コードスタイル設定では「Disabled」（ReportDiagnostic.Suppress）はサポートされていません。スタイルを無効にするには、値の設定で無効化するオプションを選択します。

## イベント仕様

### 1-SelectionChanged（重大度選択変更）

ユーザーがコンボボックスで異なる重大度を選択した際に発火します。

**処理フロー**：
1. ComboBoxのSelectionChangedイベントが発火
2. SeverityComboBox_SelectionChangedイベントハンドラが呼び出される
3. _viewModel.SelectionChanged(SeverityComboBox.SelectedIndex)が実行される
4. ViewModelが選択インデックスをReportDiagnostic列挙型に変換
5. CodeStyleSettingのChangeSeverityメソッドが呼び出される
6. EditorConfigファイルに変更が書き込まれる

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 重大度選択変更 | .editorconfig | UPDATE | 選択した重大度をEditorConfigファイルに書き込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Severity" | マウスホバー時（ServicesVSResources.Severity） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| 不正なインデックス選択 | InvalidOperationExceptionがスローされる |

## 備考

- 本コントロールはVisual StudioのThemedDialogスタイルを使用し、Visual Studioテーマに自動的に適応します
- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- CodeStyleSeverityViewModelを通じてCodeStyleSettingにアクセスします
- コードスタイル重大度では「Disabled」オプションが意図的に除外されています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、重大度（Severity）の列挙型とコードスタイル設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReportDiagnostic.cs | `src/Compilers/Core/Portable/Diagnostic/ReportDiagnostic.cs` | 診断報告の重大度を定義する列挙型 |
| 1-2 | CodeStyleSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/CodeStyleSetting.cs` | コードスタイル設定を保持するデータクラス。GetSeverity()とChangeSeverity()メソッドに注目 |

**読解のコツ**: ReportDiagnostic列挙型はRoslynコンパイラ全体で使用される診断重大度の基本型です。Suppress, Hidden, Info, Warn, Errorの5レベルがありますが、コードスタイル設定ではSuppressが除外されています。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeStyleSeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSeverityControl.xaml` | XAMLによるUI定義。ComboBoxのバインディング設定を確認 |
| 2-2 | CodeStyleSeverityControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSeverityControl.xaml.cs` | コードビハインド。SelectionChangedイベントハンドラの実装 |

**主要処理フロー**:
1. **行11-16**: ComboBoxの定義とバインディング設定（Severities, SelectedSeverityValue, ToolTip, AutomationProperties.Name）
2. **行16**: SelectionChangedイベントのハンドラ指定
3. **行24-25（.cs）**: イベントハンドラでViewModelのSelectionChangedメソッドを呼び出し

#### Step 3: ViewModelを理解する

ViewModelが重大度の変換とモデルへの橋渡しを担います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeStyleSeverityViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/ViewModel/CodeStyleSeverityViewModel.cs` | ViewModelクラス。Severitiesプロパティ、SelectionChangedメソッドの実装 |

**主要処理フロー**:
- **行18-24**: s_severities配列 - 4つの重大度オプション（Disabled除外）
- **行46-58**: コンストラクタ - 現在の重大度からインデックスへの変換
- **行60-75**: SelectionChangedメソッド - インデックスからReportDiagnosticへの変換とCodeStyleSetting.ChangeSeverity呼び出し

### プログラム呼び出し階層図

```
CodeStyleSeverityControl (View)
    │
    ├─ SeverityComboBox_SelectionChanged (イベントハンドラ)
    │      │
    │      └─ CodeStyleSeverityViewModel.SelectionChanged(int)
    │             │
    │             ├─ インデックス → ReportDiagnostic 変換
    │             │     0 → Hidden
    │             │     1 → Info
    │             │     2 → Warn
    │             │     3 → Error
    │             │
    │             └─ CodeStyleSetting.ChangeSeverity(ReportDiagnostic)
    │                    │
    │                    └─ EditorConfigファイルへの書き込み
    │
    └─ DataBinding
           ├─ Severities (s_severities: 固定配列)
           │      ├─ "Refactoring Only"
           │      ├─ "Suggestion"
           │      ├─ "Warning"
           │      └─ "Error"
           │
           └─ SelectedSeverityValue
                  └─ 現在の重大度に対応する文字列
```

### データフロー図

```
[入力]                      [処理]                               [出力]

ユーザー選択 ───────▶ CodeStyleSeverityControl ─────▶ 重大度表示更新
                            │
                            ▼
                   CodeStyleSeverityViewModel
                            │
                            ├─ インデックス変換
                            ▼
              ReportDiagnostic (Hidden/Info/Warn/Error)
                            │
                            ▼
                      CodeStyleSetting
                            │
                            ▼
                    .editorconfigファイル ──────▶ ファイル保存
                                                      │
                                                      ▼
                                            IDE診断エンジン反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeStyleSeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSeverityControl.xaml` | ビュー | ComboBoxを含むUI定義 |
| CodeStyleSeverityControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSeverityControl.xaml.cs` | コードビハインド | イベントハンドラ実装 |
| CodeStyleSeverityViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/ViewModel/CodeStyleSeverityViewModel.cs` | ViewModel | ビューとモデルの仲介、重大度変換 |
| CodeStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml` | 親ビュー | 本コントロールを含むテーブルビュー |
| ColumnDefinitions.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/ColumnDefinitions.cs` | 定数定義 | テーブル列定義（Severity列） |
| WorkspacesResources.resx | `src/Workspaces/Core/Portable/WorkspacesResources.resx` | リソース | 重大度表示名のローカライズ文字列 |
