# 画面設計書 43-命名スタイル設定ビュー

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における命名スタイル設定ビュー（NamingStyleSettingsView）の画面設計を記述したものです。このビューはEditorConfig設定エディタの命名スタイルタブのメインコンテンツとして、命名規則の一覧をテーブル形式で表示します。

### 本画面の処理概要

**業務上の目的・背景**：.NETプロジェクトにおいて、変数名、メソッド名、クラス名などの命名規則を統一することは、コードの可読性と保守性を大幅に向上させます。本ビューは、EditorConfigファイルで定義された命名スタイルルールを視覚的に一覧表示し、各ルールのタイプ、スタイル、重大度、ソース場所を確認・編集できるようにします。これにより、チーム全体で一貫した命名規則を適用することが容易になります。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Naming Style」タブを選択すると本ビューが表示されます。

**主要な操作・処理内容**：
1. 命名スタイル設定の一覧がテーブル形式で表示される
2. 各行には対象シンボルタイプ、適用されるスタイル、違反時の重大度、設定場所が表示される
3. スタイル列と重大度列はドロップダウンで編集可能
4. 設定変更はリアルタイムでEditorConfigファイルに反映される
5. ビューを閉じる際にViewModelのShutDownメソッドが呼び出される

**画面遷移**：EditorConfig設定エディタ（No.37）のタブコンテンツとして表示されます。他のタブ（空白設定、コードスタイル、アナライザー）への切り替えが可能です。

**権限による表示制御**：特に権限による制御はありません。EditorConfigファイルが読み取り専用の場合、設定変更は反映されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 主機能 | 命名スタイル設定の一覧表示 |

## 画面種別

一覧表示（テーブルビュー）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| TableControl | 出力 | IWpfTableControl | 必須 | Visual Studioテーブルコントロール |
| SettingControl | 出力 | UserControl | 必須 | 自身のUserControlインスタンス |

## 表示項目

### テーブル列構成

| 列名 | 列ID | 編集可否 | 説明 |
|------|------|---------|------|
| Type | editorconfig.namingstyle.type | 読み取り専用 | 対象シンボルタイプ（例：public field, private method） |
| Style | editorconfig.namingstyle.style | 編集可能 | 適用される命名スタイル（例：camelCase, PascalCase） |
| Severity | editorconfig.namingstyle.severityname | 編集可能 | 違反時の重大度 |
| Location | editorconfig.namingstyle.location | 読み取り専用 | 設定のソース場所（EditorConfigパス） |

### 子コントロール

| No | コントロール名 | 説明 |
|----|--------------|------|
| 44 | 命名スタイルタイプコントロール | Type列のセル表示 |
| 45 | 命名スタイルスタイルコントロール | Style列のセル表示・編集 |
| 46 | 命名スタイル重大度コントロール | Severity列のセル表示・編集 |
| 47 | 命名スタイル場所コントロール | Location列のセル表示 |

## イベント仕様

### 1-UpdateEditorConfigAsync（EditorConfig更新）

設定変更がEditorConfigファイルに反映される際に呼び出されます。

**処理フロー**：
1. 設定値の変更がViewModelに通知される
2. ViewModelがUpdateEditorConfigAsyncを呼び出す
3. SourceTextが更新される
4. 更新されたSourceTextが返却される

### 2-OnClose（ビュー終了）

ビューが閉じられる際に呼び出されます。

**処理フロー**：
1. OnCloseメソッドが呼び出される
2. _viewModel.ShutDown()が実行される
3. ViewModelがリソースを解放する

## データベース更新仕様

### 操作別データベース影響一覧

本ビューはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スタイル変更 | .editorconfig | UPDATE | 選択したスタイルをEditorConfigファイルに書き込み |
| 重大度変更 | .editorconfig | UPDATE | 選択した重大度をEditorConfigファイルに書き込み |

## メッセージ仕様

本ビュー自体にはメッセージ表示はありません。子コントロールのツールチップで情報を表示します。

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| ViewModelの初期化失敗 | テーブルが空の状態で表示される |

## 備考

- 本ビューはVisual StudioのThemedDialogスタイルを使用し、Visual Studioテーマに自動的に適応します
- ISettingsEditorViewインターフェースを実装しており、EditorConfig設定エディタのフレームワークに統合されています
- IWpfTableControlを使用してVisual Studioのテーブル表示機能を活用しています
- ContentPresenterを使用してTableControlをホストしています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、命名スタイル設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NamingStyleSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/NamingStyleSetting.cs` | 命名スタイル設定を保持するデータクラス。TypeName, StyleName, Severity, Location プロパティに注目 |

**読解のコツ**: NamingStyleSettingクラスは命名スタイルの個々のルールを表現します。ChangeStyle()とChangeSeverity()メソッドで設定変更が行われます。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NamingStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml` | XAMLによるUI定義。ContentPresenterでテーブルをホスト |
| 2-2 | NamingStyleSettingsView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml.cs` | コードビハインド。ISettingsEditorViewの実装 |

**主要処理フロー**:
1. **行10-14**: ContentPresenter（NamingStyleTable）の定義
2. **行19-26（.cs）**: コンストラクタでTableControlを取得しContentPresenterに設定
3. **行30（.cs）**: UpdateEditorConfigAsyncメソッド - EditorConfig更新
4. **行31（.cs）**: OnCloseメソッド - リソース解放

#### Step 3: ViewModelを理解する

ViewModelがデータソースとテーブル表示を橋渡しします。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NamingStyleSettingsViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/NamingStyleSettingsViewModel.cs` | ViewModelクラス。列定義とデータプロバイダの設定 |

**主要処理フロー**:
- **行26**: Identifier プロパティ - "NamingStyleSettings"
- **行31-38**: GetInitialColumnStates - 4列の初期状態定義
- **行40-46**: GetFixedColumns - 固定列の定義

#### Step 4: 列定義を理解する

各列のコントロールと表示ロジックを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ColumnDefinitions.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/ColumnDefinitions.cs` | 列ID定義 |
| 4-2 | NamingStylesTypeColumnDefinition.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnDefinitions/NamingStylesTypeColumnDefinition.cs` | Type列定義 |
| 4-3 | NamingStylesStyleColumnDefinition.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnDefinitions/NamingStylesStyleColumnDefinition.cs` | Style列定義 |

### プログラム呼び出し階層図

```
NamingStyleSettingsView (View / ISettingsEditorView)
    │
    ├─ コンストラクタ
    │      │
    │      ├─ IWpfSettingsEditorViewModel.GetTableControl()
    │      │      │
    │      │      └─ IWpfTableControl (Visual Studioテーブル)
    │      │
    │      └─ NamingStyleTable.Content = TableControl.Control
    │
    ├─ UpdateEditorConfigAsync(SourceText)
    │      │
    │      └─ _viewModel.UpdateEditorConfigAsync(sourceText)
    │             │
    │             └─ EditorConfigファイルへの書き込み
    │
    └─ OnClose()
           │
           └─ _viewModel.ShutDown()
                  │
                  └─ リソース解放
```

### データフロー図

```
[入力]                          [処理]                           [出力]

EditorConfigファイル ──────▶ ISettingsProvider<NamingStyleSetting>
                                    │
                                    ▼
                         NamingStyleSettingsViewModel
                                    │
                                    ├─ SettingsSnapshotFactory
                                    ├─ SettingsEntriesSnapshot
                                    │
                                    ▼
                            IWpfTableControl ─────────▶ テーブル表示
                                    │
                                    ▼
                           列コントロール
                                    │
                         ┌──────────┼──────────┐──────────┐
                         ▼          ▼          ▼          ▼
                      Type列    Style列    Severity列  Location列
                    (No.44)    (No.45)     (No.46)     (No.47)

ユーザー編集 ─────────────────────────────────────────▶ 設定変更
                                                          │
                                                          ▼
                                                .editorconfigファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NamingStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml` | ビュー | メインビュー定義 |
| NamingStyleSettingsView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml.cs` | コードビハインド | ISettingsEditorView実装 |
| NamingStyleSettingsViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/NamingStyleSettingsViewModel.cs` | ViewModel | テーブルデータ管理 |
| NamingStyleSettingsViewModel.SettingsSnapshotFactory.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/NamingStyleSettingsViewModel.SettingsSnapshotFactory.cs` | ファクトリ | スナップショット生成 |
| NamingStyleSettingsViewModel.SettingsEntriesSnapshot.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/NamingStyleSettingsViewModel.SettingsEntriesSnapshot.cs` | スナップショット | テーブルデータスナップショット |
| ISettingsEditorView.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/ISettingsEditorView.cs` | インターフェース | 設定エディタビューの契約 |
| ColumnDefinitions.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/ColumnDefinitions.cs` | 定数定義 | テーブル列ID定義 |
