# 画面設計書 44-命名スタイルタイプコントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における命名スタイルタイプコントロール（NamingStylesTypeControl）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタの命名スタイルタブにおいて、各命名規則が適用されるシンボルタイプを表示するための読み取り専用ラベルコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：命名規則は特定のシンボルタイプ（パブリックフィールド、プライベートメソッド、インターフェースなど）に対して適用されます。本コントロールは、各命名規則がどのシンボルタイプに適用されるかを明確に表示し、開発者が命名規則の適用範囲を把握できるようにします。これにより、適切な命名規則が適切なシンボルに適用されているかを確認できます。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Naming Style」タブを選択 → 命名スタイル設定ビュー内の各行の「Type」列に本コントロールが表示されます。

**主要な操作・処理内容**：
1. NamingStyleSettingからシンボルタイプ名を取得
2. Labelコントロールに表示
3. 設定変更イベントを購読し、変更があれば表示を更新
4. ツールチップとアクセシビリティ名を提供

**画面遷移**：本コントロールは命名スタイル設定ビュー（No.43）のテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：特に権限による制御はありません。本コントロールは読み取り専用です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | 命名スタイルのシンボル種類表示 |

## 画面種別

表示コントロール（テーブルセル内ラベル、読み取り専用）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| TypeValue | 入力 | string | 必須 | 表示するシンボルタイプ名（バインディング経由） |
| TypeToolTip | 入力 | string | 必須 | ツールチップに表示するテキスト |
| TypeAutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| NamingStyleTypeLabel | Label | シンボルタイプ名を表示するラベル |

### 表示されるシンボルタイプ例

| シンボルタイプ | 説明 |
|--------------|------|
| public field | パブリックフィールド |
| private field | プライベートフィールド |
| public method | パブリックメソッド |
| private method | プライベートメソッド |
| interface | インターフェース |
| class | クラス |
| namespace | 名前空間 |
| property | プロパティ |
| constant | 定数 |
| parameter | パラメータ |
| local variable | ローカル変数 |

## イベント仕様

### 1-SettingChanged（設定変更通知）

NamingStyleSettingが変更された際にViewModelが通知を受け取ります。

**処理フロー**：
1. NamingStyleSetting.SettingChangedイベントが発火
2. NamingStylesTypeViewModel.OnSettingChangedが呼び出される
3. TypeValueプロパティが更新される
4. PropertyChangedイベントでUIに変更が通知される
5. Labelの表示が更新される

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールは読み取り専用のため、データの更新は行いません。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 更新処理なし（読み取り専用） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Type" | マウスホバー時（ServicesVSResources.Type） |

## 例外処理

本コントロールは読み取り専用のため、例外処理は最小限です。

| 例外条件 | 処理内容 |
|---------|---------|
| ViewModelがnull | コントロールは空の状態で表示される |
| TypeValueがnull | PropertyChangedは発火しない（nullチェックあり） |

## 備考

- 本コントロールは読み取り専用であり、ユーザーによる編集はできません
- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- NamingStylesTypeViewModelを通じてNamingStyleSettingにアクセスします
- NotifyPropertyChangedBaseを継承しており、INotifyPropertyChangedを実装しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、命名スタイル設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NamingStyleSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/NamingStyleSetting.cs` | 命名スタイル設定を保持するデータクラス。TypeNameプロパティとSettingChangedイベントに注目 |

**読解のコツ**: NamingStyleSettingクラスはTypeNameプロパティでシンボルタイプ名を提供し、設定変更時にSettingChangedイベントを発火します。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NamingStylesTypeControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesTypeControl.xaml` | XAMLによるUI定義。Labelのバインディング設定を確認 |
| 2-2 | NamingStylesTypeControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesTypeControl.xaml.cs` | コードビハインド。シンプルなコンストラクタのみ |

**主要処理フロー**:
1. **行10-15（XAML）**: Grid内にLabelを配置
2. **行11-14（XAML）**: Content, ToolTip, AutomationProperties.Nameのバインディング
3. **行15-19（.cs）**: コンストラクタでDataContextを設定

#### Step 3: ViewModelを理解する

ViewModelがデータモデルとビューを橋渡しします。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NamingStylesTypeViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesTypeViewModel.cs` | ViewModelクラス。TypeValueプロパティとイベントハンドラの実装 |
| 3-2 | NotifyPropertyChangedBase.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NotifyPropertyChangedBase.cs` | INotifyPropertyChanged実装の基底クラス |

**主要処理フロー**:
- **行15-20**: コンストラクタ - 設定からTypeNameを取得し、SettingChangedイベントを購読
- **行22-33**: TypeValueプロパティ - 値の取得・設定とPropertyChanged通知
- **行35-36**: TypeToolTip/TypeAutomationName - 静的プロパティ（"Type"を返す）
- **行38-39**: OnSettingChanged - 設定変更時にTypeValueを更新

### プログラム呼び出し階層図

```
NamingStylesTypeControl (View)
    │
    ├─ コンストラクタ
    │      │
    │      └─ DataContext = NamingStylesTypeViewModel
    │
    └─ DataBinding
           │
           ├─ Content ← TypeValue
           │      │
           │      └─ NamingStyleSetting.TypeName
           │
           ├─ ToolTip ← TypeToolTip ("Type")
           │
           └─ AutomationProperties.Name ← TypeAutomationName ("Type")

NamingStyleSetting
    │
    └─ SettingChanged イベント
           │
           └─ NamingStylesTypeViewModel.OnSettingChanged
                  │
                  └─ TypeValue 更新 → PropertyChanged → UI更新
```

### データフロー図

```
[入力]                          [処理]                           [出力]

NamingStyleSetting ────────▶ NamingStylesTypeViewModel ────────▶ Label表示
     │                              │
     │ TypeName                     │ TypeValue
     │                              │
     └─ SettingChanged ────────────▶│ OnSettingChanged
                                    │
                                    └─ PropertyChanged ────────▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NamingStylesTypeControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesTypeControl.xaml` | ビュー | Labelを含むUI定義 |
| NamingStylesTypeControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesTypeControl.xaml.cs` | コードビハインド | 初期化処理 |
| NamingStylesTypeViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesTypeViewModel.cs` | ViewModel | TypeValue管理 |
| NotifyPropertyChangedBase.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NotifyPropertyChangedBase.cs` | 基底クラス | INotifyPropertyChanged実装 |
| NamingStylesTypeColumnDefinition.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnDefinitions/NamingStylesTypeColumnDefinition.cs` | 列定義 | テーブル列の定義 |
| NamingStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml` | 親ビュー | 本コントロールを含むテーブルビュー |
