# 画面設計書 45-命名スタイルスタイルコントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における命名スタイルスタイルコントロール（NamingStylesStyleControl）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタの命名スタイルタブにおいて、各命名規則に適用されるスタイル（命名パターン）を選択するためのドロップダウンコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：命名規則においては、シンボルタイプごとにどのような命名パターン（camelCase、PascalCase、UPPER_CASE、プレフィックス付きなど）を適用するかを設定する必要があります。本コントロールは、利用可能なすべての命名スタイルをドロップダウンで表示し、ユーザーが視覚的にスタイルを変更できるようにします。これにより、チーム全体で統一された命名パターンを適用することが容易になります。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Naming Style」タブを選択 → 命名スタイル設定ビュー内の各行の「Style」列に本コントロールが表示されます。

**主要な操作・処理内容**：
1. NamingStyleSettingから利用可能な全スタイルと現在のスタイルを取得
2. ComboBoxに選択肢を表示
3. ユーザーがドロップダウンからスタイルを選択
4. 選択変更時にViewModelを通じてNamingStyleSettingを更新
5. 設定変更がEditorConfigファイルに反映される

**画面遷移**：本コントロールは命名スタイル設定ビュー（No.43）のテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：特に権限による制御はありません。EditorConfigファイルが読み取り専用の場合、設定変更は反映されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | 命名スタイルのスタイル名表示 |

## 画面種別

編集コントロール（テーブルセル内ドロップダウン）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| StyleValues | 入力 | string[] | 必須 | 選択可能なスタイル名の配列（バインディング経由） |
| SelectedStyleValue | 入出力 | string | 必須 | 現在選択されているスタイル名（双方向バインディング） |
| StyleToolTip | 入力 | string | 必須 | ツールチップに表示するテキスト |
| StyleAutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| StyleComboBox | ComboBox | 命名スタイルを選択するドロップダウン |

### 代表的なスタイル選択肢

| スタイル名 | 説明 |
|-----------|------|
| camelCase | 先頭小文字、以降大文字区切り（例：myVariableName） |
| PascalCase | 先頭大文字、以降大文字区切り（例：MyClassName） |
| UPPER_CASE | 全大文字、アンダースコア区切り（例：MY_CONSTANT） |
| _camelCase | アンダースコアプレフィックス + camelCase（例：_privateField） |
| IPascalCase | Iプレフィックス + PascalCase（例：IMyInterface） |

## イベント仕様

### 1-SelectionChanged（スタイル選択変更）

ユーザーがコンボボックスで異なるスタイルを選択した際に発火します。

**処理フロー**：
1. ComboBoxのSelectionChangedイベントが発火
2. StyleComboBox_SelectionChangedイベントハンドラが呼び出される
3. _viewModel.SelectionChanged(StyleComboBox.SelectedIndex)が実行される
4. NamingStyleSettingのChangeStyleメソッドが呼び出される
5. 設定変更イベントが発火し、関連するUIが更新される
6. EditorConfigファイルに変更が書き込まれる

### 2-SettingChanged（設定変更通知）

NamingStyleSettingが変更された際にViewModelが通知を受け取ります。

**処理フロー**：
1. NamingStyleSetting.SettingChangedイベントが発火
2. NamingStylesStyleViewModel.OnSettingChangedが呼び出される
3. StyleValuesとSelectedStyleValueプロパティが更新される
4. PropertyChangedイベントでUIに変更が通知される
5. ComboBoxの選択肢と選択値が更新される

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スタイル選択変更 | .editorconfig | UPDATE | 選択したスタイルをEditorConfigファイルに書き込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Naming Style" | マウスホバー時（ServicesVSResources.Naming_Style） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| 不正なインデックス選択 | 配列境界チェックが行われる |

## 備考

- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- NamingStylesStyleViewModelを通じてNamingStyleSettingにアクセスします
- NotifyPropertyChangedBaseを継承しており、INotifyPropertyChangedを実装しています
- スタイル一覧は動的に取得されるため、プロジェクトで定義されたカスタムスタイルも表示されます
- SequenceEqualを使用してStyleValues配列の変更を検出しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、命名スタイル設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NamingStyleSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/NamingStyleSetting.cs` | 命名スタイル設定を保持するデータクラス。AllStyles、StyleName、ChangeStyle()に注目 |

**読解のコツ**: NamingStyleSettingクラスはAllStylesプロパティで利用可能なすべてのスタイル名を提供し、StyleNameで現在選択中のスタイルを保持します。ChangeStyle(int)メソッドでインデックス指定でスタイルを変更します。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NamingStylesStyleControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesStyleControl.xaml` | XAMLによるUI定義。ComboBoxのバインディング設定を確認 |
| 2-2 | NamingStylesStyleControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesStyleControl.xaml.cs` | コードビハインド。SelectionChangedイベントハンドラの実装 |

**主要処理フロー**:
1. **行10-16（XAML）**: Grid内にComboBoxを配置
2. **行11-16（XAML）**: ItemsSource, SelectedValue, ToolTip, AutomationProperties.Name, SelectionChangedのバインディング
3. **行24-25（.cs）**: イベントハンドラでViewModelのSelectionChangedメソッドを呼び出し

#### Step 3: ViewModelを理解する

ViewModelがデータモデルとビューを橋渡しします。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NamingStylesStyleViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesStyleViewModel.cs` | ViewModelクラス。StyleValues、SelectedStyleValue、SelectionChanged実装 |

**主要処理フロー**:
- **行18-25**: コンストラクタ - 設定からスタイル一覧と現在の選択を取得
- **行31-42**: StyleValuesプロパティ - スタイル一覧の管理（SequenceEqualで変更検出）
- **行44-55**: SelectedStyleValueプロパティ - 選択中スタイルの管理
- **行57-58**: SelectionChangedメソッド - NamingStyleSetting.ChangeStyle呼び出し
- **行60-65**: OnSettingChanged - 設定変更時に表示を更新

### プログラム呼び出し階層図

```
NamingStylesStyleControl (View)
    │
    ├─ StyleComboBox_SelectionChanged (イベントハンドラ)
    │      │
    │      └─ NamingStylesStyleViewModel.SelectionChanged(int)
    │             │
    │             └─ NamingStyleSetting.ChangeStyle(int)
    │                    │
    │                    ├─ SettingChanged イベント発火
    │                    │      │
    │                    │      └─ OnSettingChanged → UI更新
    │                    │
    │                    └─ EditorConfigファイルへの書き込み
    │
    └─ DataBinding
           │
           ├─ ItemsSource ← StyleValues
           │      └─ NamingStyleSetting.AllStyles
           │
           ├─ SelectedValue ← SelectedStyleValue
           │      └─ NamingStyleSetting.StyleName
           │
           ├─ ToolTip ← StyleToolTip ("Naming Style")
           │
           └─ AutomationProperties.Name ← StyleAutomationName
```

### データフロー図

```
[入力]                          [処理]                           [出力]

NamingStyleSetting ────────▶ NamingStylesStyleViewModel ─────▶ ComboBox表示
     │                              │
     │ AllStyles                    │ StyleValues
     │ StyleName                    │ SelectedStyleValue
     │                              │
     └─ SettingChanged ────────────▶│ OnSettingChanged
                                    │
ユーザー選択 ──────────────────────▶│ SelectionChanged
                                    │
                                    └─ ChangeStyle(int) ─────▶ 設定更新
                                                                  │
                                                                  ▼
                                                        .editorconfigファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NamingStylesStyleControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesStyleControl.xaml` | ビュー | ComboBoxを含むUI定義 |
| NamingStylesStyleControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesStyleControl.xaml.cs` | コードビハインド | イベントハンドラ実装 |
| NamingStylesStyleViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesStyleViewModel.cs` | ViewModel | スタイル選択管理 |
| NotifyPropertyChangedBase.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NotifyPropertyChangedBase.cs` | 基底クラス | INotifyPropertyChanged実装 |
| NamingStylesStyleColumnDefinition.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnDefinitions/NamingStylesStyleColumnDefinition.cs` | 列定義 | テーブル列の定義 |
| NamingStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml` | 親ビュー | 本コントロールを含むテーブルビュー |
