# 画面設計書 46-命名スタイル重大度コントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における命名スタイル重大度コントロール（NamingStylesSeverityControl）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタの命名スタイルタブにおいて、各命名規則違反時の重大度（Severity）を選択するためのドロップダウンコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：命名規則は、違反時にどの程度の重要度でレポートするかを設定できます。チームのコーディング規約として厳格に適用する場合はエラー、推奨事項として扱う場合は提案など、プロジェクトの要件に応じて重大度を調整できます。本コントロールは、この重大度設定をGUIから直感的に変更できるようにするものです。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Naming Style」タブを選択 → 命名スタイル設定ビュー内の各行の「Severity」列に本コントロールが表示されます。

**主要な操作・処理内容**：
1. コンボボックスに重大度オプション（Disabled, Refactoring Only, Suggestion, Warning, Error）が表示される
2. ユーザーがドロップダウンから重大度を選択する
3. 選択変更時にViewModelを通じてReportDiagnostic列挙型に変換される
4. NamingStyleSettingのChangeSeverityメソッドが呼び出される
5. EditorConfigファイルに変更が反映される

**画面遷移**：本コントロールは命名スタイル設定ビュー（No.43）のテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：特に権限による制御はありません。EditorConfigファイルが読み取り専用の場合、設定変更は反映されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | 命名スタイル違反の重大度選択 |

## 画面種別

編集コントロール（テーブルセル内ドロップダウン）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Severities | 入力 | ImmutableArray&lt;string&gt; | 必須 | 選択可能な重大度の配列（静的プロパティ） |
| SelectedSeverityValue | 入出力 | string | 必須 | 現在選択されている重大度（双方向バインディング） |
| SeverityToolTip | 入力 | string | 必須 | ツールチップに表示するテキスト |
| SeverityAutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SeverityComboBox | ComboBox | 重大度を選択するドロップダウン |

### 重大度選択肢

| インデックス | 表示名 | 内部値（ReportDiagnostic） | 説明 |
|-------------|--------|---------------------------|------|
| 0 | Disabled | Suppress | 診断を完全に無効化 |
| 1 | Refactoring Only | Hidden | リファクタリング時のみ表示 |
| 2 | Suggestion | Info | 提案として表示（緑の波線） |
| 3 | Warning | Warn | 警告として表示（黄色の波線） |
| 4 | Error | Error | エラーとして表示（赤の波線） |

**注意**：命名スタイル設定では、コードスタイル設定と異なり「Disabled」オプションがサポートされています。

## イベント仕様

### 1-SelectionChanged（重大度選択変更）

ユーザーがコンボボックスで異なる重大度を選択した際に発火します。

**処理フロー**：
1. ComboBoxのSelectionChangedイベントが発火
2. SeverityComboBox_SelectionChangedイベントハンドラが呼び出される
3. _viewModel.SelectionChanged(SeverityComboBox.SelectedIndex)が実行される
4. ViewModelが選択インデックスをReportDiagnostic列挙型に変換
5. NamingStyleSettingのChangeSeverityメソッドが呼び出される
6. EditorConfigファイルに変更が書き込まれる

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 重大度選択変更 | .editorconfig | UPDATE | 選択した重大度をEditorConfigファイルに書き込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Severity" | マウスホバー時（ServicesVSResources.Severity） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| 不正なインデックス選択 | InvalidOperationExceptionがスローされる |

## 備考

- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- NamingStylesSeverityViewModelを通じてNamingStyleSettingにアクセスします
- コードスタイル重大度（No.42）と異なり、「Disabled」オプションが含まれています（5段階）
- ImmutableArrayを使用して重大度オプションを管理しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、重大度（Severity）の列挙型と命名スタイル設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReportDiagnostic.cs | `src/Compilers/Core/Portable/Diagnostic/ReportDiagnostic.cs` | 診断報告の重大度を定義する列挙型 |
| 1-2 | NamingStyleSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/NamingStyleSetting.cs` | 命名スタイル設定を保持するデータクラス。Severity、ChangeSeverity()に注目 |

**読解のコツ**: ReportDiagnostic列挙型は5つのレベル（Suppress, Hidden, Info, Warn, Error）を持ちます。命名スタイルではすべてのレベルがサポートされています。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NamingStylesSeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesSeverityControl.xaml` | XAMLによるUI定義。ComboBoxのバインディング設定を確認 |
| 2-2 | NamingStylesSeverityControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesSeverityControl.xaml.cs` | コードビハインド。SelectionChangedイベントハンドラの実装 |

**主要処理フロー**:
1. **行10-16（XAML）**: Grid内にComboBoxを配置
2. **行11-16（XAML）**: ItemsSource, SelectedValue, ToolTip, AutomationProperties.Name, SelectionChangedのバインディング
3. **行24-25（.cs）**: イベントハンドラでViewModelのSelectionChangedメソッドを呼び出し

#### Step 3: ViewModelを理解する

ViewModelが重大度の変換とモデルへの橋渡しを担います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NamingStylesSeverityViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesSeverityViewModel.cs` | ViewModelクラス。Severitiesプロパティ、SelectionChangedメソッドの実装 |

**主要処理フロー**:
- **行52-59**: Severities配列 - 5つの重大度オプション（ImmutableArray）
- **行16-30**: コンストラクタ - 現在の重大度からインデックスへの変換
- **行32-44**: SelectionChangedメソッド - インデックスからReportDiagnosticへの変換とChangeSeverity呼び出し

### プログラム呼び出し階層図

```
NamingStylesSeverityControl (View)
    │
    ├─ SeverityComboBox_SelectionChanged (イベントハンドラ)
    │      │
    │      └─ NamingStylesSeverityViewModel.SelectionChanged(int)
    │             │
    │             ├─ インデックス → ReportDiagnostic 変換
    │             │     0 → Suppress
    │             │     1 → Hidden
    │             │     2 → Info
    │             │     3 → Warn
    │             │     4 → Error
    │             │
    │             └─ NamingStyleSetting.ChangeSeverity(ReportDiagnostic)
    │                    │
    │                    └─ EditorConfigファイルへの書き込み
    │
    └─ DataBinding
           │
           ├─ ItemsSource ← Severities (静的ImmutableArray)
           │      ├─ "Disabled"
           │      ├─ "Refactoring Only"
           │      ├─ "Suggestion"
           │      ├─ "Warning"
           │      └─ "Error"
           │
           ├─ SelectedValue ← SelectedSeverityValue
           │
           ├─ ToolTip ← SeverityToolTip ("Severity")
           │
           └─ AutomationProperties.Name ← SeverityAutomationName
```

### データフロー図

```
[入力]                          [処理]                               [出力]

NamingStyleSetting ────────▶ NamingStylesSeverityViewModel ─────▶ ComboBox表示
     │                              │
     │ Severity                     │ SelectedSeverityValue
     │ (ReportDiagnostic)           │
     │                              │
ユーザー選択 ──────────────────────▶│ SelectionChanged
                                    │
                                    ├─ インデックス変換
                                    ▼
              ReportDiagnostic (Suppress/Hidden/Info/Warn/Error)
                                    │
                                    ▼
                      NamingStyleSetting.ChangeSeverity
                                    │
                                    ▼
                            .editorconfigファイル ──────▶ ファイル保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NamingStylesSeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesSeverityControl.xaml` | ビュー | ComboBoxを含むUI定義 |
| NamingStylesSeverityControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesSeverityControl.xaml.cs` | コードビハインド | イベントハンドラ実装 |
| NamingStylesSeverityViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesSeverityViewModel.cs` | ViewModel | 重大度選択管理 |
| NamingStylesSeverityColumnDefinition.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnDefinitions/NamingStylesSeverityColumnDefinition.cs` | 列定義 | テーブル列の定義 |
| NamingStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml` | 親ビュー | 本コントロールを含むテーブルビュー |
| WorkspacesResources.resx | `src/Workspaces/Core/Portable/WorkspacesResources.resx` | リソース | 重大度表示名のローカライズ文字列 |
