# 画面設計書 47-命名スタイル場所コントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における命名スタイル場所コントロール（NamingStylesLocationControl）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタの命名スタイルタブにおいて、各命名規則の設定ソース場所（EditorConfigファイルのパスまたはVisual Studio設定）を表示するための読み取り専用ラベルコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：EditorConfigファイルは階層的に適用されるため、どのファイルから設定が読み込まれているかを知ることは重要です。本コントロールは、各命名規則がどのEditorConfigファイルから来ているか、またはVisual Studioのデフォルト設定から来ているかを明確に表示します。これにより、開発者は設定の出所を把握し、適切なファイルを編集することができます。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Naming Style」タブを選択 → 命名スタイル設定ビュー内の各行の「Location」列に本コントロールが表示されます。

**主要な操作・処理内容**：
1. NamingStyleSettingからLocationプロパティを取得
2. LocationKindに応じて表示文字列を決定（EditorConfigパスまたは"Visual Studio Settings"）
3. Labelコントロールに表示
4. 設定変更イベントを購読し、変更があれば表示を更新
5. ツールチップとアクセシビリティ名を提供

**画面遷移**：本コントロールは命名スタイル設定ビュー（No.43）のテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：特に権限による制御はありません。本コントロールは読み取り専用です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | 命名スタイルのソース場所（EditorConfigパス）表示 |

## 画面種別

表示コントロール（テーブルセル内ラベル、読み取り専用）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| LocationValue | 入力 | string | 必須 | 表示する場所情報（バインディング経由） |
| LocationToolTip | 入力 | string | 必須 | ツールチップに表示するテキスト |
| LocationAutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| NamingStyleLocationLabel | Label | 設定の場所情報を表示するラベル |

### 表示される場所情報の種類

| LocationKind | 表示内容 | 説明 |
|-------------|---------|------|
| EditorConfig | EditorConfigファイルの完全パス | 例：`C:\Project\.editorconfig` |
| GlobalConfig | GlobalConfigファイルの完全パス | 例：`C:\Users\.globalconfig` |
| その他 | "Visual Studio Settings" | Visual Studioのデフォルト設定から来ている場合 |

## イベント仕様

### 1-SettingChanged（設定変更通知）

NamingStyleSettingが変更された際にViewModelが通知を受け取ります。

**処理フロー**：
1. NamingStyleSetting.SettingChangedイベントが発火
2. NamingStylesLocationViewModel.OnSettingChangedが呼び出される
3. LocationValueプロパティが更新される（GetLocationStringメソッドで変換）
4. PropertyChangedイベントでUIに変更が通知される
5. Labelの表示が更新される

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールは読み取り専用のため、データの更新は行いません。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 更新処理なし（読み取り専用） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Location" | マウスホバー時（ServicesVSResources.Location） |
| - | 表示文字列 | "Visual Studio Settings" | 設定がVisual Studioから来ている場合 |

## 例外処理

本コントロールは読み取り専用のため、例外処理は最小限です。

| 例外条件 | 処理内容 |
|---------|---------|
| ViewModelがnull | コントロールは空の状態で表示される |
| LocationValueがnull | PropertyChangedは発火しない（nullチェックあり） |
| Location?.Pathがnull | "Visual Studio Settings"が表示される |

## 備考

- 本コントロールは読み取り専用であり、ユーザーによる編集はできません
- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- NamingStylesLocationViewModelを通じてNamingStyleSettingにアクセスします
- NotifyPropertyChangedBaseを継承しており、INotifyPropertyChangedを実装しています
- GetLocationStringメソッドでLocationKindからユーザーフレンドリーな文字列に変換しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、設定場所（SettingLocation）のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SettingLocation.cs | `src/EditorFeatures/Core/EditorConfigSettings/SettingLocation.cs` | 設定の場所情報を保持するクラス。LocationKind、Pathプロパティに注目 |
| 1-2 | LocationKind.cs | `src/EditorFeatures/Core/EditorConfigSettings/LocationKind.cs` | 場所の種類を定義する列挙型（EditorConfig、GlobalConfig等） |

**読解のコツ**: SettingLocationクラスはLocationKindとPathを保持し、設定がどこから来ているかを表現します。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NamingStylesLocationControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesLocationControl.xaml` | XAMLによるUI定義。Labelのバインディング設定を確認 |
| 2-2 | NamingStylesLocationControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesLocationControl.xaml.cs` | コードビハインド。シンプルなコンストラクタのみ |

**主要処理フロー**:
1. **行10-15（XAML）**: Grid内にLabelを配置
2. **行11-14（XAML）**: Content, ToolTip, AutomationProperties.Nameのバインディング
3. **行15-19（.cs）**: コンストラクタでDataContextを設定

#### Step 3: ViewModelを理解する

ViewModelがデータモデルとビューを橋渡しし、場所情報を変換します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NamingStylesLocationViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesLocationViewModel.cs` | ViewModelクラス。LocationValue、GetLocationString実装 |

**主要処理フロー**:
- **行16-21**: コンストラクタ - 設定からLocationを取得し、GetLocationStringで変換
- **行23-34**: LocationValueプロパティ - 場所情報の管理とPropertyChanged通知
- **行36-37**: LocationToolTip/LocationAutomationName - 静的プロパティ（"Location"を返す）
- **行39-40**: OnSettingChanged - 設定変更時にLocationValueを更新
- **行42-47**: GetLocationString - LocationKindに応じた文字列変換（EditorConfig/GlobalConfig→パス、その他→"Visual Studio Settings"）

### プログラム呼び出し階層図

```
NamingStylesLocationControl (View)
    │
    ├─ コンストラクタ
    │      │
    │      └─ DataContext = NamingStylesLocationViewModel
    │
    └─ DataBinding
           │
           ├─ Content ← LocationValue
           │      │
           │      └─ GetLocationString(NamingStyleSetting.Location)
           │             │
           │             ├─ LocationKind.EditorConfig → location.Path
           │             ├─ LocationKind.GlobalConfig → location.Path
           │             └─ その他 → "Visual Studio Settings"
           │
           ├─ ToolTip ← LocationToolTip ("Location")
           │
           └─ AutomationProperties.Name ← LocationAutomationName ("Location")

NamingStyleSetting
    │
    └─ SettingChanged イベント
           │
           └─ NamingStylesLocationViewModel.OnSettingChanged
                  │
                  └─ LocationValue 更新 → PropertyChanged → UI更新
```

### データフロー図

```
[入力]                          [処理]                           [出力]

NamingStyleSetting ────────▶ NamingStylesLocationViewModel ─────▶ Label表示
     │                              │
     │ Location                     │ GetLocationString
     │   ├─ LocationKind            │   │
     │   └─ Path                    │   ├─ EditorConfig/GlobalConfig → パス
     │                              │   └─ その他 → "Visual Studio Settings"
     │                              │
     └─ SettingChanged ────────────▶│ OnSettingChanged
                                    │
                                    └─ PropertyChanged ────────▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NamingStylesLocationControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesLocationControl.xaml` | ビュー | Labelを含むUI定義 |
| NamingStylesLocationControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesLocationControl.xaml.cs` | コードビハインド | 初期化処理 |
| NamingStylesLocationViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesLocationViewModel.cs` | ViewModel | LocationValue管理、文字列変換 |
| NotifyPropertyChangedBase.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NotifyPropertyChangedBase.cs` | 基底クラス | INotifyPropertyChanged実装 |
| NamingStylesLocationColumnDefinition.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnDefinitions/NamingStylesLocationColumnDefinition.cs` | 列定義 | テーブル列の定義 |
| NamingStyleSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml` | 親ビュー | 本コントロールを含むテーブルビュー |
| SettingLocation.cs | `src/EditorFeatures/Core/EditorConfigSettings/SettingLocation.cs` | データモデル | 設定場所情報 |
