# 画面設計書 48-アナライザー設定ビュー

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能におけるアナライザー設定ビュー（AnalyzerSettingsView）の画面設計を記述したものです。このビューはEditorConfig設定エディタのアナライザータブのメインコンテンツとして、プロジェクトに適用されるアナライザールールの一覧をテーブル形式で表示します。

### 本画面の処理概要

**業務上の目的・背景**：Roslynアナライザーは、コードの静的解析を行い、潜在的な問題や改善点を診断します。各アナライザールールには重大度（Severity）が設定でき、プロジェクトの要件に応じて調整できます。本ビューは、EditorConfigファイルで管理可能なすべてのアナライザールールを一覧表示し、各ルールのID、タイトル、カテゴリ、重大度、場所を確認・編集できるようにします。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Analyzers」タブを選択すると本ビューが表示されます。

**主要な操作・処理内容**：
1. アナライザー設定の一覧がテーブル形式で表示される
2. 各行にはルールID、タイトル、説明（非表示）、カテゴリ、重大度、場所が表示される
3. カテゴリ列でグループ化されて表示される
4. 重大度列はドロップダウンで編集可能（設定可能なルールのみ）
5. 設定変更はリアルタイムでEditorConfigファイルに反映される
6. ビューを閉じる際にViewModelのShutDownメソッドが呼び出される

**画面遷移**：EditorConfig設定エディタ（No.37）のタブコンテンツとして表示されます。他のタブ（空白設定、コードスタイル、命名スタイル）への切り替えが可能です。

**権限による表示制御**：特に権限による制御はありません。EditorConfigファイルが読み取り専用の場合、設定変更は反映されません。一部のルールは設定変更不可（IsNotConfigurable）としてマークされています。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 66 | 診断エンジン | 主機能 | アナライザー設定の一覧表示 |
| 112 | Roslynアナライザー | 補助機能 | Roslynアナライザールールの設定 |

## 画面種別

一覧表示（テーブルビュー、グループ化対応）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| TableControl | 出力 | IWpfTableControl | 必須 | Visual Studioテーブルコントロール |
| SettingControl | 出力 | UserControl | 必須 | 自身のUserControlインスタンス |

## 表示項目

### テーブル列構成

| 列名 | 列ID | 表示 | グループ化 | 編集可否 | 説明 |
|------|------|------|-----------|---------|------|
| ID | editorconfig.analyzer.idname | 表示 | なし | 読み取り専用 | ルールID（例：CA1000） |
| Title | editorconfig.analyzer.titlename | 表示 | なし | 読み取り専用 | ルールタイトル |
| Description | editorconfig.analyzer.descriptionname | 非表示 | なし | 読み取り専用 | ルールの詳細説明 |
| Category | editorconfig.analyzer.categoryname | 表示 | 優先度1 | 読み取り専用 | カテゴリ名（例：Design, Performance） |
| Severity | editorconfig.analyzer.severityname | 表示 | なし | 編集可能 | 診断の重大度 |
| Location | editorconfig.analyzer.location | 表示 | なし | 読み取り専用 | 設定のソース場所 |

### 子コントロール

| No | コントロール名 | 説明 |
|----|--------------|------|
| 49 | 重大度コントロール | Severity列のセル表示・編集 |

## イベント仕様

### 1-UpdateEditorConfigAsync（EditorConfig更新）

設定変更がEditorConfigファイルに反映される際に呼び出されます。

**処理フロー**：
1. 重大度の変更がViewModelに通知される
2. ViewModelがUpdateEditorConfigAsyncを呼び出す
3. SourceTextが更新される
4. 更新されたSourceTextが返却される

### 2-OnClose（ビュー終了）

ビューが閉じられる際に呼び出されます。

**処理フロー**：
1. OnCloseメソッドが呼び出される
2. _viewModel.ShutDown()が実行される
3. ViewModelがリソースを解放する

## データベース更新仕様

### 操作別データベース影響一覧

本ビューはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 重大度変更 | .editorconfig | UPDATE | 選択した重大度をEditorConfigファイルに書き込み |

## メッセージ仕様

本ビュー自体にはメッセージ表示はありません。子コントロールのツールチップで情報を表示します。

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| ViewModelの初期化失敗 | テーブルが空の状態で表示される |
| ルールが設定不可 | 重大度コントロールが無効化される |

## 備考

- 本ビューはVisual StudioのThemedDialogスタイルを使用し、Visual Studioテーマに自動的に適応します
- ISettingsEditorViewインターフェースを実装しており、EditorConfig設定エディタのフレームワークに統合されています
- IWpfTableControlを使用してVisual Studioのテーブル表示機能を活用しています
- ContentPresenterを使用してTableControlをホストしています
- Category列でグループ化されており、ルールがカテゴリ別に整理されて表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アナライザー設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnalyzerSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/AnalyzerSetting.cs` | アナライザー設定を保持するデータクラス。Id, Title, Description, Category, Severity, IsNotConfigurable, ChangeSeverity() に注目 |

**読解のコツ**: AnalyzerSettingクラスは個々のアナライザールールの設定を表現します。IsNotConfigurableプロパティが重要で、trueの場合は重大度を変更できません。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AnalyzerSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/AnalyzerSettingsView.xaml` | XAMLによるUI定義。ContentPresenterでテーブルをホスト |
| 2-2 | AnalyzerSettingsView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/AnalyzerSettingsView.xaml.cs` | コードビハインド。ISettingsEditorViewの実装 |

**主要処理フロー**:
1. **行10-14**: ContentPresenter（AnalyzerTable）の定義
2. **行19-25（.cs）**: コンストラクタでTableControlを取得しContentPresenterに設定
3. **行29（.cs）**: UpdateEditorConfigAsyncメソッド - EditorConfig更新
4. **行30（.cs）**: OnCloseメソッド - リソース解放

#### Step 3: ViewModelを理解する

ViewModelがデータソースとテーブル表示を橋渡しします。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AnalyzerSettingsViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/AnalyzerSettingsViewModel.cs` | ViewModelクラス。列定義とデータプロバイダの設定 |

**主要処理フロー**:
- **行27**: Identifier プロパティ - "AnalyzerSettings"
- **行32-41**: GetInitialColumnStates - 6列の初期状態定義（カテゴリでグループ化）
- **行43-51**: GetFixedColumns - 固定列の定義

### プログラム呼び出し階層図

```
AnalyzerSettingsView (View / ISettingsEditorView)
    │
    ├─ コンストラクタ
    │      │
    │      ├─ IWpfSettingsEditorViewModel.GetTableControl()
    │      │      │
    │      │      └─ IWpfTableControl (Visual Studioテーブル)
    │      │
    │      └─ AnalyzerTable.Content = TableControl.Control
    │
    ├─ UpdateEditorConfigAsync(SourceText)
    │      │
    │      └─ _viewModel.UpdateEditorConfigAsync(sourceText)
    │             │
    │             └─ EditorConfigファイルへの書き込み
    │
    └─ OnClose()
           │
           └─ _viewModel.ShutDown()
                  │
                  └─ リソース解放
```

### データフロー図

```
[入力]                          [処理]                           [出力]

EditorConfigファイル ──────▶ ISettingsProvider<AnalyzerSetting>
                                    │
                                    ▼
                         AnalyzerSettingsViewModel
                                    │
                                    ├─ SettingsSnapshotFactory
                                    ├─ SettingsEntriesSnapshot
                                    │
                                    ▼
                            IWpfTableControl ─────────▶ テーブル表示
                                    │                      │
                                    ▼                      │
                           列コントロール                  │
                                    │                      │
                                    ▼                      │
                          SeverityControl ◄────────── カテゴリ別グループ
                             (No.49)

ユーザー編集 ─────────────────────────────────────────▶ 重大度変更
                                                          │
                                                          ▼
                                                .editorconfigファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnalyzerSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/AnalyzerSettingsView.xaml` | ビュー | メインビュー定義 |
| AnalyzerSettingsView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/AnalyzerSettingsView.xaml.cs` | コードビハインド | ISettingsEditorView実装 |
| AnalyzerSettingsViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/AnalyzerSettingsViewModel.cs` | ViewModel | テーブルデータ管理 |
| AnalyzerSettingsViewModel.SettingsSnapshotFactory.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/AnalyzerSettingsViewModel.SettingsSnapshotFactory.cs` | ファクトリ | スナップショット生成 |
| AnalyzerSettingsViewModel.SettingsEntriesSnapshot.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/AnalyzerSettingsViewModel.SettingsEntriesSnapshot.cs` | スナップショット | テーブルデータスナップショット |
| SeverityViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/SeverityViewModel.cs` | ViewModel | 重大度選択管理 |
| SeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml` | 子コントロール | 重大度選択UI |
| ColumnDefinitions.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/ColumnDefinitions.cs` | 定数定義 | テーブル列ID定義 |
