# 画面設計書 49-重大度コントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における重大度コントロール（SeverityControl）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタのアナライザータブにおいて、各アナライザールールの重大度（Severity）を選択するためのドロップダウンコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：アナライザールールの重大度は、コードの問題がどの程度深刻として扱われるかを決定します。Disabled、Refactoring Only、Suggestion、Warning、Errorの5段階から選択でき、プロジェクトの品質基準に応じて調整できます。本コントロールは、この重大度設定をGUIから直感的に変更できるようにするものです。また、一部のルールは設定変更不可（IsNotConfigurable）としてマークされており、その場合はコントロールが無効化されます。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 「Analyzers」タブを選択 → アナライザー設定ビュー内の各行の「Severity」列に本コントロールが表示されます。

**主要な操作・処理内容**：
1. コンボボックスに重大度オプション（Disabled, Refactoring Only, Suggestion, Warning, Error）が表示される
2. 設定可能なルールの場合、ユーザーがドロップダウンから重大度を選択できる
3. 設定不可のルールの場合、コンボボックスが無効化される
4. 選択変更時にViewModelを通じてReportDiagnostic列挙型に変換される
5. AnalyzerSettingのChangeSeverityメソッドが呼び出される
6. EditorConfigファイルに変更が反映される

**画面遷移**：本コントロールはアナライザー設定ビュー（No.48）のテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：IsNotConfigurableがtrueのルールは、コンボボックスが無効化され、ツールチップに設定不可の理由が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 66 | 診断エンジン | 補助機能 | アナライザー診断の重大度ドロップダウン選択 |

## 画面種別

編集コントロール（テーブルセル内ドロップダウン）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Severities | 入力 | string[] | 必須 | 選択可能な重大度の配列（静的プロパティ） |
| SelectedSeverityValue | 入出力 | string | 必須 | 現在選択されている重大度（双方向バインディング） |
| IsConfigurable | 入力 | bool | 必須 | 設定変更可能かどうか（ComboBoxのIsEnabledにバインド） |
| ToolTip | 入力 | string | 必須 | ツールチップに表示するテキスト |
| AutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SeverityComboBox | ComboBox | 重大度を選択するドロップダウン |

### 重大度選択肢

| インデックス | 表示名 | 内部値（ReportDiagnostic） | 説明 |
|-------------|--------|---------------------------|------|
| 0 | Disabled | Suppress | 診断を完全に無効化 |
| 1 | Refactoring Only | Hidden | リファクタリング時のみ表示 |
| 2 | Suggestion | Info | 提案として表示（緑の波線） |
| 3 | Warning | Warn | 警告として表示（黄色の波線） |
| 4 | Error | Error | エラーとして表示（赤の波線） |

### 設定不可時の表示

| 状態 | コンボボックス | ツールチップ |
|------|--------------|-------------|
| IsConfigurable = true | 有効 | "Severity" |
| IsConfigurable = false | 無効（グレーアウト） | "This rule is not configurable" |

## イベント仕様

### 1-SelectionChanged（重大度選択変更）

ユーザーがコンボボックスで異なる重大度を選択した際に発火します。

**処理フロー**：
1. ComboBoxのSelectionChangedイベントが発火
2. SeverityComboBox_SelectionChangedイベントハンドラが呼び出される
3. _viewModel.SelectionChanged(SeverityComboBox.SelectedIndex)が実行される
4. ViewModelが選択インデックスをReportDiagnostic列挙型に変換
5. 現在の重大度と異なる場合のみ、AnalyzerSettingのChangeSeverityメソッドが呼び出される
6. EditorConfigファイルに変更が書き込まれる

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 重大度選択変更 | .editorconfig | UPDATE | 選択した重大度をEditorConfigファイルに書き込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Severity" | 設定可能なルールでマウスホバー時 |
| - | ToolTip | "This rule is not configurable" | 設定不可のルールでマウスホバー時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| 不正なインデックス選択 | InvalidOperationExceptionがスローされる |
| 設定不可のルール | コンボボックスが無効化され、選択変更が防止される |

## 備考

- 本コントロールはVisual StudioのThemedDialogスタイルを使用し、Visual Studioテーマに自動的に適応します
- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- SeverityViewModelを通じてAnalyzerSettingにアクセスします
- IsConfigurableプロパティにより、設定不可のルールでは編集が防止されます
- 変更前に現在の重大度と比較し、実際に変更がある場合のみChangeSeverityが呼び出されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アナライザー設定のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReportDiagnostic.cs | `src/Compilers/Core/Portable/Diagnostic/ReportDiagnostic.cs` | 診断報告の重大度を定義する列挙型 |
| 1-2 | AnalyzerSetting.cs | `src/EditorFeatures/Core/EditorConfigSettings/Data/AnalyzerSetting.cs` | アナライザー設定を保持するデータクラス。Severity、IsNotConfigurable、ChangeSeverity()に注目 |

**読解のコツ**: AnalyzerSettingクラスはIsNotConfigurableプロパティを持ち、これがtrueの場合は設定変更ができません。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml` | XAMLによるUI定義。ComboBoxのバインディング設定とIsEnabledに注目 |
| 2-2 | SeverityControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml.cs` | コードビハインド。SelectionChangedイベントハンドラの実装 |

**主要処理フロー**:
1. **行10-17（XAML）**: Grid内にComboBoxを配置
2. **行11-17（XAML）**: ItemsSource, SelectedValue, IsEnabled, ToolTip, AutomationProperties.Name, SelectionChangedのバインディング
3. **行14（XAML）**: IsEnabled="{Binding IsConfigurable}" で設定不可ルールを制御
4. **行24-25（.cs）**: イベントハンドラでViewModelのSelectionChangedメソッドを呼び出し

#### Step 3: ViewModelを理解する

ViewModelが重大度の変換と設定可否の判定を担います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SeverityViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/SeverityViewModel.cs` | ViewModelクラス。Severities配列、IsConfigurable、SelectionChanged実装 |

**主要処理フロー**:
- **行13-20**: s_severities配列 - 5つの重大度オプション
- **行39**: IsConfigurableプロパティ - !setting.IsNotConfigurableで判定
- **行41**: ToolTipプロパティ - 設定可否に応じてメッセージを変更
- **行45-64**: コンストラクタ - 現在の重大度からインデックスへの変換
- **行66-82**: SelectionChangedメソッド - インデックスからReportDiagnosticへの変換、変更チェック、ChangeSeverity呼び出し

### プログラム呼び出し階層図

```
SeverityControl (View)
    │
    ├─ SeverityComboBox (ComboBox)
    │      │
    │      ├─ IsEnabled ← IsConfigurable (設定可否で制御)
    │      │
    │      └─ SelectionChanged → SeverityComboBox_SelectionChanged
    │             │
    │             └─ SeverityViewModel.SelectionChanged(int)
    │                    │
    │                    ├─ インデックス → ReportDiagnostic 変換
    │                    │     0 → Suppress
    │                    │     1 → Hidden
    │                    │     2 → Info
    │                    │     3 → Warn
    │                    │     4 → Error
    │                    │
    │                    ├─ 現在値と比較（変更がある場合のみ続行）
    │                    │
    │                    └─ AnalyzerSetting.ChangeSeverity(ReportDiagnostic)
    │                           │
    │                           └─ EditorConfigファイルへの書き込み
    │
    └─ DataBinding
           │
           ├─ ItemsSource ← Severities (静的配列)
           │      ├─ "Disabled"
           │      ├─ "Refactoring Only"
           │      ├─ "Suggestion"
           │      ├─ "Warning"
           │      └─ "Error"
           │
           ├─ SelectedValue ← SelectedSeverityValue
           │
           ├─ IsEnabled ← IsConfigurable
           │      └─ !AnalyzerSetting.IsNotConfigurable
           │
           ├─ ToolTip ← ToolTip
           │      ├─ IsConfigurable=true → "Severity"
           │      └─ IsConfigurable=false → "This rule is not configurable"
           │
           └─ AutomationProperties.Name ← AutomationName ("Severity")
```

### データフロー図

```
[入力]                          [処理]                               [出力]

AnalyzerSetting ───────────▶ SeverityViewModel ──────────────▶ ComboBox表示
     │                              │
     │ Severity                     │ SelectedSeverityValue
     │ IsNotConfigurable            │ IsConfigurable
     │                              │ ToolTip
     │                              │
ユーザー選択 ──────────────────────▶│ SelectionChanged
     │                              │
     │ (IsConfigurable=true時のみ)  │
     │                              ├─ 現在値チェック
     │                              │     │
     │                              │     └─ 変更なし → 処理終了
     │                              │
     │                              ├─ インデックス変換
     │                              ▼
              ReportDiagnostic (Suppress/Hidden/Info/Warn/Error)
                                    │
                                    ▼
                      AnalyzerSetting.ChangeSeverity
                                    │
                                    ▼
                            .editorconfigファイル ──────▶ ファイル保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SeverityControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml` | ビュー | ComboBoxを含むUI定義 |
| SeverityControl.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml.cs` | コードビハインド | イベントハンドラ実装 |
| SeverityViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/SeverityViewModel.cs` | ViewModel | 重大度選択管理、設定可否判定 |
| AnalyzerSeverityColumnDefinition.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/ColumnDefinitions/AnalyzerSeverityColumnDefinition.cs` | 列定義 | テーブル列の定義 |
| AnalyzerSettingsView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/AnalyzerSettingsView.xaml` | 親ビュー | 本コントロールを含むテーブルビュー |
| WorkspacesResources.resx | `src/Workspaces/Core/Portable/WorkspacesResources.resx` | リソース | 重大度表示名のローカライズ文字列 |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ツールチップメッセージ |
