# 画面設計書 50-列挙プロパティビュー

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における列挙プロパティビュー（EnumSettingView / EnumPropertyView）の画面設計を記述したものです。このコントロールはEditorConfig設定エディタにおいて、列挙型（enum）のプロパティを表示・編集するための共通ドロップダウンコントロールです。

### 本画面の処理概要

**業務上の目的・背景**：EditorConfigの設定には、多くの列挙型の値を持つオプションがあります（例：インデントスタイル、改行設定など）。本コントロールは、これらの列挙型プロパティを汎用的に表示・編集するための共通コンポーネントとして設計されています。これにより、開発者はコードの重複を避け、一貫したUIを提供できます。

**画面へのアクセス方法**：ソリューションエクスプローラーで.editorconfigファイルをダブルクリック → EditorConfig設定エディタが開く → 各タブ（空白設定、コードスタイル等）内で列挙型プロパティを持つ設定項目に本コントロールが使用されます。

**主要な操作・処理内容**：
1. IEnumSettingViewModelから列挙値の一覧と現在値を取得
2. ComboBoxに選択肢を表示
3. ユーザーがドロップダウンから値を選択
4. 選択変更時にIEnumSettingViewModel.ChangePropertyを呼び出す
5. 設定変更がEditorConfigファイルに反映される

**画面遷移**：本コントロールは各設定ビューのテーブル列として埋め込まれており、単独での画面遷移はありません。

**権限による表示制御**：特に権限による制御はありません。EditorConfigファイルが読み取り専用の場合、設定変更は反映されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | 列挙型プロパティの共通ドロップダウン表示 |

## 画面種別

編集コントロール（テーブルセル内ドロップダウン、汎用列挙型用）

## URL/ルーティング

Visual Studio IDE内のEditorConfig設定エディタ内コンポーネントのため、URLベースのルーティングはありません。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| EnumValues | 入力 | string[] | 必須 | 選択可能な列挙値の配列（バインディング経由） |
| SelectedEnumValue | 入出力 | string | 必須 | 現在選択されている列挙値（双方向バインディング） |
| ToolTip | 入力 | string | 任意 | ツールチップに表示するテキスト |
| AutomationName | 入力 | string | 必須 | アクセシビリティ用の自動化名 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| EnumValueComboBox | ComboBox | 列挙値を選択するドロップダウン |

## イベント仕様

### 1-SelectionChanged（列挙値選択変更）

ユーザーがコンボボックスで異なる値を選択した際に発火します。

**処理フロー**：
1. ComboBoxのSelectionChangedイベントが発火
2. EnumValueComboBox_SelectionChangedイベントハンドラが呼び出される
3. 選択されたインデックスが有効範囲内かチェックされる
4. _model.ChangeProperty(descriptions[index])が呼び出される
5. 設定値がEditorConfigファイルに反映される

## データベース更新仕様

### 操作別データベース影響一覧

本コントロールはデータベースを使用しません。設定変更はEditorConfigファイルに直接書き込まれます。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 列挙値選択変更 | .editorconfig | UPDATE | 選択した列挙値をEditorConfigファイルに書き込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | ToolTip | "Value" | マウスホバー時（ServicesVSResources.Value） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| EditorConfigファイルが読み取り専用 | 変更は反映されず、ファイルは変更されない |
| 不正なインデックス選択 | 範囲外チェックにより処理がスキップされる |

## 備考

- 本コントロールはVisual StudioのThemedDialogComboBoxStyleを使用し、Visual Studioテーマに自動的に適応します
- WPFのUserControlとして実装されており、MVVMパターンに準拠しています
- IEnumSettingViewModelインターフェースを通じて抽象化されており、様々な列挙型設定に対応できます
- EnumSettingViewModelジェネリッククラスを基底として、具体的な設定に対応したViewModelを実装できます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェースを理解する

まず、ViewModelのインターフェースを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IEnumSettingViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/IEnumSettingViewModel.cs` | 列挙型設定ViewModelのインターフェース。EnumValues、SelectedEnumValue、ChangePropertyに注目 |

**読解のコツ**: IEnumSettingViewModelインターフェースは、列挙型プロパティを表示・編集するために必要なプロパティとメソッドを定義しています。

#### Step 2: エントリーポイントを理解する

ビューファイルから処理の流れを追います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EnumPropertyView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/EnumPropertyView.xaml` | XAMLによるUI定義。ComboBoxのバインディング設定を確認 |
| 2-2 | EnumPropertyView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/EnumPropertyView.xaml.cs` | コードビハインド。SelectionChangedイベントハンドラの実装 |

**主要処理フロー**:
1. **行9-17（XAML）**: Grid内にComboBoxを配置
2. **行10-16（XAML）**: Style、ItemsSource、SelectedValue、ToolTip、AutomationProperties.Name、SelectionChangedのバインディング
3. **行11（XAML）**: ThemedDialogComboBoxStyleKeyを使用
4. **行23-30（.cs）**: イベントハンドラで範囲チェック後にChangePropertyを呼び出し

#### Step 3: 基底ViewModelを理解する

EnumSettingViewModelジェネリッククラスの実装を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | EnumSettingViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/EnumSettingViewModel.cs` | 列挙型設定ViewModelの抽象基底クラス |

**主要処理フロー**:
- **行11-15**: ジェネリック型パラメータTはEnumを継承
- **行16**: EnumValuesはGetValueDescriptions()から取得
- **行18-19**: ToolTipとAutomationNameは"Value"を返す
- **行21-35**: SelectedEnumValueプロパティ - 遅延初期化でEnumValuesから取得
- **行37-41**: コンストラクタ - _mappingをGetValuesAndDescriptionsから取得
- **行43-48**: ChangePropertyメソッド - 文字列から列挙値に変換してChangePropertyToを呼び出し
- **行50-57**: GetValueDescriptionsとGetValueIndex - 列挙値の取得とインデックス変換
- **行59-61**: 抽象メソッド - 派生クラスで実装される

### プログラム呼び出し階層図

```
EnumSettingView (View)
    │
    ├─ EnumValueComboBox (ComboBox)
    │      │
    │      ├─ Style ← ThemedDialogComboBoxStyleKey
    │      │
    │      └─ SelectionChanged → EnumValueComboBox_SelectionChanged
    │             │
    │             ├─ インデックス範囲チェック
    │             │     ├─ index < 0 → 処理スキップ
    │             │     └─ index >= descriptions.Length → 処理スキップ
    │             │
    │             └─ IEnumSettingViewModel.ChangeProperty(string)
    │                    │
    │                    └─ EnumSettingViewModel<T>.ChangeProperty(string)
    │                           │
    │                           ├─ _mapping.TryGetValue で列挙値取得
    │                           │
    │                           └─ ChangePropertyTo(T) [抽象メソッド]
    │                                  │
    │                                  └─ 派生クラスの実装で設定変更
    │
    └─ DataBinding
           │
           ├─ ItemsSource ← EnumValues
           │      └─ GetValueDescriptions()
           │
           ├─ SelectedValue ← SelectedEnumValue
           │      └─ 遅延初期化でEnumValuesから取得
           │
           ├─ ToolTip ← ToolTip ("Value")
           │
           └─ AutomationProperties.Name ← AutomationName ("Value")
```

### データフロー図

```
[入力]                          [処理]                           [出力]

具体的な設定クラス ────────▶ EnumSettingViewModel<T> ────────▶ ComboBox表示
     │                              │
     │ 列挙型値                     │ _mapping (string → T)
     │                              │ EnumValues (string[])
     │                              │ SelectedEnumValue
     │                              │
ユーザー選択 ──────────────────────▶│ SelectionChanged
     │                              │
     │ (インデックス範囲チェック)   ├─ ChangeProperty(string)
     │                              │     │
     │                              │     └─ _mapping.TryGetValue
     │                              │           │
     │                              │           └─ ChangePropertyTo(T)
     │                              │
     │                              ▼
                              派生クラスの実装
                                    │
                                    ▼
                            .editorconfigファイル ──────▶ ファイル保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EnumPropertyView.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/EnumPropertyView.xaml` | ビュー | ComboBoxを含むUI定義 |
| EnumPropertyView.xaml.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/EnumPropertyView.xaml.cs` | コードビハインド | イベントハンドラ実装 |
| IEnumSettingViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/IEnumSettingViewModel.cs` | インターフェース | ViewModelの契約定義 |
| EnumSettingViewModel.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/EnumSettingViewModel.cs` | 基底クラス | 列挙型ViewModel抽象実装 |
| IEnumSettingViewModelFactory.cs | `src/VisualStudio/Core/Def/EditorConfigSettings/Common/IEnumSettingViewModelFactory.cs` | ファクトリ | ViewModel生成 |
