# 画面設計書 51-タブコントロールスタイル

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能のEditorConfig設定エディタで使用されるタブコントロールのスタイル定義（リソースディクショナリ）について記述します。

### 本画面の処理概要

このリソースディクショナリは、EditorConfig設定エディタ画面のタブコントロールに対して、Visual Studioテーマに統合されたスタイルを提供します。直接的なユーザー操作画面ではなく、他の画面から参照されるスタイル定義リソースです。

**業務上の目的・背景**：Visual Studio IDEでは、ユーザーがテーマ（ライトテーマ、ダークテーマ等）を切り替えることができます。EditorConfig設定エディタのタブコントロールがIDEのテーマに適合した外観を維持するために、このスタイル定義が必要です。スタイルをリソースディクショナリとして外部化することで、複数の画面から一貫したスタイルを適用でき、テーマ変更時の対応も容易になります。

**画面へのアクセス方法**：このリソースディクショナリは直接アクセスする画面ではありません。EditorConfig設定エディタコントロール（No.37）が読み込まれる際に、リソースとして参照されます。

**主要な操作・処理内容**：
1. TabControlに対してVisual Studioのダイアログスタイルを継承したスタイルを適用
2. TabItemに対してカスタムテンプレートを定義し、選択状態・ホバー状態・フォーカス状態に応じた表示変更を実現
3. 選択されたタブの下に視覚的なインジケーターライン（アンダーライン）を表示

**画面遷移**：該当なし（リソースディクショナリのため画面遷移は発生しません）

**権限による表示制御**：該当なし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 116 | コードスタイル分析 | 補助機能 | EditorConfig設定のタブコントロールスタイル定義 |

## 画面種別

リソースディクショナリ（スタイル定義）

## URL/ルーティング

該当なし（WPFリソースディクショナリ）

## 入出力項目

該当なし（スタイル定義のみ）

## 表示項目

### スタイル定義項目

| 項目名 | 対象コントロール | 説明 |
|--------|-----------------|------|
| TabControl Style | TabControl | VS ThemedDialogTabControlNavigationStyleKeyを継承 |
| TabItem Style | TabItem | カスタムテンプレートによる外観定義 |

### TabItem スタイルプロパティ

| プロパティ | 値 | 説明 |
|-----------|-----|------|
| Background | VsBrushes.BrandedUIBackgroundKey | 背景色（VSテーマ連動） |
| FontSize | VsFonts.Environment122PercentFontSizeKey | フォントサイズ（環境設定の122%） |
| Foreground | VsBrushes.BrandedUITextKey | テキスト色（VSテーマ連動） |
| Padding | 20,0,20,0 | 左右パディング20px |

### TabItem 状態別スタイル

| 状態 | プロパティ変更 |
|------|----------------|
| 選択時（IsSelected=true） | アンダーライン表示、InnerTabSelectedTextBrushKey適用 |
| キーボードフォーカス時 | InnerTabTextFocusedBrushKey適用 |
| マウスホバー時 | InnerTabTextHoverBrushKey適用 |

## イベント仕様

該当なし（スタイル定義のみ）

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし

## 例外処理

該当なし

## 備考

- このリソースディクショナリはEditorConfig設定エディタ専用のスタイル定義です
- Visual Studio Shell 15.0のテーマリソースを参照しているため、VS2017以降のバージョンが必要です
- タブ選択時のアンダーラインは高さ3px、選択されたタブのテキスト幅に合わせて中央配置されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リソースディクショナリ構造を理解する

まず、WPFリソースディクショナリの基本構造とVisual Studioテーマシステムとの連携を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TabControlStyles.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml` | リソースディクショナリのルート定義、名前空間宣言 |

**読解のコツ**:
- `xmlns:vsshell`と`xmlns:vsui`は Visual Studio Shellのスタイルリソースを参照するための名前空間です
- `{DynamicResource}`を使用することで、実行時のテーマ変更に対応します

#### Step 2: TabControlスタイルを理解する

TabControlへのスタイル適用方法を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TabControlStyles.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml` | 7行目：TabControlスタイルのBasedOn継承 |

**主要処理フロー**:
1. **7行目**: `BasedOn="{StaticResource {x:Static vsshell:VsResourceKeys.ThemedDialogTabControlNavigationStyleKey}}"` でVSのタブスタイルを継承

#### Step 3: TabItemカスタムテンプレートを理解する

TabItemの詳細なスタイル定義とトリガーを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TabControlStyles.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml` | 9-60行目：TabItemスタイルとControlTemplate |

**主要処理フロー**:
- **10-14行目**: 基本プロパティ（Background, FontSize, Foreground, Padding）の設定
- **17-35行目**: ControlTemplateでGridレイアウトとアンダーラインRectangleを定義
- **36-55行目**: MultiDataTriggerで選択・フォーカス・ホバー状態を検出して外観変更

#### Step 4: 利用元を理解する

このリソースを使用しているSettingsEditorControlを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SettingsEditorControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml` | リソースディクショナリの参照方法 |

### プログラム呼び出し階層図

```
SettingsEditorControl.xaml
    │
    └─ TabControlStyles.xaml (リソース参照)
           │
           ├─ TabControl Style
           │      └─ VsResourceKeys.ThemedDialogTabControlNavigationStyleKey (継承)
           │
           └─ TabItem Style
                  ├─ VsBrushes.BrandedUIBackgroundKey
                  ├─ VsFonts.Environment122PercentFontSizeKey
                  ├─ VsBrushes.BrandedUITextKey
                  └─ CommonDocumentColors (選択/ホバー/フォーカス状態)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VS テーマ設定 ───────────▶ DynamicResource解決 ───────▶ スタイル適用済みタブUI
                               │
                               ├─ 背景色
                               ├─ テキスト色
                               └─ フォントサイズ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TabControlStyles.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml` | リソース | タブコントロールスタイル定義 |
| SettingsEditorControl.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml` | ソース | スタイルを使用するEditorConfig設定エディタ |
| VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | リソース | 共通VSテーマスタイル定義（参考） |
