# 画面設計書 52-詳細エラー情報ダイアログ

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能において、エラーの詳細情報（スタックトレースを含む）を表示するダイアログ画面について記述します。

### 本画面の処理概要

詳細エラー情報ダイアログは、Roslynの処理中に発生したエラーの詳細情報をユーザーに表示するためのダイアログウィンドウです。スタックトレースなどの技術的な情報を表示し、ユーザーがエラー内容をクリップボードにコピーして、バグ報告や調査に活用できるようにします。

**業務上の目的・背景**：Visual Studio IDEでRoslynベースのコード分析やリファクタリング機能を使用中に、予期しないエラーが発生した場合、ユーザーや開発者がエラーの原因を特定し、適切な報告を行えるようにする必要があります。このダイアログは、エラー情報を読みやすく表示し、簡単にコピーできる機能を提供することで、問題解決のプロセスを支援します。

**画面へのアクセス方法**：このダイアログは通常、Roslyn内部でエラーが発生した際に自動的に表示されるか、エラー報告機能から呼び出されます。ユーザーが明示的にアクセスするメニューは通常ありません。

**主要な操作・処理内容**：
1. エラー情報（スタックトレース含む）の表示
2. 「Copy to Clipboard」ボタンでエラー情報全体をクリップボードにコピー
3. 「Close」ボタンでダイアログを閉じる
4. スクロール可能なテキストエリアで長いスタックトレースの閲覧

**画面遷移**：
- 遷移元：エラー発生箇所（コードリファクタリング、コード分析等）
- 遷移先：なし（ダイアログを閉じて元の画面に戻る）

**権限による表示制御**：特になし。エラーが発生した際に表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 103 | VS コア | 主機能 | エラー詳細情報・スタックトレースの表示とコピー |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（WPF DialogWindow）

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| title | string | ○ | ダイアログのタイトル |
| errorInfo | string | ○ | 表示するエラー情報（スタックトレース等） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| クリップボード | string | コピーボタン押下時にエラー情報をコピー |

## 表示項目

| 項目名 | コントロール種別 | 説明 |
|--------|-----------------|------|
| スタックトレーステキスト | TextBox（ReadOnly） | エラー情報を表示するテキストボックス |
| Copy to Clipboard ボタン | Button | エラー情報をクリップボードにコピー |
| Close ボタン | Button | ダイアログを閉じる |

## イベント仕様

### 1-Copy to Clipboard ボタン押下

エラー情報全体をシステムクリップボードにコピーします。

**処理フロー**:
1. CopyButton.Click イベント発火
2. CopyMessageToClipBoard メソッド実行
3. System.Windows.Clipboard.SetText でエラー情報をコピー
4. 例外発生時（RDPセッション等）は無視

### 2-Close ボタン押下

ダイアログウィンドウを閉じます。

**処理フロー**:
1. CloseButton.Click イベント発火
2. CloseWindow メソッド実行
3. this.Close() でダイアログを閉じる

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | ボタンラベル | Copy to Clipboard | 常時表示 |
| - | ボタンラベル | Close | 常時表示 |

※ボタンラベルはリソースファイル（ServicesVSResources）から読み込まれます。

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|----------|
| 一般例外 | クリップボードコピー失敗時（RDPセッション等） | 例外を無視して処理続行 |

## 備考

- ダイアログはオーナーウィンドウの中央に表示されます（WindowStartupLocation="CenterOwner"）
- タスクバーには表示されません（ShowInTaskbar="False"）
- 最小サイズは幅300px、高さ300pxに制限されています
- 幅は768pxに固定、高さはコンテンツに応じて自動調整されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ダイアログに渡されるデータとその型を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DetailedErrorInfoDialog.xaml.cs | `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml.cs` | コンストラクタで受け取る title と errorInfo パラメータ |

**読解のコツ**:
- コンストラクタで受け取る2つの文字列パラメータがダイアログの入力となります
- errorInfo はフィールドに保存され、コピー機能で使用されます

#### Step 2: XAML構造を理解する

ダイアログのUI構成を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DetailedErrorInfoDialog.xaml | `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml` | DialogWindowの設定、Grid構造、コントロール配置 |

**主要処理フロー**:
1. **1-20行目**: DialogWindow設定（サイズ、位置、背景色等）
2. **21-25行目**: Gridレイアウト定義（2行構成）
3. **26-34行目**: ScrollViewer内のTextBox（スタックトレース表示用）
4. **36-47行目**: ボタンパネル（Copy, Close）

#### Step 3: イベントハンドラを理解する

ボタン押下時の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DetailedErrorInfoDialog.xaml.cs | `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml.cs` | CopyMessageToClipBoard, CloseWindow メソッド |

**主要処理フロー**:
- **26-36行目**: CopyMessageToClipBoard - クリップボードへのコピー（例外ハンドリング付き）
- **38-39行目**: CloseWindow - ダイアログを閉じる

### プログラム呼び出し階層図

```
ErrorReporting (呼び出し元)
    │
    └─ DetailedErrorInfoDialog
           │
           ├─ コンストラクタ(title, errorInfo)
           │      ├─ InitializeComponent()
           │      ├─ Title設定
           │      ├─ stackTraceText.AppendText()
           │      └─ ボタンラベル設定（ServicesVSResources）
           │
           ├─ CopyMessageToClipBoard()
           │      └─ System.Windows.Clipboard.SetText()
           │
           └─ CloseWindow()
                  └─ this.Close()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

title ──────────────────▶ コンストラクタ ───────────────▶ ダイアログタイトル
                               │
errorInfo ──────────────▶ AppendText() ─────────────────▶ TextBox表示
                               │
                               └─ コピーボタン ────────────▶ クリップボード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DetailedErrorInfoDialog.xaml | `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml` | XAML | ダイアログUI定義 |
| DetailedErrorInfoDialog.xaml.cs | `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml.cs` | ソース | ダイアログロジック |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ボタンラベルの文字列リソース |
