# 画面設計書 53-継承マージンコンテキストメニュー

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能の継承マージン機能において、継承関係のナビゲーションを行うためのコンテキストメニューについて記述します。

### 本画面の処理概要

継承マージンコンテキストメニューは、Visual Studioエディタの左マージンに表示される継承マージングリフをクリックした際に表示されるコンテキストメニューです。クラスやインターフェースの継承関係（基底クラス、派生クラス、実装するインターフェース、インターフェースの実装）を階層的に表示し、選択した項目へのコードナビゲーションを提供します。

**業務上の目的・背景**：大規模なコードベースでは、クラスやインターフェースの継承関係を把握することが重要です。継承マージンコンテキストメニューは、コードエディタ内から直接継承関係を可視化し、関連するコードへ素早くナビゲートすることで、開発者の生産性を向上させます。これにより、「Go to Implementation」や「Go to Base」といった操作をマージンから直接実行できます。

**画面へのアクセス方法**：
1. Visual Studioエディタで継承関係を持つクラス、インターフェース、またはメンバーにカーソルを置く
2. 左マージンに表示される継承マージングリフ（アイコン）をクリック
3. コンテキストメニューが表示される

**主要な操作・処理内容**：
1. 継承関係のヘッダー情報表示（「Implemented interfaces」「Base types」「Derived types」等）
2. メンバーレベルの継承情報をサブメニューで表示
3. ターゲット項目をクリックしてコードの定義位置へナビゲート
4. 異なる言語（C#/VB等）の場合は言語アイコンを表示して区別

**画面遷移**：
- 遷移元：エディタの継承マージングリフ
- 遷移先：選択した継承ターゲットの定義位置（ソースコード内）

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | 継承マージン | 主機能 | 継承関係（継承元・実装先）へのナビゲーションメニュー |

## 画面種別

コンテキストメニュー（ポップアップ）

## URL/ルーティング

該当なし（WPF ContextMenu）

## 入出力項目

### 入力項目（データコンテキスト）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| MenuItemViewModels | IEnumerable | メニュー項目のViewModelコレクション |
| ScaleFactor | double | DPIスケーリング係数 |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| ナビゲーション | 選択した継承ターゲットの定義位置へ移動 |

## 表示項目

### メニュー項目種別

| 種別 | ViewModel | スタイル | 説明 |
|------|-----------|----------|------|
| ヘッダー | HeaderMenuItemViewModel | HeaderMenuItemStyle | カテゴリヘッダー（非選択可能） |
| メンバー | MemberMenuItemViewModel | MemberMenuItemStyle | メンバー項目（サブメニュー付き） |
| ターゲット | TargetMenuItemViewModel | TargetMenuItemStyle | ナビゲーション可能な継承ターゲット |
| 言語区別ターゲット | DisambiguousTargetMenuItemViewModel | DisambiguatingTargetMenuItemStyle | 言語アイコン付きターゲット |

### 表示要素

| 要素 | 説明 |
|------|------|
| アイコン | シンボル種別を示すアイコン（CrispImage） |
| 表示名 | 型名またはメンバー名 |
| 言語アイコン | 異なる言語からの継承時に表示（DisambiguatingTargetのみ） |
| 矢印 | サブメニューがある場合に表示 |

## イベント仕様

### 1-ターゲットメニュー項目クリック

継承ターゲットの定義位置へナビゲートします。

**処理フロー**:
1. MenuItem.Click イベント発火
2. TargetMenuItem_OnClick ハンドラ実行
3. InheritanceMarginLogger.LogNavigateToTarget() でログ記録
4. TargetMenuItem_OnClickAsync を非同期実行
5. IUIThreadOperationExecutor でUIスレッド操作を開始
6. DefinitionItem.TryRehydrateAsync でナビゲーション情報を復元
7. IStreamingFindUsagesPresenter.TryPresentLocationOrNavigateIfOneAsync で移動

### 2-サブメニュー展開

メンバーのサブメニューを展開します。

**処理フロー**:
1. MenuItem.SubmenuOpened イベント発火
2. TargetsSubmenu_OnOpen ハンドラ実行
3. InheritanceMarginLogger.LogInheritanceTargetsMenuOpen() でログ記録

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 操作説明 | Navigate to {0} | ナビゲーション実行中の説明 |
| - | ウィンドウタイトル | Navigating | ナビゲーション実行中 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|----------|
| ナビゲーション失敗 | DefinitionItemの復元失敗 | 何もせず処理を終了 |
| キャンセル | ユーザーがキャンセル | 操作を中断 |

## 備考

- メニューの最大高さは400pxに制限されています
- スクロールビューアーでスクロール可能です
- Visual Studioのコマンドバースタイルに準拠したデザインです
- DPIスケーリングに対応しています（ScaleTransform使用）
- メニューはStaysOpen="True"で、明示的に閉じるまで開いたままです

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メニュー項目のViewModelクラス群を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/MenuItemViewModel.cs` | 基底ViewModelクラス |
| 1-2 | TargetMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/TargetMenuItemViewModel.cs` | ナビゲーションターゲットのViewModel |
| 1-3 | MemberMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/MemberMenuItemViewModel.cs` | メンバー項目のViewModel |
| 1-4 | HeaderMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/HeaderMenuItemViewModel.cs` | ヘッダー項目のViewModel |
| 1-5 | DisambiguousTargetMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/DisambiguousTargetMenuItemViewModel.cs` | 言語区別付きターゲットのViewModel |

**読解のコツ**:
- TargetMenuItemViewModelのDefinitionItemプロパティがナビゲーション先情報を保持します
- DetachedDefinitionItemは軽量化された定義アイテムで、Solutionから再構築が必要です

#### Step 2: XAML構造を理解する

コンテキストメニューのUI定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InheritanceMarginContextMenu.xaml | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginContextMenu.xaml` | メニューのテンプレート定義、スタイル定義 |

**主要処理フロー**:
1. **1-22行目**: ContextMenuのルート定義と名前空間
2. **23-269行目**: リソース定義（スタイル、DataTemplate）
3. **271-303行目**: ContextMenuのControlTemplate
4. **305-307行目**: ItemContainerTemplateSelector

#### Step 3: テンプレートセレクターを理解する

ViewModelに応じたテンプレート選択ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MenuItemContainerTemplateSelector.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/MenuItemContainerTemplateSelector.cs` | ViewModelの型に基づくテンプレート選択 |

**主要処理フロー**:
- **18-21行目**: HeaderMenuItemViewModelの場合はHeaderMenuItemTemplateを返す
- **24-28行目**: DisambiguousTargetMenuItemViewModelの場合はDisambiguatingTargetMenuItemTemplateを返す
- **30-34行目**: TargetMenuItemViewModelの場合はTargetMenuItemTemplateを返す
- **36-40行目**: MemberMenuItemViewModelの場合はMemberMenuItemTemplateを返す

#### Step 4: イベントハンドラを理解する

メニュー項目選択時の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | InheritanceMarginContextMenu.xaml.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginContextMenu.xaml.cs` | クリックイベントハンドラ、非同期ナビゲーション |

**主要処理フロー**:
- **48-57行目**: TargetMenuItem_OnClick - クリックイベントのエントリーポイント
- **59-78行目**: TargetMenuItem_OnClickAsync - 非同期ナビゲーション処理

### プログラム呼び出し階層図

```
継承マージングリフ（クリック）
    │
    └─ InheritanceMarginContextMenu.Show()
           │
           ├─ MenuItemContainerTemplateSelector.SelectTemplate()
           │      ├─ HeaderMenuItemTemplate
           │      ├─ TargetMenuItemTemplate
           │      ├─ DisambiguatingTargetMenuItemTemplate
           │      └─ MemberMenuItemTemplate
           │
           └─ TargetMenuItem_OnClick()
                  │
                  ├─ InheritanceMarginLogger.LogNavigateToTarget()
                  │
                  └─ TargetMenuItem_OnClickAsync()
                         │
                         ├─ IUIThreadOperationExecutor.BeginExecute()
                         │
                         ├─ DefinitionItem.TryRehydrateAsync()
                         │
                         └─ IStreamingFindUsagesPresenter
                                .TryPresentLocationOrNavigateIfOneAsync()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

InheritanceMarginTag ────▶ ViewModel生成 ────────────────▶ メニュー表示
                                │
                                ├─ HeaderMenuItemViewModel
                                ├─ MemberMenuItemViewModel
                                └─ TargetMenuItemViewModel
                                         │
                                         └─ ユーザークリック
                                                │
                                                └─ TryRehydrateAsync ──▶ ナビゲーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InheritanceMarginContextMenu.xaml | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginContextMenu.xaml` | XAML | コンテキストメニューUI定義 |
| InheritanceMarginContextMenu.xaml.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginContextMenu.xaml.cs` | ソース | イベントハンドラ |
| MenuItemContainerTemplateSelector.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/MenuItemContainerTemplateSelector.cs` | ソース | テンプレートセレクター |
| TargetMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/TargetMenuItemViewModel.cs` | ソース | ナビゲーションターゲットViewModel |
| MemberMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/MemberMenuItemViewModel.cs` | ソース | メンバー項目ViewModel |
| HeaderMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/HeaderMenuItemViewModel.cs` | ソース | ヘッダー項目ViewModel |
| DisambiguousTargetMenuItemViewModel.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/DisambiguousTargetMenuItemViewModel.cs` | ソース | 言語区別ターゲットViewModel |
| InheritanceMarginGlyph.cs | `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginGlyph.cs` | ソース | マージングリフコントロール |
| InheritanceMarginLogger.cs | `src/VisualStudio/Core/Def/InheritanceMargin/InheritanceMarginLogger.cs` | ソース | ログ記録 |
