# 画面設計書 54-VSテーマ辞書

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能の各ダイアログやコントロールに対して、Visual Studioテーマに統合されたスタイルを提供するリソースディクショナリについて記述します。

### 本画面の処理概要

VSテーマ辞書（VSThemeDictionary.xaml）は、Roslyn拡張機能内のダイアログやコントロールに対して、Visual Studioの現在のテーマ（ライト、ダーク、ブルー等）に適合したスタイルを一括定義するリソースディクショナリです。各種WPFコントロール（Button、CheckBox、ComboBox、DataGrid等）に対してVSのシェルスタイルを継承したスタイルを定義しています。

**業務上の目的・背景**：Visual Studio拡張機能を開発する際、IDE全体との視覚的一貫性を維持することが重要です。ユーザーがダークテーマやライトテーマを選択した場合、拡張機能のUIも同様のテーマに従う必要があります。このリソースディクショナリを使用することで、個別にスタイルを定義する手間を省き、Visual Studioのネイティブなルック＆フィールを維持できます。

**画面へのアクセス方法**：このリソースディクショナリは直接アクセスする画面ではありません。Roslyn拡張機能の各ダイアログやコントロールがリソースとして参照します。

**主要な操作・処理内容**：
1. 標準WPFコントロール（Button、CheckBox、ComboBox等）へのVSテーマスタイル適用
2. DataGrid関連コントロールのカスタムスタイル定義
3. テーマ変更時の動的なスタイル更新（DynamicResource使用）

**画面遷移**：該当なし（リソースディクショナリのため画面遷移は発生しません）

**権限による表示制御**：該当なし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 103 | VS コア | 補助機能 | Visual Studioテーマ対応の共通スタイル定義 |

## 画面種別

リソースディクショナリ（スタイル定義）

## URL/ルーティング

該当なし（WPFリソースディクショナリ）

## 入出力項目

該当なし（スタイル定義のみ）

## 表示項目

### スタイル定義対象コントロール

| コントロール | 継承元スタイル | 説明 |
|-------------|--------------|------|
| Button | ThemedDialogButtonStyleKey | ダイアログボタン |
| CheckBox | ThemedDialogCheckBoxStyleKey | チェックボックス |
| ComboBox | ThemedDialogComboBoxStyleKey | コンボボックス |
| GridViewColumnHeader | ThemedDialogGridViewColumnHeaderStyleKey | グリッドビューヘッダー |
| Hyperlink | ThemedDialogHyperlinkStyleKey | ハイパーリンク |
| Label | ThemedDialogLabelStyleKey | ラベル |
| ListBox | ThemedDialogListBoxStyleKey | リストボックス |
| ListView | ThemedDialogListViewStyleKey | リストビュー |
| ListViewItem | ThemedDialogListViewItemStyleKey | リストビュー項目 |
| RadioButton | ThemedDialogRadioButtonStyleKey | ラジオボタン |
| ScrollBar | ScrollBarStyleKey | スクロールバー |
| TextBox | ThemedDialogTextBoxStyleKey | テキストボックス |
| TreeView | ThemedDialogTreeViewStyleKey | ツリービュー |
| TreeViewItem | ThemedDialogTreeViewItemStyleKey | ツリービュー項目 |
| TabControl | ThemedDialogTabControlNavigationStyleKey | タブコントロール |

### カスタムスタイル定義

| コントロール | 定義内容 |
|-------------|---------|
| GroupBox | Foreground、Background設定 |
| TextBlock | Foreground、Background設定 |
| DataGrid | Background、GridLinesBrush、BorderThickness設定 |
| DataGridColumnHeader | Foreground、Background、BorderBrush、Padding設定 + ホバースタイル |
| DataGridRowHeader | Foreground、Background、BorderBrush、Width設定 |
| DataGridRow | Foreground、Background、BorderThickness設定 + ホバースタイル |
| DataGridCell | BorderThickness設定 |
| Thumb (ColumnHeaderGripper) | Width、Background、Cursor設定 |

## イベント仕様

該当なし（スタイル定義のみ）

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし

## 例外処理

該当なし

## 備考

- このリソースディクショナリはRoslyn拡張機能全体で共有される共通スタイル定義です
- Visual Studio Shell 15.0のテーマリソースを参照しているため、VS2017以降のバージョンが必要です
- DynamicResourceを使用しているため、実行中のテーマ変更に対応します
- DataGridのカスタムスタイルは、VSのヘッダーカラーやグリッドラインカラーを使用しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 標準コントロールスタイルを理解する

VS ShellのThemedDialogスタイルを継承する定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | 7-21行目：標準コントロールへのスタイル継承 |

**読解のコツ**:
- `BasedOn="{StaticResource {x:Static vsshell:VsResourceKeys.XXXStyleKey}}"` でVSスタイルを継承
- TargetTypeを指定することで、対象コントロール全てに自動適用

#### Step 2: TextBlock/GroupBoxスタイルを理解する

テキスト関連のスタイル定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | 23-31行目：GroupBoxとTextBlockのスタイル |

**主要処理フロー**:
- **23-26行目**: GroupBoxのForeground/Background設定
- **28-31行目**: TextBlockのForeground/Background設定

#### Step 3: DataGrid関連スタイルを理解する

DataGridとその関連コントロールのカスタムスタイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | 33-96行目：DataGrid関連スタイル |

**主要処理フロー**:
- **34-39行目**: DataGrid本体のスタイル（Background、GridLines、Border）
- **41-52行目**: ColumnHeaderGripperStyle（リサイズハンドル）
- **54-71行目**: DataGridColumnHeaderスタイル（ホバー時の動作含む）
- **73-79行目**: DataGridRowHeaderスタイル
- **81-91行目**: DataGridRowスタイル（ホバー時の動作含む）
- **93-95行目**: DataGridCellスタイル

### プログラム呼び出し階層図

```
Roslynダイアログ/コントロール
    │
    └─ VSThemeDictionary.xaml (リソース参照)
           │
           ├─ 標準コントロールスタイル
           │      ├─ Button ─────────▶ ThemedDialogButtonStyleKey
           │      ├─ CheckBox ───────▶ ThemedDialogCheckBoxStyleKey
           │      ├─ ComboBox ───────▶ ThemedDialogComboBoxStyleKey
           │      ├─ TextBox ────────▶ ThemedDialogTextBoxStyleKey
           │      └─ ... その他
           │
           ├─ テキストコントロールスタイル
           │      ├─ GroupBox ───────▶ VsBrushes.ToolWindowTextKey
           │      └─ TextBlock ──────▶ VsBrushes.ToolWindowTextKey
           │
           └─ DataGridスタイル
                  ├─ DataGrid ───────▶ HeaderColors.DefaultBrushKey
                  ├─ DataGridColumnHeader
                  ├─ DataGridRowHeader
                  ├─ DataGridRow
                  └─ DataGridCell
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VS テーマ設定 ───────────▶ DynamicResource解決 ───────▶ 全コントロールにスタイル適用
                               │
                               ├─ VsBrushes (色)
                               ├─ VsFonts (フォント)
                               ├─ HeaderColors (ヘッダー)
                               └─ ThemedDialogColors (ダイアログ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | リソース | VSテーマ統合スタイル定義 |
| TabControlStyles.xaml | `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml` | リソース | タブコントロール専用スタイル（参考） |
| ChangeSignatureDialog.xaml | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml` | XAML | 使用例（リファクタリングダイアログ） |
| GenerateTypeDialog.xaml | `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml` | XAML | 使用例（型生成ダイアログ） |
