# 画面設計書 55-ステータスインジケーター

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能の診断ツールウィンドウにおいて、各機能の処理状態を視覚的に表示するステータスインジケーターコントロールについて記述します。

### 本画面の処理概要

ステータスインジケーターは、Roslyn診断ツールウィンドウのパフォーマンスマージンパネル内で使用されるコントロールで、各機能（シンタックスハイライト、セマンティック分析、コード補完等）のアクティビティ状態をバーグラフ形式で表示します。VUメーターのように、アクティブな状態では緑から赤へのグラデーションバーが伸び、非アクティブになると縮小するアニメーションを行います。

**業務上の目的・背景**：Roslynベースの言語サービスは多くのバックグラウンド処理を並行して実行しています。開発者やテスターがパフォーマンス問題を診断する際、どの機能がいつアクティブに処理を行っているかを把握することが重要です。このインジケーターにより、各機能のアクティビティをリアルタイムで可視化し、パフォーマンスボトルネックの特定を支援します。

**画面へのアクセス方法**：
1. Visual Studioメニューから「表示」>「その他のウィンドウ」>「Roslyn Diagnostics」を選択
2. 診断ツールウィンドウが開く
3. 「Perf」タブを選択
4. 各機能のステータスインジケーターが表示される

**主要な操作・処理内容**：
1. 各機能のActivityLevelを監視
2. アクティブ状態変更時にアニメーションを開始
3. アクティブ時：1秒かけてバーが伸びるアニメーション
4. 非アクティブ時：0.33秒かけてバーが縮むアニメーション

**画面遷移**：該当なし（診断ツールウィンドウ内のコンポーネント）

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 121 | IDEベンチマーク | 主機能 | パフォーマンス状態のインジケーター表示 |

## 画面種別

UserControl（診断ツールウィンドウ内コンポーネント）

## URL/ルーティング

該当なし（WPF UserControl）

## 入出力項目

### 入力項目（コンストラクタ）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| activityLevel | ActivityLevel | ○ | 監視対象のアクティビティレベル |

### 出力項目

なし（視覚的表示のみ）

## 表示項目

| 項目名 | コントロール種別 | 説明 |
|--------|-----------------|------|
| バーグラフ | Rectangle | 緑から赤へのグラデーションで塗りつぶされた矩形 |

### バーグラフ仕様

| 属性 | 値 | 説明 |
|------|-----|------|
| 幅 | 30px | 最大表示幅 |
| 高さ | 8px | バーの高さ |
| 開始色 | #FFC4FF00 | 黄緑色（左端） |
| 終了色 | Red | 赤色（右端） |

## イベント仕様

### 1-アクティビティ状態変更

ActivityLevelのIsActive状態が変更された際に呼び出されます。

**処理フロー**:
1. ActivityLevel.IsActiveChanged イベント発火
2. ActivityLevel_IsActiveChanged ハンドラ実行
3. _changedSinceLastUpdate フラグをtrueに設定
4. 次のUI更新サイクルでUpdateOnUIThreadが呼び出される

### 2-UI更新

定期的にUIスレッドから呼び出され、必要に応じてアニメーションを開始します。

**処理フロー**:
1. UpdateOnUIThread メソッド呼び出し
2. _changedSinceLastUpdate がfalseならば何もしない
3. _changedSinceLastUpdate をfalseにリセット
4. 既存のアニメーションを削除
5. 最小スケール（0.2）を保証
6. アクティブ状態に応じたアニメーションを開始
   - アクティブ: 1秒かけて1.0までスケール
   - 非アクティブ: 0.33秒かけて0.0までスケール

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし

## 例外処理

該当なし（WPFアニメーション処理は例外を発生させにくい）

## 備考

- WPFのワンウェイバインディングを使用しない理由：高頻度のイベントでメモリ割り当てを最小化するため
- ScaleTransformのScaleXプロパティをアニメーションでクリッピング領域を制御
- FillBehavior.HoldEndでアニメーション終了後も状態を維持
- 静的アニメーションオブジェクトを共有してGC負荷を軽減

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アクティビティ状態を表すActivityLevelクラスを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ActivityLevel.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/ActivityLevel.cs` | アクティビティ状態管理クラス |

**読解のコツ**:
- `IsActive`プロパティは参照カウント方式（`_isActive > 0`で判定）
- `Start()`と`Stop()`でアクティビティをインクリメント/デクリメント
- 親子関係を持ち、子がアクティブなら親もアクティブに

#### Step 2: XAML構造を理解する

インジケーターのUI定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StatusIndicator.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/StatusIndicator.xaml` | VUメーター風バーグラフの定義 |

**主要処理フロー**:
1. **5-12行目**: コメントでVUメーターの仕組みを説明
2. **13-27行目**: Rectangleの定義
3. **14-20行目**: クリッピング領域とScaleTransform
4. **21-26行目**: LinearGradientBrushによる色グラデーション

#### Step 3: アニメーションロジックを理解する

コードビハインドのアニメーション処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StatusIndicator.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/StatusIndicator.xaml.cs` | Subscribe/Unsubscribe、UpdateOnUIThread |

**主要処理フロー**:
- **32-35行目**: Subscribe - イベントハンドラ登録
- **37-40行目**: Unsubscribe - イベントハンドラ解除
- **42-45行目**: ActivityLevel_IsActiveChanged - 変更フラグ設定
- **47-49行目**: アニメーション定数（MinimumScale、アニメーション定義）
- **51-69行目**: UpdateOnUIThread - アニメーション制御

#### Step 4: 親コントロールを理解する

ステータスインジケーターを使用するPerfMarginPanelを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PerfMarginPanel.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/PerfMarginPanel.cs` | インジケーター群の配置と更新タイミング |

### プログラム呼び出し階層図

```
DiagnosticsWindow
    │
    └─ PerfMarginPanel
           │
           ├─ ActivityLevel (親)
           │      │
           │      └─ ActivityLevel (子) ×N
           │             │
           │             └─ StatusIndicator
           │                    │
           │                    ├─ Subscribe()
           │                    │      └─ IsActiveChanged イベント登録
           │                    │
           │                    └─ UpdateOnUIThread()
           │                           │
           │                           └─ BeginAnimation()
           │                                  ├─ s_growAnimation (アクティブ時)
           │                                  └─ s_shrinkAnimation (非アクティブ時)
           │
           └─ Timer (更新サイクル)
                  └─ StatusIndicator.UpdateOnUIThread()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

Roslyn機能アクティビティ ──▶ ActivityLevel.Start/Stop ──▶ IsActiveChanged
                                    │
                                    └─ 状態変更
                                           │
                                           └─ UpdateOnUIThread ──▶ バーグラフアニメーション
                                                  │
                                                  ├─ アクティブ ──▶ 伸びる (1秒)
                                                  │
                                                  └─ 非アクティブ ──▶ 縮む (0.33秒)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StatusIndicator.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/StatusIndicator.xaml` | XAML | バーグラフUI定義 |
| StatusIndicator.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/StatusIndicator.xaml.cs` | ソース | アニメーション制御ロジック |
| ActivityLevel.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/ActivityLevel.cs` | ソース | アクティビティ状態管理 |
| PerfMarginPanel.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/PerfMarginPanel.cs` | ソース | パネル全体の制御 |
| DataModel.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/DataModel.cs` | ソース | ActivityLevel階層構造定義 |
| DiagnosticsWindow.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/DiagnosticsWindow.cs` | ソース | 診断ツールウィンドウ本体 |
