# 画面設計書 56-プロジェクションバッファマージン

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能の診断ツールにおいて、プロジェクションバッファ（VenusMargin）の内容を可視化・診断するためのマージンコントロールについて記述します。

### 本画面の処理概要

プロジェクションバッファマージンは、Visual Studioエディタのプロジェクションバッファ構造を可視化する診断用ツールです。プロジェクションバッファは、ASP.NETやRazorなどのWebテクノロジーで使用される、複数のソースバッファを組み合わせて1つのビューを構成する仕組みです。このマージンは、各ソースバッファの内容とそのスパン情報を表示し、開発者がバッファ構造を理解・デバッグできるようにします。

**業務上の目的・背景**：ASP.NET（コードネーム：Venus）やRazorビューでは、HTML、CSS、JavaScript、C#/VBコードが混在した複雑なドキュメント構造を持ちます。これらはプロジェクションバッファを使用して実装されており、言語サービスのデバッグ時にバッファ構造を把握することが困難です。このマージンは、プロジェクションバッファの内部構造を可視化し、言語サービス開発者やテスターがバッファ関連の問題を診断できるようにします。

**画面へのアクセス方法**：
1. Visual StudioでRoslyn診断ツールを有効化
2. ASP.NETまたはRazorファイルをエディタで開く
3. プロジェクションバッファマージンがエディタマージンとして表示される

**主要な操作・処理内容**：
1. ソースバッファ一覧のドロップダウン表示
2. 各バッファのコンテンツタイプ表示
3. ソーススパン一覧の水平表示（選択可能）
4. スパン選択時に対応するテキスト範囲をハイライト
5. バッファボタンクリックで個別バッファの新規ウィンドウ表示

**画面遷移**：
- 遷移元：エディタマージン（自動表示）
- 遷移先：個別バッファのテキストビューウィンドウ

**権限による表示制御**：特になし（診断ツール有効時のみ表示）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 103 | VS コア | 主機能 | プロジェクションバッファの診断表示 |

## 画面種別

UserControl（エディタマージン内コンポーネント）

## URL/ルーティング

該当なし（WPF UserControl）

## 入出力項目

### 入力項目（プロパティ）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TextView | IWpfTextView | 対象のテキストビュー |
| TextEditorFactory | ITextEditorFactoryService | テキストエディタ作成サービス |

### データバインディング項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SourceBuffers | IEnumerable | ソースバッファコレクション |
| SourceSpans | IEnumerable | ソーススパンコレクション |

## 表示項目

| 項目名 | コントロール種別 | 説明 |
|--------|-----------------|------|
| バッファメニュー | Menu > MenuItem | ソースバッファ一覧（ドロップダウン） |
| バッファボタン | Button | 各バッファのコンテンツタイプを表示、クリックで新規ウィンドウ |
| スパンリスト | ListView | ソーススパン一覧（水平配置） |
| スパンアイテム | Border > StackPanel | 各スパンの情報（コンテンツタイプ + スパン範囲） |

### スパンアイテム表示内容

| 項目 | バインディング | 説明 |
|------|---------------|------|
| コンテンツタイプ | Snapshot.ContentType.DisplayName | スパンのコンテンツタイプ名 |
| スパン範囲 | Span | スパンの位置と長さ |

## イベント仕様

### 1-バッファボタンクリック

選択したバッファの内容を新規ウィンドウで表示します。

**処理フロー**:
1. Button.Click イベント発火
2. Button_Click ハンドラ実行
3. ボタンのTagからITextBufferを取得
4. TextEditorFactory.CreateTextView でビュー作成
5. プロジェクションバッファから対象バッファのスパンを抽出
6. TextEditorFactory.CreateTextViewHost でホスト作成
7. 新規Windowを作成して表示
8. ウィンドウクローズ時にホストを破棄

### 2-スパン選択変更

スパンリストで選択を変更すると、対応するテキスト範囲をハイライトします。

**処理フロー**:
1. ListView.SelectionChanged イベント発火
2. ListView_SelectionChanged ハンドラ実行
3. 選択されたSnapshotSpanをSpanに変換
4. TextViewのプロパティにスパン情報を設定
5. ProjectionSpanTaggerProvider経由でハイライトタグを更新
6. 静的イベントSelectionChangedを発火

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | メニューヘッダー | buffers | 常時表示 |

## 例外処理

該当なし

## 備考

- このコントロールは診断・デバッグ目的のため、通常のユーザーには表示されません
- VenusMarginFactoryで条件に応じてマージンを作成します
- プロジェクションスパンのハイライトはProjectionSpanTaggerProviderで実装されています
- Window.Closedイベントでテキストビューホストを適切に破棄してメモリリークを防止

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクションバッファのViewModelを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ProjectionBufferViewModel.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferViewModel.cs` | バインディング用ViewModel |

**読解のコツ**:
- SourceBuffersとSourceSpansがバインディングソース
- IProjectionBufferから情報を抽出してViewModelに変換

#### Step 2: XAML構造を理解する

マージンのUI定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProjectionBufferMargin.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferMargin.xaml` | Grid構成、Menu、ListView定義 |

**主要処理フロー**:
1. **10-16行目**: Grid列定義（メニュー列 + スパンリスト列）
2. **18-31行目**: バッファ選択メニュー
3. **33-56行目**: スパン一覧ListView

#### Step 3: コードビハインドを理解する

イベントハンドラの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ProjectionBufferMargin.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferMargin.xaml.cs` | Button_Click、ListView_SelectionChanged |

**主要処理フロー**:
- **30-34行目**: ListView_SelectionChanged - スパン選択時のプロパティ設定
- **41-67行目**: Button_Click - 新規ウィンドウでバッファ表示

#### Step 4: マージンファクトリを理解する

マージンの生成条件と登録を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | VenusMarginFactory.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/VenusMarginFactory.cs` | マージン生成条件 |

### プログラム呼び出し階層図

```
VenusMarginFactory
    │
    └─ CreateMargin() (条件付き)
           │
           └─ ProjectionBufferMargin
                  │
                  ├─ DataContext (ProjectionBufferViewModel)
                  │      ├─ SourceBuffers
                  │      └─ SourceSpans
                  │
                  ├─ Button_Click()
                  │      ├─ TextEditorFactory.CreateTextView()
                  │      ├─ TextEditorFactory.CreateTextViewHost()
                  │      └─ Window.Show()
                  │
                  └─ ListView_SelectionChanged()
                         ├─ TextView.Properties設定
                         └─ ProjectionSpanTaggerProvider
                                └─ タグ更新
```

### データフロー図

```
[入力]                      [処理]                         [出力]

IProjectionBuffer ─────────▶ ViewModel変換 ───────────────▶ バインディング
                                  │
                                  ├─ SourceBuffers ────────▶ メニュー表示
                                  │
                                  └─ SourceSpans ──────────▶ ListView表示
                                         │
                                         └─ 選択 ──────────▶ ハイライトタグ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProjectionBufferMargin.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferMargin.xaml` | XAML | マージンUI定義 |
| ProjectionBufferMargin.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferMargin.xaml.cs` | ソース | イベントハンドラ |
| ProjectionBufferViewModel.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferViewModel.cs` | ソース | バインディングViewModel |
| VenusMarginFactory.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/VenusMarginFactory.cs` | ソース | マージン生成ファクトリ |
| VenusMargin.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/VenusMargin.cs` | ソース | マージン本体 |
| ProjectionSpanTaggerProvider.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionSpanTaggerProvider.cs` | ソース | ハイライトタグプロバイダー |
| ProjectionSpanTag.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionSpanTag.cs` | ソース | ハイライトタグ |
