# 画面設計書 57-テレメトリパネル

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能の診断ツールウィンドウにおいて、テレメトリ情報（CodeAction型とそのテレメトリID）を収集・表示するパネルについて記述します。

### 本画面の処理概要

テレメトリパネルは、Roslyn診断ツールウィンドウのタブの1つとして、現在読み込まれている全アセンブリからCodeAction派生型を検索し、そのテレメトリID（ハッシュ値）を一覧表示します。これにより、テレメトリデータの分析時にCodeActionの識別が可能になります。

**業務上の目的・背景**：Roslynでは、コード修正（CodeAction）の使用状況をテレメトリで追跡しています。テレメトリデータには型の完全名ではなく、ハッシュ化されたIDが使用されます。開発者やサポートチームがテレメトリデータを分析する際、このパネルを使用してテレメトリIDと実際のCodeAction型のマッピングを確認できます。

**画面へのアクセス方法**：
1. Visual Studioメニューから「表示」>「その他のウィンドウ」>「Roslyn Diagnostics」を選択
2. 診断ツールウィンドウが開く
3. 「Telemetry」タブを選択

**主要な操作・処理内容**：
1. 「Dump」ボタンで全アセンブリをスキャンしてCodeAction型を検索
2. 各CodeAction型のテレメトリIDを計算
3. 結果をテキストボックスに表示
4. 「Copy」ボタンで結果をクリップボードにコピー

**画面遷移**：該当なし（診断ツールウィンドウ内のパネル）

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 103 | VS コア | 主機能 | テレメトリ情報の診断表示 |

## 画面種別

UserControl（診断ツールウィンドウ内パネル）

## URL/ルーティング

該当なし（WPF UserControl）

## 入出力項目

### 入力項目

なし（ユーザー操作のみ）

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 結果テキスト | string | スキャン結果のテキスト |
| クリップボード | string | コピーボタン押下時に結果をコピー |

## 表示項目

| 項目名 | コントロール種別 | 説明 |
|--------|-----------------|------|
| プログレスバー | ProgressBar | スキャン中のインジケーター |
| 結果テキスト | TextBox（ReadOnly） | スキャン結果を表示 |
| Telemetry Infoラベル | Label | 「Telemetry Info」テキスト |
| Dumpボタン | Button | スキャン開始 |
| Copy To Clipboardラベル | Label | 「Copy To Clipboard」テキスト |
| Copyボタン | Button | 結果をコピー |

### 結果表示形式

```
Searching: [アセンブリフルネーム]
Found: [型フルネーム]: [テレメトリID]
...
```

## イベント仕様

### 1-Dumpボタン押下

全アセンブリをスキャンしてCodeAction派生型のテレメトリIDを収集します。

**処理フロー**:
1. Button.Click イベント発火
2. OnDump ハンドラ実行
3. DumpButtonとCopyButtonを無効化
4. プログレスバーをIndeterminateモードに設定
5. バックグラウンドでGetTelemetryString実行
6. 全アセンブリを走査
7. 各アセンブリ内の型を走査
8. CodeAction派生型を検出
9. GetTelemetryIdでテレメトリIDを取得
10. 結果をStringBuilderに追加
11. 結果をTextBoxに表示
12. プログレスバーを通常モードに戻す
13. ボタンを再有効化

### 2-Copyボタン押下

結果テキストをクリップボードにコピーします。

**処理フロー**:
1. Button.Click イベント発火
2. OnCopy ハンドラ実行
3. Clipboard.SetTextで結果をコピー

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | ラベル | Telemetry Info | 常時表示 |
| - | ボタン | Dump | 常時表示 |
| - | ラベル | Copy To Clipboard | 常時表示 |
| - | ボタン | Copy | 常時表示 |
| - | 結果 | Searching: {アセンブリ名} | スキャン中 |
| - | 結果 | Found: {型名}: {テレメトリID} | CodeAction発見時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|----------|
| 一般例外 | アセンブリスキャン中のエラー | try-catchで無視して続行 |

## 備考

- スキャン処理はバックグラウンドスレッドで実行されます
- スキャン中はボタンが無効化され、二重実行を防止します
- ネストした型も再帰的にスキャンされます
- GetTypeForTelemetryとGetTelemetryIdはRoslynの内部メソッドを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: XAML構造を理解する

パネルのUI定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TelemetryPanel.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/TelemetryPanel.xaml` | Grid構成、コントロール配置 |

**主要処理フロー**:
1. **8-12行目**: Grid行定義（結果エリア + ボタンエリア）
2. **13-18行目**: ScrollViewer内のProgressBarとTextBox
3. **19-24行目**: ボタンパネル

#### Step 2: イベントハンドラを理解する

ボタン押下時の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TelemetryPanel.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/TelemetryPanel.xaml.cs` | OnDump、OnCopy、GetTelemetryString |

**主要処理フロー**:
- **30-48行目**: OnDump - 非同期でスキャン実行
- **50-53行目**: OnCopy - クリップボードコピー
- **55-132行目**: GetTelemetryString - アセンブリスキャンロジック

#### Step 3: スキャンロジックを理解する

CodeAction型の検索とテレメトリID取得を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TelemetryPanel.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/TelemetryPanel.xaml.cs` | ScanAssembly、ScanType、RecordIfCodeAction、IsCodeAction |

**主要処理フロー**:
- **72-91行目**: ScanAssembly - アセンブリ内のモジュールと型を走査
- **93-108行目**: ScanType - 型とネスト型を再帰的に走査
- **110-120行目**: RecordIfCodeAction - CodeAction型のテレメトリID記録
- **122-131行目**: IsCodeAction - CodeAction派生型の判定

### プログラム呼び出し階層図

```
DiagnosticsWindow
    │
    └─ TabControl
           │
           └─ TelemetryPanel (Telemetryタブ)
                  │
                  ├─ OnDump()
                  │      │
                  │      └─ Task.Run(GetTelemetryString)
                  │             │
                  │             ├─ AppDomain.GetAssemblies()
                  │             │
                  │             └─ foreach assembly
                  │                    │
                  │                    └─ ScanAssembly()
                  │                           │
                  │                           ├─ GetModules()
                  │                           │
                  │                           └─ ScanType()
                  │                                  │
                  │                                  ├─ GetTypeForTelemetry()
                  │                                  │
                  │                                  ├─ RecordIfCodeAction()
                  │                                  │      ├─ IsCodeAction()
                  │                                  │      └─ GetTelemetryId()
                  │                                  │
                  │                                  └─ GetNestedTypes() (再帰)
                  │
                  └─ OnCopy()
                         └─ Clipboard.SetText()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

Dumpボタン押下 ───────────▶ GetTelemetryString() ─────────▶ 結果テキスト
                                  │
                                  ├─ アセンブリ走査
                                  ├─ 型走査
                                  ├─ CodeAction判定
                                  └─ テレメトリID取得
                                         │
                                         └─ Copyボタン押下 ──▶ クリップボード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TelemetryPanel.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/TelemetryPanel.xaml` | XAML | パネルUI定義 |
| TelemetryPanel.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/TelemetryPanel.xaml.cs` | ソース | スキャンロジック |
| DiagnosticsWindow.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/DiagnosticsWindow.cs` | ソース | 診断ツールウィンドウ本体（45-49行目でTelemetryPanel追加） |
| CodeAction.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Workspace/Core/CodeActions/CodeAction.cs` | ソース | CodeAction基底クラス（参考） |
