# 画面設計書 58-ワークスペースパネル

## 概要

本ドキュメントは、Roslyn Visual Studio拡張機能の診断ツールウィンドウにおいて、ワークスペースの状態を診断するパネルについて記述します。

### 本画面の処理概要

ワークスペースパネルは、Roslyn診断ツールウィンドウのタブの1つとして、現在のVisualStudioWorkspaceの状態を診断します。特に、メモリ上のソリューションスナップショットとディスク上のファイルとの整合性を検証し、同期が取れていないドキュメントを検出・報告します。

**業務上の目的・背景**：Roslynでは、ソースコードをメモリ上のスナップショットとして保持し、コード分析やIntelliSenseを提供しています。しかし、外部エディタでの変更やファイルシステムの問題により、メモリ上のスナップショットとディスク上のファイルが不整合を起こすことがあります。このパネルは、そのような不整合を検出し、言語サービスの問題診断を支援します。

**画面へのアクセス方法**：
1. Visual Studioメニューから「表示」>「その他のウィンドウ」>「Roslyn Diagnostics」を選択
2. 診断ツールウィンドウが開く
3. 「Workspace」タブを選択

**主要な操作・処理内容**：
1. 「Diagnose」ボタンでワークスペース診断を開始
2. 閉じているドキュメントのチェックサムをディスクファイルと比較
3. 不整合のあるドキュメントを報告
4. すべて同期が取れている場合はその旨を報告

**画面遷移**：該当なし（診断ツールウィンドウ内のパネル）

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | ワークスペース管理 | 主機能 | ワークスペース情報の診断表示 |

## 画面種別

UserControl（診断ツールウィンドウ内パネル）

## URL/ルーティング

該当なし（WPF UserControl）

## 入出力項目

### 入力項目（コンストラクタ）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| window | DiagnosticsWindow | ○ | 親の診断ウィンドウ（Workspaceへの参照用） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 結果テキスト | string | 診断結果のテキスト |

## 表示項目

| 項目名 | コントロール種別 | 説明 |
|--------|-----------------|------|
| プログレスバー | ProgressBar | 診断中のインジケーター |
| 結果テキスト | TextBox（ReadOnly） | 診断結果を表示 |
| Diagnoseボタン | Button | 診断開始 |

### 結果表示形式

**不整合がある場合**:
```
{ファイルパス}: {スナップショットチェックサム} : {ファイルチェックサム}
...
{不整合数} documents out of date.
```

**すべて同期している場合**:
```
All closed documents up to date.
```

## イベント仕様

### 1-Diagnoseボタン押下

ワークスペースの診断を実行します。

**処理フロー**:
1. Button.Click イベント発火
2. OnDiagnose ハンドラ実行
3. DiagnoseButtonを無効化
4. プログレスバーをIndeterminateモードに設定
5. 進捗メッセージ「Comparing in-proc solution snapshot with files on disk ...」を表示
6. バックグラウンドでDiagnoseAsync実行
7. ワークスペースからCurrentSolutionを取得
8. 全プロジェクトの全ドキュメントを走査
9. 閉じているドキュメントのみを対象
10. ドキュメントのValueTextとファイルのSourceTextを取得
11. チェックサムを比較
12. 不一致の場合は結果に追加
13. 結果をTextBoxに表示
14. プログレスバーを通常モードに戻す
15. DiagnoseButtonを再有効化

## データベース更新仕様

該当なし

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | ボタン | Diagnose | 常時表示 |
| - | 進捗 | Comparing in-proc solution snapshot with files on disk ... | 診断中 |
| - | 結果 | All closed documents up to date. | 不整合なし |
| - | 結果 | {N} documents out of date. | 不整合あり |
| - | 結果 | Workspace unavailable | ワークスペース未初期化 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|----------|
| 一般例外 | 診断中のエラー | 例外のToString()を結果として表示 |
| OperationCanceledException | キャンセル要求 | 例外をスロー（CancellationToken経由） |

## 備考

- 診断処理はバックグラウンドスレッドで並列実行されます（Task.WhenAll使用）
- 開いているドキュメント（IsDocumentOpen）はチェック対象外
- ファイルパスがnullのドキュメント（メモリ上のみ）はチェック対象外
- チェックサム計算にはドキュメントのエンコーディングとアルゴリズムを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: XAML構造を理解する

パネルのUI定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WorkspacePanel.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/WorkspacePanel.xaml` | Grid構成、コントロール配置 |

**主要処理フロー**:
1. **8-12行目**: Grid行定義（結果エリア + ボタンエリア）
2. **13-18行目**: ScrollViewer内のProgressBarとTextBox
3. **19-21行目**: ボタンパネル

#### Step 2: コンストラクタと依存関係を理解する

DiagnosticsWindowからのWorkspace取得を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WorkspacePanel.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/WorkspacePanel.xaml.cs` | コンストラクタ、_window参照 |

**主要処理フロー**:
- **25-31行目**: コンストラクタでDiagnosticsWindowを保持
- **64行目**: _window.Workspaceでワークスペース取得

#### Step 3: 診断ロジックを理解する

チェックサム比較とドキュメント走査を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WorkspacePanel.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/WorkspacePanel.xaml.cs` | DiagnoseAsync、CompareClosedDocumentsWithFileSystemAsync |

**主要処理フロー**:
- **62-73行目**: DiagnoseAsync - ワークスペース取得と診断呼び出し
- **75-113行目**: CompareClosedDocumentsWithFileSystemAsync - 並列ドキュメント比較
- **81-85行目**: LINQで対象ドキュメントをフィルタリング
- **87-106行目**: CompareDocumentAsync - 個別ドキュメントの比較

### プログラム呼び出し階層図

```
DiagnosticsWindow
    │
    ├─ Workspace (VisualStudioWorkspace)
    │
    └─ TabControl
           │
           └─ WorkspacePanel (Workspaceタブ)
                  │
                  ├─ コンストラクタ(DiagnosticsWindow)
                  │
                  └─ OnDiagnose()
                         │
                         └─ DiagnoseAsync()
                                │
                                ├─ _window.Workspace取得
                                │
                                └─ CompareClosedDocumentsWithFileSystemAsync()
                                       │
                                       ├─ solution.Projects走査
                                       │
                                       ├─ project.Documents走査
                                       │
                                       ├─ フィルタリング
                                       │      ├─ FilePath != null
                                       │      └─ !IsDocumentOpen
                                       │
                                       └─ CompareDocumentAsync() (並列)
                                              │
                                              ├─ GetValueTextAsync()
                                              ├─ GetChecksum() (スナップショット)
                                              │
                                              ├─ File.OpenRead()
                                              ├─ SourceText.From()
                                              └─ GetChecksum() (ファイル)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

Diagnoseボタン押下 ────────▶ DiagnoseAsync() ─────────────▶ 結果テキスト
                                  │
                                  ├─ Workspace.CurrentSolution
                                  │
                                  └─ ドキュメント走査 (並列)
                                         │
                                         ├─ スナップショットチェックサム
                                         │
                                         └─ ファイルチェックサム
                                                │
                                                └─ 比較 ──────▶ 不整合リスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WorkspacePanel.xaml | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/WorkspacePanel.xaml` | XAML | パネルUI定義 |
| WorkspacePanel.xaml.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/WorkspacePanel.xaml.cs` | ソース | 診断ロジック |
| DiagnosticsWindow.cs | `src/VisualStudio/VisualStudioDiagnosticsToolWindow/DiagnosticsWindow.cs` | ソース | 診断ツールウィンドウ本体（51-55行目でWorkspacePanel追加） |
| VisualStudioWorkspace.cs | `src/VisualStudio/Core/Def/VisualStudioWorkspace.cs` | ソース | ワークスペース実装（参考） |
