# 画面設計書 59-App.xaml（テスト用）

## 概要

本ドキュメントは、RoslynのMSBuildワークスペーステスト用に使用されるサンプルApp.xamlファイルについて記述します。

### 本画面の処理概要

このApp.xamlは、MSBuildワークスペースのテストプロジェクトで使用されるサンプルWPFアプリケーション定義ファイルです。実際のユーザー向け画面ではなく、MSBuildワークスペースがXAMLファイルを含むプロジェクトを正しく読み込めることを検証するためのテストリソースです。

**業務上の目的・背景**：RoslynのMSBuildワークスペースは、Visual StudioソリューションやMSBuildプロジェクトファイルを読み込んで解析する機能を提供します。WPFプロジェクトではXAMLファイルが含まれるため、MSBuildワークスペースがこれらのファイルを正しく扱えることを確認する必要があります。このサンプルApp.xamlは、そのような機能テストのために使用されます。

**画面へのアクセス方法**：このファイルはテストリソースのため、直接アクセスする画面ではありません。テスト実行時にMSBuildワークスペースによって読み込まれます。

**主要な操作・処理内容**：
1. WPFアプリケーションのエントリーポイント定義
2. StartupUri="MainWindow.xaml"でメインウィンドウを指定
3. Application.Resourcesで共有リソースを定義（現在は空）

**画面遷移**：
- 遷移先：MainWindow.xaml（StartupUri経由）

**権限による表示制御**：該当なし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | MSBuildワークスペース | 補助機能 | MSBuildテスト用のサンプルアプリケーション定義 |

## 画面種別

テスト用リソース（WPF Application定義）

## URL/ルーティング

該当なし（WPFアプリケーション定義）

## 入出力項目

該当なし（テスト用サンプル）

## 表示項目

### Application定義

| 属性 | 値 | 説明 |
|------|-----|------|
| x:Class | bug13338.App | アプリケーションクラス名 |
| StartupUri | MainWindow.xaml | 起動時に表示するウィンドウ |

### Application.Resources

空のリソースディクショナリ（サンプル）

## イベント仕様

該当なし（サンプルファイル）

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし

## 例外処理

該当なし

## 備考

- このファイルはMSBuildワークスペーステスト用のサンプルリソースです
- ファイル名「bug13338」は、このテストリソースが作成された元のバグ番号を示している可能性があります
- 実際のアプリケーションとしては機能しません（テスト用途のみ）
- MainWindow.xamlとセットで使用されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: XAMLファイル構造を理解する

サンプルApp.xamlの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | App.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/App.xaml` | WPFアプリケーション定義の基本構造 |

**読解のコツ**:
- `x:Class`属性はコードビハインドのクラス名を指定
- `StartupUri`属性は起動時のウィンドウを指定
- `Application.Resources`はアプリケーション全体の共有リソースを定義

#### Step 2: 関連するMainWindowを理解する

StartupUriで参照されるMainWindow.xamlを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainWindow.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/MainWindow.xaml` | メインウィンドウの定義 |

### プログラム呼び出し階層図

```
MSBuildワークスペーステスト
    │
    └─ テストプロジェクト読み込み
           │
           ├─ App.xaml
           │      └─ StartupUri: MainWindow.xaml
           │
           └─ MainWindow.xaml
```

### データフロー図

```
[入力]                      [処理]                         [出力]

テストプロジェクト ────────▶ MSBuildワークスペース ────────▶ XAMLファイル解析結果
                                  │
                                  ├─ App.xaml読み込み
                                  │
                                  └─ MainWindow.xaml読み込み
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| App.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/App.xaml` | テストリソース | WPFアプリケーション定義サンプル |
| MainWindow.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/MainWindow.xaml` | テストリソース | メインウィンドウ定義サンプル |
| MSBuildWorkspaceTests.cs | `src/Workspaces/MSBuild/Test/MSBuildWorkspaceTests.cs` | テスト | MSBuildワークスペーステスト（参考） |
