# 画面設計書 6-名前空間移動ダイアログ

## 概要

本ドキュメントは、型を別の名前空間に移動するためのダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

名前空間移動ダイアログは、クラス、構造体、インターフェース等の型を異なる名前空間に移動するリファクタリング機能を提供する画面である。

**業務上の目的・背景**：プロジェクトの成長に伴い、型の論理的な配置を見直す必要がある。名前空間の再構成は、using文の更新、完全修飾名の変更など多くのファイルに影響する。本ダイアログは、移動先の名前空間を入力または選択し、すべての参照を自動的に更新することで、安全な名前空間移動を実現する。

**画面へのアクセス方法**：エディタ内で型定義にカーソルを置き、コンテキストメニューまたはクイックアクションから「Move to namespace...」を選択する。

**主要な操作・処理内容**：
1. 移動先名前空間の入力または選択
2. 入力補完（既存の名前空間候補を表示）
3. 履歴からの選択（過去に使用した名前空間）
4. 入力検証とエラー表示
5. OKボタンで移動実行、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：エディタコンテキストメニュー、クイックアクション
- 遷移先：なし
- 戻り先：エディタ（OK/Cancel時）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 66 | 名前空間移動 | 主機能 | 型を別の名前空間に移動する設定 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| NamespaceName | 入出力 | string | Yes | 移動先の名前空間 |
| AvailableNamespaces | 入力 | List<NamespaceItem> | Yes | 利用可能な名前空間候補 |
| CanSubmit | 出力 | bool | Yes | 送信可能かどうか |
| Message | 出力 | string | No | エラー/警告メッセージ |
| Icon | 出力 | ImageMoniker | No | メッセージアイコン |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| 名前空間入力 | NamespaceName | 編集可能ComboBox | 移動先名前空間の入力/選択 |
| 候補リスト | AvailableNamespaces | ComboBoxドロップダウン | 既存名前空間と履歴 |
| 履歴アイコン | IsFromHistory | CrispImage | 履歴からの候補を示すアイコン |
| メッセージアイコン | Icon | CrispImage | エラー/警告アイコン |
| メッセージ | Message | LiveTextBlock | バリデーションメッセージ |

## イベント仕様

### 1-名前空間入力変更

名前空間をテキスト入力または候補から選択するとNamespaceNameプロパティが更新され、バリデーションが実行される。

### 2-バリデーション

入力された名前空間に対して以下を検証：
- 有効な識別子形式か
- 既存の名前空間との競合はないか
- 現在の名前空間と同じでないか

結果に応じてMessage、Icon、CanSubmitプロパティが更新される。

### 3-候補選択

ComboBoxのドロップダウンから候補を選択。履歴からの候補にはHistoryアイコンが表示される。

### 4-OK確定

CanSubmit=trueの場合のみDialogResult=trueで閉じる。

### 5-キャンセル

DialogResult=falseでダイアログを閉じる。

## データベース更新仕様

該当なし（データベースアクセスなし、ソースコードリファクタリング操作）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| エラー | ERR_INVALID_NAMESPACE | 無効な名前空間です | 不正な識別子形式時 |
| 警告 | WARN_SAME_NAMESPACE | 現在の名前空間と同じです | 同一名前空間入力時 |
| 情報 | INFO_NEW_NAMESPACE | 新しい名前空間が作成されます | 存在しない名前空間入力時 |

## 例外処理

| 状態 | 対応 |
|------|------|
| 名前空間が無効 | OKボタンを無効化、エラーメッセージ表示 |
| 参照更新不可 | ダイアログ表示せずエラー通知 |

## 備考

- ダイアログサイズ: 400x166（最小400x166）
- リサイズ可能（CanResizeWithGrip）
- 編集可能ComboBox（IsEditable=True, IsReadOnly=False）
- ThemedDialogStyleLoaderでデフォルトスタイル適用
- 履歴機能により直近使用した名前空間を優先表示
- ドロップダウン最大高さ200px

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MoveToNamespaceDialogViewModel.cs | `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialogViewModel.cs` | ダイアログ全体のViewModel |
| 1-2 | NamespaceItem.cs | `src/VisualStudio/Core/Def/MoveToNamespace/NamespaceItem.cs` | 名前空間候補の表現 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MoveToNamespaceDialog.xaml.cs | `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml.cs` | ダイアログのコードビハインド |

**主要処理フロー**:
1. **行25-35**: コンストラクタでViewModelをバインド、ロード完了時にフォーカス移動
2. **行37-38**: Cancel_ClickでDialogResult=false
3. **行42-48**: OK_ClickでCanSubmit確認後にDialogResult=true

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MoveToNamespaceDialog.xaml | `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml` | ダイアログUI定義 |

**主要処理フロー**:
- **行33-75**: NamespaceBoxセクション（ラベル、ComboBox）
- **行77-92**: メッセージ表示セクション（アイコン、テキスト）
- **行94-114**: OK/Cancelボタン

### プログラム呼び出し階層図

```
MoveToNamespaceDialog (UI)
    │
    ├─ MoveToNamespaceDialogViewModel
    │      ├─ NamespaceName (入力値)
    │      ├─ AvailableNamespaces (候補リスト)
    │      │      └─ NamespaceItem
    │      │             ├─ Namespace
    │      │             └─ IsFromHistory
    │      │
    │      ├─ Message / Icon (バリデーション結果)
    │      └─ CanSubmit (送信可否)
    │
    └─ ComboBox (編集可能)
           └─ ItemTemplate
                  └─ 履歴アイコン + 名前空間テキスト
```

### データフロー図

```
[入力]                    [処理]                         [出力]

現在の名前空間 ─────▶ MoveToNamespaceDialog ───────▶ 新しい名前空間
     │                       │                           │
     ├─ 既存名前空間リスト    │                           └─ すべての参照を更新
     └─ 使用履歴             │
                            ▼
                    MoveToNamespaceResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MoveToNamespaceDialog.xaml | `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml` | XAML | ダイアログUI定義 |
| MoveToNamespaceDialog.xaml.cs | `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml.cs` | ソース | コードビハインド |
| MoveToNamespaceDialogViewModel.cs | `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialogViewModel.cs` | ソース | ViewModel |
| NamespaceItem.cs | `src/VisualStudio/Core/Def/MoveToNamespace/NamespaceItem.cs` | ソース | 名前空間候補データ |
| KnownMonikers.History | Microsoft.VisualStudio.ImageCatalog | リソース | 履歴アイコン |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
