# 画面設計書 60-MainWindow.xaml（テスト用）

## 概要

本ドキュメントは、RoslynのMSBuildワークスペーステスト用に使用されるサンプルMainWindow.xamlファイルについて記述します。

### 本画面の処理概要

このMainWindow.xamlは、MSBuildワークスペースのテストプロジェクトで使用されるサンプルWPFウィンドウ定義ファイルです。実際のユーザー向け画面ではなく、MSBuildワークスペースがXAMLファイルを含むプロジェクトを正しく読み込めることを検証するためのテストリソースです。

**業務上の目的・背景**：RoslynのMSBuildワークスペースは、Visual StudioソリューションやMSBuildプロジェクトファイルを読み込んで解析する機能を提供します。WPFプロジェクトではウィンドウを定義するXAMLファイルが含まれるため、MSBuildワークスペースがこれらのファイルを正しく扱えることを確認する必要があります。このサンプルMainWindow.xamlは、App.xamlと共にそのような機能テストのために使用されます。

**画面へのアクセス方法**：このファイルはテストリソースのため、直接アクセスする画面ではありません。テスト実行時にMSBuildワークスペースによって読み込まれます。

**主要な操作・処理内容**：
1. WPFウィンドウの基本定義
2. タイトル "MainWindow"
3. サイズ設定（高さ350px、幅525px）
4. Gridレイアウトコンテナ（空）

**画面遷移**：
- 遷移元：App.xaml（StartupUri経由）

**権限による表示制御**：該当なし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | MSBuildワークスペース | 補助機能 | MSBuildテスト用のサンプルウィンドウ定義 |

## 画面種別

テスト用リソース（WPF Window定義）

## URL/ルーティング

該当なし（WPFウィンドウ定義）

## 入出力項目

該当なし（テスト用サンプル）

## 表示項目

### Window定義

| 属性 | 値 | 説明 |
|------|-----|------|
| x:Class | bug13338.MainWindow | ウィンドウクラス名 |
| Title | MainWindow | ウィンドウタイトル |
| Height | 350 | ウィンドウ高さ（ピクセル） |
| Width | 525 | ウィンドウ幅（ピクセル） |

### レイアウト

| コントロール | 説明 |
|-------------|------|
| Grid | 空のGridレイアウトコンテナ |

## イベント仕様

該当なし（サンプルファイル）

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし

## 例外処理

該当なし

## 備考

- このファイルはMSBuildワークスペーステスト用のサンプルリソースです
- ファイル名「bug13338」は、このテストリソースが作成された元のバグ番号を示している可能性があります
- 実際のアプリケーションとしては機能しません（テスト用途のみ）
- App.xamlとセットで使用されます
- Gridは空で、コンテンツが定義されていないミニマルな構造です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: XAMLファイル構造を理解する

サンプルMainWindow.xamlの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainWindow.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/MainWindow.xaml` | WPFウィンドウ定義の基本構造 |

**読解のコツ**:
- `x:Class`属性はコードビハインドのクラス名を指定
- `Title`、`Height`、`Width`はウィンドウの基本プロパティ
- `Grid`はWPFの標準レイアウトコンテナ

#### Step 2: 関連するApp.xamlを理解する

このウィンドウを起動するApp.xamlを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | App.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/App.xaml` | StartupUriからの参照 |

### プログラム呼び出し階層図

```
MSBuildワークスペーステスト
    │
    └─ テストプロジェクト読み込み
           │
           ├─ App.xaml
           │      └─ StartupUri: MainWindow.xaml
           │
           └─ MainWindow.xaml ◀─ 現在のファイル
                  │
                  └─ Grid (空)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

テストプロジェクト ────────▶ MSBuildワークスペース ────────▶ XAMLファイル解析結果
                                  │
                                  ├─ App.xaml読み込み
                                  │
                                  └─ MainWindow.xaml読み込み ◀─ 現在のファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainWindow.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/MainWindow.xaml` | テストリソース | メインウィンドウ定義サンプル |
| App.xaml | `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/App.xaml` | テストリソース | WPFアプリケーション定義サンプル |
| MSBuildWorkspaceTests.cs | `src/Workspaces/MSBuild/Test/MSBuildWorkspaceTests.cs` | テスト | MSBuildワークスペーステスト（参考） |
