# 画面設計書 7-メンバー引き上げダイアログ

## 概要

本ドキュメントは、派生クラスのメンバーを基底クラスまたはインターフェースに引き上げるためのダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

メンバー引き上げダイアログは、派生クラスのメンバー（メソッド、プロパティ、イベント等）を基底型に移動または抽出するリファクタリング機能を提供する画面である。

**業務上の目的・背景**：継承階層の設計において、共通機能を基底クラスに集約したり、インターフェースに抽象化したりする必要がある。本ダイアログは、引き上げ先の基底型の選択と、引き上げるメンバーの選択を行うインターフェースを提供し、安全にメンバー移動を実行する。

**画面へのアクセス方法**：エディタ内でメンバー定義にカーソルを置き、コンテキストメニューまたはクイックアクションから「Pull members up...」を選択する。

**主要な操作・処理内容**：
1. 引き上げ先の基底型をTreeViewから選択
2. 引き上げるメンバーをDataGridから選択
3. 抽象メンバーとして引き上げるかの選択（Make abstract）
4. 全選択/全解除/依存メンバー選択ボタン
5. OKボタンで引き上げ実行、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：エディタコンテキストメニュー、クイックアクション
- 遷移先：メンバー引き上げ警告ダイアログ（追加変更が必要な場合）
- 戻り先：エディタ（OK/Cancel時）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | メンバー引き上げ | 主機能 | メンバーを基底型に引き上げる設定 |
| 137 | メンバー選択 | 補助機能 | 引き上げるメンバーの選択操作（MemberSelectionコントロール使用） |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| DestinationTreeNodeViewModel | 入力 | BaseTypeTreeNodeViewModel | Yes | 引き上げ先の基底型階層 |
| SelectedDestination | 出力 | BaseTypeTreeNodeViewModel | Yes | 選択された引き上げ先 |
| MemberSelectionViewModel | 入力 | MemberSelectionViewModel | Yes | 選択可能なメンバー一覧 |
| OkButtonEnabled | 出力 | bool | Yes | OKボタンの有効状態 |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| 説明ラベル | Description | Label | 操作説明テキスト |
| 引き上げ先選択 | DestinationTreeNodeViewModel | TreeView | 基底型の階層表示 |
| 基底型アイコン | Glyph | Image | 型アイコン（クラス/インターフェース） |
| 基底型名 | SymbolName | TextBlock | 型名（名前空間をTooltipで表示） |
| メンバー一覧 | MemberSelectionViewModel | MemberSelectionコントロール | 引き上げ候補メンバー |

## イベント仕様

### 1-引き上げ先選択変更

TreeViewで基底型を選択すると、SelectedDestinationプロパティが更新される。選択された型に応じて、引き上げ可能なメンバーが更新される。

### 2-メンバー選択変更

MemberSelectionコントロール内のDataGridでメンバーを選択/解除。OkButtonEnabledの状態が更新される。

### 3-抽象化選択変更

メンバーごとに「Make abstract」チェックボックスを切り替え。インターフェースへの引き上げ時は自動的に抽象化される。

### 4-全選択ボタン（Select All）

すべてのチェック可能なメンバーを選択状態にする。

### 5-全解除ボタン（Deselect All）

すべてのメンバーの選択を解除する。

### 6-依存メンバー選択ボタン（Select Dependents）

選択されたメンバーが依存する他のメンバーも自動的に選択する。

### 7-OK確定

CreatePullMemberUpOptions()を呼び出し、追加変更が必要な場合は警告ダイアログを表示。確認後、DialogResult=trueで閉じる。

### 8-キャンセル

DialogResult=falseでダイアログを閉じる。

## データベース更新仕様

該当なし（データベースアクセスなし、ソースコードリファクタリング操作）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| エラー | ERR_NO_DESTINATION | 引き上げ先を選択してください | 引き上げ先未選択時 |
| エラー | ERR_NO_MEMBERS | 少なくとも1つのメンバーを選択してください | メンバー未選択時 |
| 警告 | WARN_ADDITIONAL_CHANGES | 追加の変更が必要です | 警告ダイアログ表示時 |

## 例外処理

| 状態 | 対応 |
|------|------|
| 引き上げ先が見つからない | ダイアログを表示せずエラー通知 |
| 依存関係解決失敗 | エラーメッセージを表示 |

## 備考

- ダイアログサイズ: 500x498（最小510x498）
- リサイズ可能（CanResizeWithGrip）
- TreeViewで基底型階層を展開表示（IsExpanded=True）
- 選択された型はFontWeight="Bold"で強調
- ThemedImageSourceConverterでテーマに応じたアイコン表示
- MemberSelectionコントロールを使用（共通コンポーネント）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PullMemberUpDialogViewModel.cs | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialogViewModel.cs` | ダイアログ全体のViewModel |
| 1-2 | BaseTypeTreeNodeViewModel.cs | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/BaseTypeTreeNodeViewModel.cs` | 基底型ツリーノードのViewModel |
| 1-3 | PullMembersUpOptions.cs | `src/Features/Core/Portable/PullMemberUp/PullMembersUpOptions.cs` | 引き上げオプションのデータ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PullMemberUpDialog.xaml.cs | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml.cs` | ダイアログのコードビハインド |

**主要処理フロー**:
1. **行31-42**: コンストラクタでViewModelをバインド、MemberSelectionコントロール初期化
2. **行44-58**: OKButton_ClickでCreatePullMemberUpOptions実行、追加変更が必要なら警告ダイアログ表示
3. **行60-65**: ShowWarningDialogで警告ダイアログをモーダル表示
4. **行67**: CancelButton_ClickでDialogResult=false
5. **行69-75**: Destination_SelectedItemChangedで引き上げ先選択更新

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PullMemberUpDialog.xaml | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml` | メインダイアログUI |
| 3-2 | MemberSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` | メンバー選択コントロール |

**主要処理フロー**:
- **行64-69**: 説明ラベル
- **行70-128**: DestinationSelectionGroupBox（TreeViewで基底型選択）
- **行129-138**: MemberSelectionLabel（MemberSelectionコントロール）
- **行139-165**: OK/Cancelボタン

### プログラム呼び出し階層図

```
PullMemberUpDialog (UI)
    │
    ├─ PullMemberUpDialogViewModel
    │      ├─ DestinationTreeNodeViewModel
    │      │      └─ BaseTypeTreeNodeViewModel (ツリーノード)
    │      │             ├─ SymbolName / Namespace
    │      │             ├─ Glyph (アイコン)
    │      │             └─ BaseTypeNodes (子ノード)
    │      │
    │      ├─ SelectedDestination (選択された引き上げ先)
    │      ├─ MemberSelectionViewModel (メンバー選択)
    │      ├─ OkButtonEnabled
    │      └─ CreatePullMemberUpOptions
    │
    ├─ MemberSelection (共通コントロール)
    │
    └─ PullMemberUpWarningDialog (サブダイアログ)
           └─ 追加変更の警告表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

元クラス情報 ──────▶ PullMemberUpDialog ─────────▶ 基底型へのメンバー移動
     │                       │                           │
     ├─ 基底型階層           │                           ├─ 引き上げられたメンバー
     ├─ メンバー一覧         │                           └─ 抽象メンバー化（オプション）
     └─ 依存関係             │
                            ▼
                    ┌────────────────────┐
                    │ 追加変更が必要？   │
                    └────────┬───────────┘
                             │
              ┌──────────────┼──────────────┐
              Yes            │              No
              ▼              │              ▼
    PullMemberUpWarningDialog│      DialogResult=true
              │              │
              └──────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PullMemberUpDialog.xaml | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml` | XAML | ダイアログUI定義 |
| PullMemberUpDialog.xaml.cs | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml.cs` | ソース | コードビハインド |
| PullMemberUpDialogViewModel.cs | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialogViewModel.cs` | ソース | ViewModel |
| BaseTypeTreeNodeViewModel.cs | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/BaseTypeTreeNodeViewModel.cs` | ソース | ツリーノードViewModel |
| PullMemberUpWarningDialog.xaml | `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml` | XAML | 警告ダイアログUI |
| MemberSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` | XAML | メンバー選択コントロール |
| VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | リソース | テーマ定義 |
