# 画面設計書 8-メンバー引き上げ警告ダイアログ

## 概要

本ドキュメントは、メンバー引き上げ操作において追加の変更が必要な場合に表示される警告ダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

メンバー引き上げ警告ダイアログは、メンバー引き上げ操作を完了するために必要な追加変更（abstractキーワードの追加、アクセス修飾子の変更等）をユーザーに通知し、確認を求める画面である。

**業務上の目的・背景**：メンバーを基底型に引き上げる際、単純なコード移動では済まない場合がある。例えば、インターフェースへの引き上げ時にはメンバーを抽象化する必要があり、アクセス修飾子の調整が必要になることもある。本ダイアログは、これらの追加変更をレビューし、確認してから実行する機会を提供する。

**画面へのアクセス方法**：メンバー引き上げダイアログでOKボタンをクリックした際、追加変更が必要な場合に自動的に表示される。

**主要な操作・処理内容**：
1. 追加変更の一覧をListViewで確認
2. Finishボタンで変更を確定し実行
3. Backボタンでメンバー引き上げダイアログに戻る

**画面遷移**：
- 遷移元：メンバー引き上げダイアログ（追加変更が必要な場合）
- 遷移先：なし
- 戻り先：メンバー引き上げダイアログ（Back時）、エディタ（Finish時）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | メンバー引き上げ | 主機能 | 引き上げに必要な追加変更の確認 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| WarningMessageContainer | 入力 | List<string> | Yes | 警告メッセージ一覧 |
| ProblemsListViewAutomationText | 入力 | string | No | アクセシビリティ用テキスト |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| 説明テキスト | Description | GroupBox Header | 追加変更が必要な理由 |
| 問題一覧 | WarningMessageContainer | ListView | 追加変更の詳細リスト |
| 問題テキスト | 各メッセージ | TextBlock（WrapPanel内） | 個別の変更内容 |

## イベント仕様

### 1-Finish確定

FunctionId.PullMembersUpWarning_UserProceedToFinishをログに記録し、DialogResult=trueで閉じる。親ダイアログに戻り、リファクタリングが実行される。

### 2-Back戻る

FunctionId.PullMembersUpWarning_UserGoBackをログに記録し、DialogResult=falseで閉じる。親のメンバー引き上げダイアログに戻り、選択を変更できる。

## データベース更新仕様

該当なし（データベースアクセスなし）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| 警告 | WARN_ADDITIONAL_CHANGES | リファクタリングを完了するには追加の変更が必要です。以下の変更を確認してください。 | 常時表示 |
| 情報 | INFO_MAKE_ABSTRACT | メンバー 'xxx' を抽象化します | 抽象化が必要なメンバーがある場合 |
| 情報 | INFO_CHANGE_ACCESS | メンバー 'xxx' のアクセス修飾子を変更します | アクセス修飾子変更が必要な場合 |

## 例外処理

| 状態 | 対応 |
|------|------|
| 警告メッセージなし | ダイアログを表示せずに処理続行 |

## 備考

- ダイアログサイズ: 533x390（最小533x390）
- SizeToContent="WidthAndHeight"（内容に合わせて調整）
- リサイズ可能（CanResizeWithGrip）
- ListView内のTextBlockはWrapPanelでラップ
- ScrollViewer.VerticalScrollBarVisibility="Auto"
- SelectionMode="Single"
- テレメトリログ記録（FunctionId.PullMembersUpWarning_*）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PullMemberUpWarningViewModel.cs | `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningViewModel.cs` | 警告メッセージを生成するViewModel |
| 1-2 | PullMembersUpOptions.cs | `src/Features/Core/Portable/PullMemberUp/PullMembersUpOptions.cs` | 引き上げオプション（追加変更フラグを含む） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PullMemberUpWarningDialog.xaml.cs | `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml.cs` | ダイアログのコードビハインド |

**主要処理フロー**:
1. **行21-25**: コンストラクタでViewModelをバインド
2. **行27-31**: FinishButton_ClickでログとDialogResult=true
3. **行33-37**: BackButton_ClickでログとDialogResult=false

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PullMemberUpWarningDialog.xaml | `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml` | ダイアログUI定義 |

**主要処理フロー**:
- **行28-60**: ProblemsGroupBox（説明とListView）
- **行41-59**: ProblemsListView（警告メッセージ一覧）
- **行61-85**: Finish/Backボタン

### プログラム呼び出し階層図

```
PullMemberUpDialog.OKButton_Click
    │
    └─ CreatePullMemberUpOptions
           │
           └─ PullUpOperationNeedsToDoExtraChanges == true
                  │
                  └─ PullMemberUpWarningDialog (モーダル表示)
                         │
                         ├─ PullMemberUpWarningViewModel
                         │      └─ WarningMessageContainer (警告一覧)
                         │
                         ├─ FinishButton_Click
                         │      └─ Logger.Log(PullMembersUpWarning_UserProceedToFinish)
                         │             └─ DialogResult = true → リファクタリング実行
                         │
                         └─ BackButton_Click
                                └─ Logger.Log(PullMembersUpWarning_UserGoBack)
                                       └─ DialogResult = false → 親ダイアログに戻る
```

### データフロー図

```
[入力]                    [処理]                         [出力]

PullMembersUpOptions ──▶ PullMemberUpWarningDialog ──▶ 確認結果
     │                       │
     └─ 追加変更リスト       │
                            ▼
                    ┌────────────────────┐
                    │  Finish / Back     │
                    └────────┬───────────┘
                             │
              ┌──────────────┼──────────────┐
            Finish           │            Back
              ▼              │              ▼
    DialogResult=true        │      DialogResult=false
    (リファクタリング実行)    │      (親ダイアログに戻る)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PullMemberUpWarningDialog.xaml | `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml` | XAML | ダイアログUI定義 |
| PullMemberUpWarningDialog.xaml.cs | `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml.cs` | ソース | コードビハインド |
| PullMemberUpWarningViewModel.cs | `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningViewModel.cs` | ソース | ViewModel |
| PullMembersUpOptions.cs | `src/Features/Core/Portable/PullMemberUp/PullMembersUpOptions.cs` | ソース | 引き上げオプション |
| FunctionId.cs | `src/Workspaces/Core/Portable/Log/FunctionId.cs` | ソース | テレメトリID定義 |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
