# 画面設計書 9-メンバー選択ダイアログ

## 概要

本ドキュメントは、クラスのメンバーを汎用的に選択するためのダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

メンバー選択ダイアログは、様々なリファクタリング操作（コンストラクタ生成、等値メソッド生成等）で必要なメンバーを選択するための汎用的な画面である。

**業務上の目的・背景**：コンストラクタの自動生成、Equals/GetHashCodeのオーバーライド、IEquatableの実装など、複数のメンバーを選択して処理を行うリファクタリングは多数存在する。本ダイアログは、これらの機能で共通して使用できる汎用的なメンバー選択インターフェースを提供する。

**画面へのアクセス方法**：エディタ内でクラス定義にカーソルを置き、コンテキストメニューまたはクイックアクションから対応する機能（「Generate constructor」「Generate Equals and GetHashCode」等）を選択する。

**主要な操作・処理内容**：
1. メンバー一覧から選択（チェックボックス）
2. メンバーの検索フィルタリング
3. メンバーの並び順変更（上/下移動）
4. 全選択/全解除
5. オプション設定（機能固有のチェックボックス）
6. OKボタンで確定、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：エディタコンテキストメニュー、クイックアクション
- 遷移先：なし
- 戻り先：エディタ（OK/Cancel時）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 137 | メンバー選択 | 主機能 | 汎用的なメンバー選択操作 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| MemberContainers | 入出力 | List<MemberSymbolViewModel> | Yes | 選択可能なメンバー一覧 |
| SelectedIndex | 入出力 | int | No | 現在選択中のインデックス |
| CanMoveUp | 出力 | bool | No | 上移動可能か |
| CanMoveDown | 出力 | bool | No | 下移動可能か |
| Options | 入出力 | List<PickMembersOption> | No | 機能固有オプション |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| 検索ボックス | SearchTextBox | TextBox | メンバー名でフィルタリング |
| メンバー一覧 | MemberContainers | ListView | 選択可能なメンバー |
| メンバーチェック | IsChecked | CheckBox | メンバー選択状態 |
| メンバーアイコン | Glyph | Image | メンバー種別アイコン |
| メンバー名 | SymbolName | TextBlock | メンバー名 |
| 上移動ボタン | CanMoveUp | Button (MoveUp icon) | 選択メンバーを上に移動 |
| 下移動ボタン | CanMoveDown | Button (MoveDown icon) | 選択メンバーを下に移動 |
| オプション一覧 | Options | ItemsControl + CheckBox | 機能固有オプション |

## イベント仕様

### 1-検索テキスト変更

検索ボックスにテキストを入力すると、Filter()メソッドが呼ばれメンバー一覧がフィルタリングされる。

### 2-メンバー選択変更

ListView内のチェックボックスでメンバーを選択/解除。SelectedIndexが更新される。

### 3-上移動（MoveUp）

選択中のメンバーを一つ上の位置に移動。Alt+Upキーでも実行可能。

### 4-下移動（MoveDown）

選択中のメンバーを一つ下の位置に移動。Alt+Downキーでも実行可能。

### 5-全選択ボタン（Select All）

すべてのメンバーを選択状態にする。Alt+Sキーでも実行可能。

### 6-全解除ボタン（Deselect All）

すべてのメンバーの選択を解除する。Alt+Dキーでも実行可能。

### 7-ダブルクリック/スペースキー

選択中のメンバーのチェック状態をトグルする。

### 8-OK確定

DialogResult=trueで閉じる。

### 9-キャンセル

DialogResult=falseでダイアログを閉じる。

### キーボードショートカット

| キー | 機能 |
|-----|------|
| Alt+Up | 上移動 |
| Alt+Down | 下移動 |
| Alt+S | 全選択 |
| Alt+D | 全解除 |
| Space | 選択トグル |
| ダブルクリック | 選択トグル |

## データベース更新仕様

該当なし（データベースアクセスなし）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| なし | - | - | - |

## 例外処理

| 状態 | 対応 |
|------|------|
| メンバーなし | ダイアログを表示せずに処理続行 |

## 備考

- ダイアログサイズ: 460x380（最小460x380）
- リサイズ可能（CanResizeWithGrip）
- HasHelpButton=True
- AutomationDelegatingListViewを使用（アクセシビリティ対応）
- ThemedDialogStyleLoaderでデフォルトスタイル適用
- RoutedUICommandでMoveUp/MoveDownコマンド定義
- 検索ボックスの入力でリアルタイムフィルタリング

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PickMembersDialogViewModel.cs | `src/VisualStudio/Core/Def/PickMembers/PickMembersDialogViewModel.cs` | ダイアログ全体のViewModel |
| 1-2 | MemberSymbolViewModel.cs | `src/VisualStudio/Core/Def/Utilities/MemberSymbolViewModel.cs` | メンバー行のViewModel |
| 1-3 | PickMembersOption.cs | `src/EditorFeatures/Core/PickMembers/PickMembersOption.cs` | 機能固有オプションの定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PickMembersDialog.xaml.cs | `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml.cs` | ダイアログのコードビハインド |

**主要処理フロー**:
1. **行38-46**: コンストラクタでViewModelをバインド、コマンドバインディング設定
2. **行48-63**: SetCommandBindingsでキーボードショートカット登録
3. **行65-69**: SearchTextBox_TextChangedでフィルタリング実行
4. **行83-107**: MoveUp_Click/MoveDown_Clickで並び順変更
5. **行141-149**: ToggleCheckSelectionでチェック状態トグル

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PickMembersDialog.xaml | `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml` | ダイアログUI定義 |

**主要処理フロー**:
- **行47-54**: InputBindings（Alt+Up/Down）
- **行55-65**: Grid構成（検索、メンバー一覧、ボタン）
- **行61-65**: SearchTextBox
- **行66-122**: MemberSelectionList（ListView）
- **行124-166**: ボタン群（上下移動、全選択/解除）
- **行167-181**: Options（機能固有チェックボックス）
- **行184-206**: OK/Cancelボタン

### プログラム呼び出し階層図

```
PickMembersDialog (UI)
    │
    ├─ PickMembersDialogViewModel
    │      ├─ MemberContainers (メンバー一覧)
    │      │      └─ MemberSymbolViewModel
    │      │             ├─ IsChecked
    │      │             ├─ SymbolName / Glyph
    │      │             └─ SymbolAutomationText
    │      │
    │      ├─ Filter (検索)
    │      ├─ MoveUp / MoveDown (並び順)
    │      ├─ SelectAll / DeselectAll
    │      └─ Options (機能固有オプション)
    │
    └─ CommandBindings
           ├─ MoveUp (Alt+Up)
           ├─ MoveDown (Alt+Down)
           ├─ SelectAllClickCommand (Alt+S)
           └─ DeselectAllClickCommand (Alt+D)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

クラスメンバー一覧 ──▶ PickMembersDialog ─────────▶ 選択されたメンバー
     │                       │                           │
     ├─ 検索テキスト         │                           ├─ 並び順
     ├─ 並び順変更           │                           └─ オプション設定
     └─ オプション           │
                            ▼
                    生成コード（コンストラクタ等）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PickMembersDialog.xaml | `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml` | XAML | ダイアログUI定義 |
| PickMembersDialog.xaml.cs | `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml.cs` | ソース | コードビハインド |
| PickMembersDialogViewModel.cs | `src/VisualStudio/Core/Def/PickMembers/PickMembersDialogViewModel.cs` | ソース | ViewModel |
| MemberSymbolViewModel.cs | `src/VisualStudio/Core/Def/Utilities/MemberSymbolViewModel.cs` | ソース | メンバーViewModel |
| AutomationDelegatingListView.cs | `src/VisualStudio/Core/Def/Implementation/Utilities/AutomationDelegatingListView.cs` | ソース | アクセシビリティ対応ListView |
| KnownMonikers.MoveUp/MoveDown | Microsoft.VisualStudio.ImageCatalog | リソース | 移動ボタンアイコン |
