---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-シグネチャ変更ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **ヘルプトピックID**：実際のヘルプシステムとの整合性未確認
  2. **テレメトリ記録の詳細**：ChangeSignatureLoggerの具体的な記録内容

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml` (行1-424)
- E-02: `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml.cs` (行1-318)
- E-03: `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialogViewModel.cs` (行1-586)
- E-04: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml` (行1-163)
- E-05: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialogViewModel.cs` (行1-268)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (行2)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行2-3)
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` (行11-57)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッドシグネチャの変更（パラメータの追加、削除、並べ替え）を行う | E-06, E-03 | ○ |
| C-02 | OKボタン、キャンセルボタン、プレビュー機能あり | E-01 行404-421, 392-398 | ○ |
| C-03 | vs:DialogWindowを継承したモーダルダイアログ | E-01 行1-4 | ○ |
| C-04 | DataGridでパラメータ一覧を表示 | E-01 行90-308 | ○ |
| C-05 | パラメータの上下移動はAlt+Up/Alt+Downで実行 | E-01 行67-68 | ○ |
| C-06 | Deleteキーで削除状態をトグル | E-01 行69 | ○ |
| C-07 | パラメータ追加ダイアログへの遷移 | E-02 行157-183 | ○ |
| C-08 | シグネチャプレビュー表示機能 | E-01 行317-333, E-03 行315-331 | ○ |
| C-09 | thisパラメータは編集不可 | E-03 行67-70 | ○ |
| C-10 | シグネチャ未変更時はエラー通知 | E-03 行493-500 | ○ |
| C-11 | 型がバインドしない場合の警告アイコン表示 | E-01 行252-257 | ○ |
| C-12 | パラメータ名重複時の警告アイコン表示 | E-01 行272-277, E-03 行107-141 | ○ |
| C-13 | ハイコントラストモード対応 | E-02 行63-68 | ○ |
| C-14 | ヘルプトピックはvs.csharp.refactoring.reorder | E-02 行47-48 | ○ |
| C-15 | MoveUp/MoveDownボタンの有効/無効制御 | E-03 行405-442, E-01 行335-362 | ○ |
| C-16 | Remove/Restoreボタンの有効/無効制御 | E-03 行175-198, E-01 行371-388 | ○ |
| C-17 | ParameterViewModelでパラメータ情報を管理 | E-03 行383-403 | ○ |
| C-18 | 画面遷移図との整合性（コンテキストメニューから遷移） | E-08 行35 | ○ |
| C-19 | 機能マッピングとの整合性（シグネチャ変更が主機能） | E-07 行2 | ○ |
| C-20 | AddedParameterのIsRequiredに応じたグループ配置 | E-03 行252-265 | ○ |
| C-21 | プレビュー変更チェックボックスの存在 | E-01 行392-398 | ○ |
| C-22 | ダイアログのサイズは700x500、リサイズ可能 | E-01 行13-17 | ○ |
| C-23 | WindowStartupLocationはCenterOwner | E-01 行20 | ○ |
| C-24 | 削除されたパラメータは取り消し線で表示 | E-01 行172-179 | ○ |
| C-25 | SignatureDisplayはTextBlockで表示 | E-03 行315-331 | ○ |
| C-26 | ChangeSignatureLoggerでテレメトリ記録 | E-02 行163-167 | ○ |
| C-27 | エディタコンテキストメニューからアクセス | **根拠なし** | △ |
| C-28 | クイックアクション（電球）からアクセス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- コンテキストメニュー・クイックアクションからのアクセス方法の具体的なコード
  - 候補：`ChangeSignatureCodeRefactoringProvider.cs` / `AbstractChangeSignatureService.cs` / コマンドハンドラ実装

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - UI構成とデータバインディングは明確に文書化
- 0: 低リスク - ボタン操作とイベント処理の対応は正確
- 1: 中リスク - アクセス方法（コンテキストメニュー/クイックアクション）の詳細は別ファイル参照が必要

## 6) レビュアーチェックリスト（最小）

- [ ] パラメータ移動制約（同一グループ内のみ）の記述は実装と一致しているか
- [ ] 画面遷移図との整合性を確認したか
- [ ] 機能マッピングCSVとの整合性を確認したか
- [ ] ハイコントラストモード対応の記述は十分か
