---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-静的メンバー移動ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml` (行1-173)
- E-02: `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml.cs` (行1-61)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行11)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行15-16)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (行43, 58)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 静的メンバーを別の型に移動する | E-03 | ○ |
| C-02 | ダイアログサイズ500x498、最小210x298 | E-01 行19-21 | ○ |
| C-03 | リサイズ可能（CanResize） | E-01 行24 | ○ |
| C-04 | 編集可能ComboBox（IsEditable=True） | E-01 行51 | ○ |
| C-05 | MaxDropDownHeight=120 | E-01 行59 | ○ |
| C-06 | 履歴アイコン（KnownMonikers.History）表示 | E-01 行74-78 | ○ |
| C-07 | FullyQualifiedTypeName表示 | E-01 行83 | ○ |
| C-08 | DeclarationFileName表示 | E-01 行87 | ○ |
| C-09 | メッセージアイコン（CrispImage） | E-01 行101-106 | ○ |
| C-10 | メッセージテキスト（LiveTextBlock） | E-01 行108-111 | ○ |
| C-11 | TypeName_NamespaceOnly表示 | E-01 行127 | ○ |
| C-12 | TypeName_NameOnly表示 | E-01 行132 | ○ |
| C-13 | MemberSelectionGroupBox | E-01 行138-147 | ○ |
| C-14 | StaticMemberSelectionコントロール使用 | E-02 行33, E-01 行146 | ○ |
| C-15 | OK/Cancelボタン | E-01 行148-171 | ○ |
| C-16 | CanSubmitでOKボタン有効/無効制御 | E-01 行161, E-02 行48 | ○ |
| C-17 | ロード完了時にフォーカス移動 | E-02 行36 | ○ |
| C-18 | BooleanToVisibilityConverterでメッセージ表示制御 | E-01 行32 | ○ |
| C-19 | 機能マッピングとの整合性（静的メンバー移動が主機能） | E-04 行15 | ○ |
| C-20 | 画面遷移図との整合性 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - MoveToNamespaceダイアログと類似の構造
- 0: 低リスク - StaticMemberSelectionコントロールで静的メンバー専用のUI

## 6) レビュアーチェックリスト（最小）

- [ ] 名前空間移動ダイアログとの違いを理解しているか
- [ ] StaticMemberSelectionコントロールの仕様は正確か
- [ ] 画面遷移図との整合性を確認したか
