---
generated_at: 2026-02-10 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-静的メンバー選択コントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **SymbolViewModel.csのパス**：ファイル存在未確認
  2. **BooleanReverseConverter.csのパス**：ファイル存在未確認
  3. **依存関係計算タスクの詳細実装**：親ダイアログ側で生成される依存関係マップの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelectionViewModel.cs`（ViewModel）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コントロール名はStaticMemberSelection | E-01 行1 x:Class定義 | ○ |
| C-02 | ListBoxでメンバー一覧を表示 | E-01 行22-62 ListBox定義 | ○ |
| C-03 | SelectionMode=Multipleで複数選択可能 | E-01 行27 SelectionMode="Multiple" | ○ |
| C-04 | IsCheckedがTwoWayバインディング | E-01 行32, 48 Mode=TwoWay | ○ |
| C-05 | SymbolNameでメンバー名を表示 | E-01 行57 Text="{Binding SymbolName}" | ○ |
| C-06 | Glyphでアイコンを表示 | E-01 行52 Source="{Binding Glyph}" | ○ |
| C-07 | Select Allボタンが存在 | E-01 行70-78, E-02 行33-34 | ○ |
| C-08 | Deselect Allボタンが存在 | E-01 行79-87, E-02 行36-37 | ○ |
| C-09 | Select Dependentsボタンが存在 | E-01 行88-96, E-02 行30-31 | ○ |
| C-10 | ViewModelでMembersプロパティを管理 | E-03 行34-39 Members定義 | ○ |
| C-11 | CheckedMembersで選択済みメンバー取得 | E-03 行32 WhereAsArray実装 | ○ |
| C-12 | SelectDependentsで依存関係を計算 | E-03 行47-73 メソッド実装 | ○ |
| C-13 | BFSで依存関係を探索 | E-03 行83-107 Queue使用のBFS実装 | ○ |
| C-14 | UIThreadOperationExecutorでプログレス表示 | E-03 行52-63 Execute呼び出し | ○ |
| C-15 | 循環依存をHashSetで防止 | E-03 行88 visited HashSet | ○ |
| C-16 | 機能No.31「静的メンバーの移動」に関連 | E-05 画面No11の行 | ○ |
| C-17 | MoveStaticMembersDialogの子コントロール | E-04 No.11の備考欄 | ○ |
| C-18 | SymbolViewModel.csが存在する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SymbolViewModel.csの正確なパスと実装詳細
  - 候補：`src/VisualStudio/Core/Def/Implementation/Utilities/` / `src/VisualStudio/Core/Def/Utilities/`
- 親ダイアログ（MoveStaticMembersDialog）での本コントロールの組み込み方法の詳細

## 5) リスクフラグ（レビュー観点）
- 0: 基本的なUI構造・イベント処理
- 0: ViewModel実装
- 1: 依存関係計算ロジック（複雑なBFS探索、パフォーマンス影響の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] SymbolViewModel.csの実際のパスを確認
- [ ] BooleanReverseConverterの使用箇所を確認（XAMLでリソース登録されているが未使用の可能性）
- [ ] 依存関係計算のキャンセル処理が適切に動作するか確認
- [ ] 大規模クラスでの依存関係計算パフォーマンスを確認
