---
generated_at: 2026-02-10 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-新規型作成先選択コントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelection.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelection.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelectionViewModel.cs`（ViewModel）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コントロール名はNewTypeDestinationSelection | E-01 行1 x:Class定義 | ○ |
| C-02 | TypeNameTextBoxで型名を入力 | E-01 行39-44 TextBox定義 | ○ |
| C-03 | TypeNameがTwoWayバインディング | E-01 行41 Mode=TwoWay | ○ |
| C-04 | GeneratedNameTextBoxが読み取り専用 | E-01 行52 IsReadOnly="True" | ○ |
| C-05 | GeneratedNameがOneWayバインディング | E-01 行51 Mode=OneWay | ○ |
| C-06 | GroupBoxで作成先選択UI | E-01 行57-106 GroupBox定義 | ○ |
| C-07 | ラジオボタンでCurrentFile/NewFile選択 | E-01 行71-93 RadioButton定義 | ○ |
| C-08 | EnumBoolConverterを使用 | E-01 行21, 79, 89 Converter使用 | ○ |
| C-09 | CanAddDocumentでNewFileオプション制御 | E-01 行90 IsEnabled="{Binding CanAddDocument}" | ○ |
| C-10 | DependencyPropertyでViewModelを公開 | E-02 行18-27 ViewModelProperty定義 | ○ |
| C-11 | SelectAllInTextBoxメソッドが存在 | E-02 行49-56 メソッド実装 | ○ |
| C-12 | TypeNameセッターでFileName自動更新 | E-03 行67-75 setter実装 | ○ |
| C-13 | GeneratedNameが完全修飾名を返す | E-03 行77-87 getter実装 | ○ |
| C-14 | TrySubmitでバリデーション実行 | E-03 行109-145 メソッド実装 | ○ |
| C-15 | conflictingNamesで名前衝突チェック | E-03 行118-122 Contains呼び出し | ○ |
| C-16 | ISyntaxFactsService.IsValidIdentifier使用 | E-03 行124-128 呼び出し | ○ |
| C-17 | ファイル拡張子チェック実装 | E-03 行130-135 Equals呼び出し | ○ |
| C-18 | 不正文字チェック実装 | E-03 行137-142 IndexOfAny呼び出し | ○ |
| C-19 | 機能No.39「型生成」に関連 | E-05 画面No12の行 | ○ |
| C-20 | VSThemeDictionary.xamlを参照 | E-01 行18 MergedDictionaries | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造・レイアウト
- 0: データバインディング
- 0: バリデーションロジック
- 1: ISyntaxFactsServiceの言語別実装差異（C#/VBで動作確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] C#とVBの両方でファイル拡張子が正しく設定されることを確認
- [ ] 型名入力時にFileNameが正しく連動更新されることを確認
- [ ] CanAddDocument=falseの場合にNewFileオプションが無効化されることを確認
- [ ] 各エラーメッセージのローカライズリソースが存在することを確認
