---
generated_at: 2026-02-10 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-メンバー選択コントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Def/CommonControls/MemberSelectionViewModel.cs`（ViewModel）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コントロール名はMemberSelection | E-01 行1 x:Class定義 | ○ |
| C-02 | DataGridでメンバー一覧を表示 | E-01 行35-154 DataGrid定義 | ○ |
| C-03 | SelectionMode=Extendedで拡張選択 | E-01 行40 SelectionMode="Extended" | ○ |
| C-04 | 3列構成（チェック/メンバー/MakeAbstract） | E-01 行71-153 DataGridTemplateColumn定義 | ○ |
| C-05 | IsCheckedがTwoWayバインディング | E-01 行79 UpdateSourceTrigger=PropertyChanged | ○ |
| C-06 | MakeAbstractがTwoWayバインディング | E-01 行147 UpdateSourceTrigger=PropertyChanged | ○ |
| C-07 | Select Allボタンが存在 | E-01 行162-170, E-02 行55-56 | ○ |
| C-08 | Deselect Allボタンが存在 | E-01 行171-179, E-02 行58-59 | ○ |
| C-09 | Select Dependentsボタンが存在 | E-01 行180-189, E-02 行49-50 | ○ |
| C-10 | Select Publicボタンが存在 | E-01 行190-199, E-02 行52-53 | ○ |
| C-11 | ShowCheckDependentsButtonで表示制御 | E-01 行185 Visibility Binding | ○ |
| C-12 | ShowPublicButtonで表示制御 | E-01 行194 Visibility Binding | ○ |
| C-13 | ViewModelでMembers管理 | E-03 行50-76 Membersプロパティ | ○ |
| C-14 | CheckedMembersで選択済み取得 | E-03 行48 WhereAsArray実装 | ○ |
| C-15 | SelectDependentsで依存選択 | E-03 行101-130 メソッド実装 | ○ |
| C-16 | SelectPublicでpublic選択 | E-03 行92-93 メソッド実装 | ○ |
| C-17 | UpdateMembersBasedOnDestinationKind存在 | E-03 行138-156 メソッド実装 | ○ |
| C-18 | インターフェース時にフィールド無効化 | E-03 行146-149 IsCheckable設定 | ○ |
| C-19 | インターフェース時にMakeAbstract無効化 | E-03 行151-155 IsMakeAbstractCheckable設定 | ○ |
| C-20 | PropertyChangedでShowMakeAbstract監視 | E-02 行36-42 PropertyChanged handler | ○ |
| C-21 | UpdateAbstractColumnVisibilityメソッド存在 | E-02 行44-47 メソッド実装 | ○ |
| C-22 | 機能No.137「メンバー選択」に関連 | E-05 画面No13の行 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造・レイアウト
- 0: データバインディング
- 0: ボタン表示制御
- 1: 依存関係計算パフォーマンス（大規模クラスでの確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] インターフェース宛先時にフィールドが選択不可になることを確認
- [ ] インターフェース宛先時にMakeAbstract列が非表示になることを確認
- [ ] Select Dependentsの依存関係計算が正しく動作することを確認
- [ ] 各ダイアログ（ExtractClass/ExtractInterface/PullMemberUp）での統合動作を確認
