---
generated_at: 2026-02-10 10:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-ドキュメントアウトラインビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineViewModel.cs`（ViewModel）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラス名はDocumentOutlineView | E-01 行1 x:Class定義 | ○ |
| C-02 | 3行Gridレイアウト（Commands/Search/Tree） | E-01 行72-79 Grid.RowDefinitions | ○ |
| C-03 | VirtualizingTreeViewを使用 | E-01 行87 self:VirtualizingTreeView | ○ |
| C-04 | HierarchicalDataTemplateでツリー構造 | E-01 行95-125 HierarchicalDataTemplate | ○ |
| C-05 | ImageMonikerでシンボルアイコン表示 | E-01 行116 imaging:CrispImage Moniker | ○ |
| C-06 | Data.Nameでシンボル名表示 | E-01 行117 Text="{Binding Data.Name}" | ○ |
| C-07 | IsSelectedで選択インジケーター表示 | E-01 行121-123 DataTrigger | ○ |
| C-08 | IOleCommandTarget実装 | E-02 行36 インターフェース実装 | ○ |
| C-09 | IVsWindowSearch実装 | E-02 行36 インターフェース実装 | ○ |
| C-10 | DocumentOutlineExpandAllコマンド | E-02 行128-129, 175-177 | ○ |
| C-11 | DocumentOutlineCollapseAllコマンド | E-02 行131-133, 179-181 | ○ |
| C-12 | DocumentOutlineSortByNameコマンド | E-02 行135-140, 183-185 | ○ |
| C-13 | DocumentOutlineSortByOrderコマンド | E-02 行142-147, 187-189 | ○ |
| C-14 | DocumentOutlineSortByTypeコマンド | E-02 行149-155, 191-194 | ○ |
| C-15 | CreateSearchでSearchText設定 | E-02 行208-212 | ○ |
| C-16 | SymbolTree_SourceUpdatedでナビゲーション | E-02 行312-345 | ○ |
| C-17 | IsNavigatingフラグで再入防止 | E-02 行321, 328, 342 | ○ |
| C-18 | ViewTracker_CaretMovedOrActiveViewChanged | E-02 行384-388 | ○ |
| C-19 | DocumentSymbolViewModelItemsプロパティ | E-03 行216-234 | ○ |
| C-20 | AsyncBatchingWorkQueue使用 | E-03 行49-50, 54-55 | ○ |
| C-21 | ComputeViewStateAsync実装 | E-03 行251-342 | ○ |
| C-22 | ImmutableIntervalTree使用 | E-03 行316 | ○ |
| C-23 | 機能No.78「コード構造」に関連 | E-05 画面No14の行 | ○ |
| C-24 | 機能No.16「ナビゲーション」に関連 | E-05 画面No14の行 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造・レイアウト
- 0: コマンド実装
- 1: 非同期処理（キャンセル処理、エラーハンドリングの確認推奨）
- 1: パフォーマンス（大規模ファイルでのLSP呼び出しとツリー構築）

## 6) レビュアーチェックリスト（最小）
- [ ] 大規模ファイルでのシンボルツリー表示パフォーマンスを確認
- [ ] ソートオプションが正しく永続化されることを確認
- [ ] カーソル移動とツリー選択の連動が正しく動作することを確認
- [ ] 検索機能で日本語などのマルチバイト文字が正しくフィルタリングされることを確認
