---
generated_at: 2026-02-10 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-値追跡ルートビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml.cs`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラス名はValueTrackingRoot | E-01 行1 x:Class定義 | ○ |
| C-02 | Grid（RootGrid）が子ビューをホスト | E-01 行12 Grid x:Name="RootGrid" | ○ |
| C-03 | TextBlock（EmptyTextMessage）でガイダンス表示 | E-01 行13 TextBlock x:Name="EmptyTextMessage" | ○ |
| C-04 | EmptyTextがバインディング | E-01 行13 Text="{Binding EmptyText}" | ○ |
| C-05 | ThemedDialogDefaultStylesKeyを使用 | E-01 行11 Resources="{StaticResource...}" | ○ |
| C-06 | EmptyTextプロパティが存在 | E-02 行15 プロパティ定義 | ○ |
| C-07 | SetChildメソッドが存在 | E-02 行22-36 メソッド実装 | ○ |
| C-08 | SetChildでChildren.Clear実行 | E-02 行24 RootGrid.Children.Clear() | ○ |
| C-09 | child==nullでEmptyTextMessage表示 | E-02 行26-30 if分岐 | ○ |
| C-10 | child!=nullで子ビュー追加 | E-02 行31-35 else分岐 | ○ |
| C-11 | 機能No.86「値追跡」に関連 | E-04 画面No15の行 | ○ |
| C-12 | 画面遷移図でVTR→VTT関係 | E-05 行213 VTR -.-> VTT | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造
- 0: 子ビュー切り替えロジック

## 6) レビュアーチェックリスト（最小）
- [ ] 値追跡開始時にValueTrackingTreeが正しく表示されることを確認
- [ ] 値追跡終了/クリア時にEmptyTextMessageが正しく表示されることを確認
- [ ] ガイダンスメッセージのローカライズが正しいことを確認
