---
generated_at: 2026-02-10 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-値追跡ツリービュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTreeViewModel.cs`（ViewModel）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラス名はValueTrackingTree | E-01 行1 x:Class定義 | ○ |
| C-02 | 3列Gridレイアウト | E-01 行23-27 Grid.ColumnDefinitions | ○ |
| C-03 | ProgressBarでローディング表示 | E-01 行34-45 ProgressBar | ○ |
| C-04 | IsLoadingでProgressBar表示制御 | E-01 行43 Visibility Binding | ○ |
| C-05 | TreeViewでルートノード表示 | E-01 行47-97 TreeView | ○ |
| C-06 | ItemsSource="{Binding Roots}" | E-01 行51 | ○ |
| C-07 | HierarchicalDataTemplateでTreeItemViewModel | E-01 行65-83 | ○ |
| C-08 | DataTemplateでComputingTreeViewItem | E-01 行86-95 | ○ |
| C-09 | GridSplitterで左右リサイズ | E-01 行99-104 GridSplitter | ○ |
| C-10 | 詳細パネルでFile/Line表示 | E-01 行106-123 ScrollViewer内Grid | ○ |
| C-11 | PreviewKeyDownでキー処理 | E-02 行23-65 メソッド実装 | ○ |
| C-12 | Down/Upでアイテム選択 | E-02 行27-28 | ○ |
| C-13 | F8でナビゲート | E-02 行29 | ○ |
| C-14 | Enterでナビゲート | E-02 行30 | ○ |
| C-15 | Right/Leftで展開/折りたたみ | E-02 行31-32 | ○ |
| C-16 | Spaceでトグル | E-02 行33 | ○ |
| C-17 | MouseDoubleClickでナビゲート | E-02 行67-84 | ○ |
| C-18 | SelectedItemChangedでViewModel更新 | E-02 行124-127 | ○ |
| C-19 | ViewModelでRoots管理 | E-03 行27 ObservableCollection | ○ |
| C-20 | 機能No.86「値追跡」に関連 | E-05 画面No16の行 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造・レイアウト
- 0: キーボードナビゲーション
- 1: ツリーナビゲーションパフォーマンス（深い階層での動作確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] キーボードナビゲーション（Up/Down/Enter/F8）が正しく動作することを確認
- [ ] ダブルクリックでエディタにナビゲートすることを確認
- [ ] 詳細パネルに正しいファイル名と行番号が表示されることを確認
- [ ] プログレスバーがローディング中に表示されることを確認
