---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-スタックトレースエクスプローラールート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRootViewModel.cs`（ViewModel）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラス名はStackTraceExplorerRoot | E-01 行1 x:Class定義 | ○ |
| C-02 | 2行Gridレイアウト（ToolBar/TabControl） | E-01 行30-33 Grid.RowDefinitions | ○ |
| C-03 | ClearButtonが存在 | E-01 行35 Button x:Name="ClearButton" | ○ |
| C-04 | KnownMonikers.ClearCollectionアイコン | E-01 行38 imaging:CrispImage | ○ |
| C-05 | TabControlでタブ管理 | E-01 行44-174 TabControl | ○ |
| C-06 | ItemsSource="{Binding Tabs}" | E-01 行47 | ○ |
| C-07 | SelectedItem="{Binding SelectedTab}" | E-01 行48 | ○ |
| C-08 | カスタムTabControl.Template | E-01 行51-77 ControlTemplate | ○ |
| C-09 | 閉じるボタンがTabItemに存在 | E-01 行112-139 Button CloseClick | ○ |
| C-10 | 選択インジケーター（_underline） | E-01 行142-152 Rectangle | ○ |
| C-11 | DataObject.AddPastingHandler登録 | E-02 行27 | ○ |
| C-12 | OnClearで選択タブクリア | E-02 行33-36 | ○ |
| C-13 | OnPasteでDoPasteAsync呼び出し | E-02 行38-39 | ○ |
| C-14 | ViewModelでTabs管理 | E-03 行32 ObservableCollection | ○ |
| C-15 | DoPasteAsyncでペースト処理 | E-03 行64-83 | ○ |
| C-16 | AddNewTabAsyncで新規タブ追加 | E-03 行45-62 | ○ |
| C-17 | Tab_Closedでタブ削除 | E-03 行92-97 | ○ |
| C-18 | 機能No.85「スタックトレース探索」に関連 | E-05 画面No17の行 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造・タブ管理
- 0: ペースト処理
- 1: 大量のスタックトレース解析時のパフォーマンス（確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] Ctrl+Vでスタックトレースが正しくペーストされることを確認
- [ ] 複数タブが正しく管理されることを確認
- [ ] タブの閉じるボタンが正しく動作することを確認
- [ ] クリアボタンで現在のタブがクリアされることを確認
